/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal.commands;

import java.util.Arrays;
import java.util.List;
import javax.management.InstanceNotFoundException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.model.management.ManageableArtifact;
import org.eclipse.virgo.kernel.model.management.RuntimeArtifactModelObjectNameCreator;
import org.eclipse.virgo.kernel.shell.Command;
import org.eclipse.virgo.kernel.shell.internal.commands.AbstractInstallArtifactBasedCommands;
import org.eclipse.virgo.kernel.shell.internal.formatting.ConfigInstallArtifactCommandFormatter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Version;
import org.osgi.service.cm.ConfigurationAdmin;

@Command(value="config")
final class ConfigCommands
extends AbstractInstallArtifactBasedCommands<ManageableArtifact> {
    private static final String UNABLE_TO_EXAMINE_CONFIGURATION_IN_NON_ACTIVE_STATE;
    private static final String EMPTY_VERSION_STRING;
    private static final String TYPE = "configuration";
    private static final String STATE_ACTIVE = "ACTIVE";
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        Factory factory = new Factory("ConfigCommands.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:", "name:", "", "java.util.List"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "examine", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:java.lang.String:", "name:versionString:", "", "java.util.List"), 62);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:", "name:", "", "java.util.List"), 77);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:", "name:", "", "java.util.List"), 82);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "refresh", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:", "name:", "", "java.util.List"), 87);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "uninstall", "org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands", "java.lang.String:", "name:", "", "java.util.List"), 92);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.commands.ConfigCommands");
        UNABLE_TO_EXAMINE_CONFIGURATION_IN_NON_ACTIVE_STATE = String.format("Unable to examine configuration in non-active state", new Object[0]);
        EMPTY_VERSION_STRING = Version.emptyVersion.toString();
    }

    public ConfigCommands(RuntimeArtifactModelObjectNameCreator objectNameCreator, ConfigurationAdmin configurationAdmin) {
        super(TYPE, objectNameCreator, new ConfigInstallArtifactCommandFormatter(configurationAdmin), ManageableArtifact.class);
    }

    @Command(value="examine")
    public List<String> examine(String name) {
        try {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            List<String> list = this.examine(name, EMPTY_VERSION_STRING);
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    @Override
    public List<String> examine(String name, String versionString) {
        try {
            List<String> list;
            block5: {
                Object artifact;
                ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    artifact = this.getArtifactRetriever().getArtifact(name, ConfigCommands.convertToVersion(versionString));
                }
                catch (IllegalArgumentException iae) {
                    list = Arrays.asList(iae.getMessage());
                    break block5;
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    list = this.getDoesNotExistMessage(TYPE, name, versionString);
                    break block5;
                }
                list = STATE_ACTIVE.equals(artifact.getState()) ? super.examine(name, versionString) : Arrays.asList(UNABLE_TO_EXAMINE_CONFIGURATION_IN_NON_ACTIVE_STATE);
            }
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    @Command(value="start")
    public List<String> start(String name) {
        try {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
            List<String> list = this.start(name, EMPTY_VERSION_STRING);
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    @Command(value="stop")
    public List<String> stop(String name) {
        try {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
            List<String> list = this.stop(name, EMPTY_VERSION_STRING);
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    @Command(value="refresh")
    public List<String> refresh(String name) {
        try {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            List<String> list = this.refresh(name, EMPTY_VERSION_STRING);
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    @Command(value="uninstall")
    public List<String> uninstall(String name) {
        try {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            List<String> list = this.uninstall(name, EMPTY_VERSION_STRING);
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return list;
        }
        catch (Throwable throwable) {
            ConfigCommands.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }
}

