/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.web.internal;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.apps.admin.web.internal.DojoTreeFormatter;
import org.eclipse.virgo.apps.admin.web.internal.DojoTreeJsonFormatter;
import org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessor;
import org.eclipse.virgo.kernel.shell.model.helper.ArtifactAccessorPointer;
import org.springframework.stereotype.Component;

@Component
final class DojoTreeJsonFormatter
implements DojoTreeFormatter {
    private static final String SCOPED = "scoped";
    private static final String ATOMIC = "atomic";
    private static final String STATE = "State";
    private static final String SPRING = "spring-powered";
    private static final String SCOPED_ATOMIC = "scoped-atomic";
    private static final String BUNDLE_TYPE = "bundle";
    private static final String CONFIG_TYPE = "configuration";
    private static final String BUNDLE_LINK = "/admin/web/state/bundle.htm?name=%s&version=%s";
    private static final String CONFIG_LINK = "/admin/web/config/overview.htm#%s";

    DojoTreeJsonFormatter() {
    }

    public String formatTypes(List<String> types) {
        StringBuilder sb = new StringBuilder();
        if (types != null) {
            Collections.sort(types);
            if (types.size() > 0) {
                for (String type : types) {
                    sb.append("{");
                    sb.append("id: '").append(type).append("',");
                    sb.append("label: '").append(type).append("s',");
                    sb.append("type: '").append(type).append("',");
                    sb.append("tooltip: 'all user installed ").append(type).append("s',");
                    sb.append("children: []");
                    sb.append("},");
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public String formatArtifactsOfType(String parent, List<ArtifactAccessorPointer> artifacts) {
        StringBuilder sb = new StringBuilder();
        if (parent != null && artifacts != null) {
            Collections.sort(artifacts);
            if (artifacts.size() > 0) {
                for (ArtifactAccessorPointer artifact : artifacts) {
                    FormattingData fd = new FormattingData(sb, parent, artifact.getType(), artifact.getName(), artifact.getVersion());
                    this.renderComplexChild(fd, artifact.getState());
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    public String formatArtifactDetails(String parent, ArtifactAccessor artifact) {
        StringBuilder sb = new StringBuilder();
        if (parent != null && artifact != null) {
            Set dependents;
            Set propertiesEntrySet;
            String value;
            String key;
            FormattingData fd = new FormattingData(sb, parent, artifact.getType(), artifact.getName(), artifact.getVersion());
            if (BUNDLE_TYPE.equals(fd.type)) {
                this.renderLinkChild(fd, String.format("View this %s artifact", fd.type), String.format(BUNDLE_LINK, fd.name, fd.version));
            } else if (CONFIG_TYPE.equals(fd.type)) {
                this.renderLinkChild(fd, String.format("View this %s artifact", fd.type), String.format(CONFIG_LINK, fd.name));
            }
            Map attributes = artifact.getAttributes();
            this.processScopedAtomicAttributes(attributes);
            Set attributesEntrySet = attributes.entrySet();
            if (attributesEntrySet.size() > 0) {
                for (Map.Entry attribute : attributesEntrySet) {
                    key = (String)attribute.getKey();
                    value = attribute.getValue().toString();
                    if ("false".equals(value)) continue;
                    if (SPRING.equalsIgnoreCase(key) || SCOPED.equalsIgnoreCase(key) || ATOMIC.equalsIgnoreCase(key) || SCOPED_ATOMIC.equalsIgnoreCase(key)) {
                        this.renderCustomIconChild(fd, key, key);
                        continue;
                    }
                    if ("true".equalsIgnoreCase(value)) {
                        this.renderSimpleChild(fd, key);
                        continue;
                    }
                    if (STATE.equalsIgnoreCase(key)) {
                        this.renderCustomIconChild(fd, value, value);
                        continue;
                    }
                    this.renderSimpleChild(fd, String.format("%s: %s", key, value));
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            if ((propertiesEntrySet = artifact.getProperties().entrySet()).size() > 0) {
                sb.append(",");
                for (Map.Entry attribute : propertiesEntrySet) {
                    key = (String)attribute.getKey();
                    value = (String)attribute.getValue();
                    if ("org.eclipse.virgo.web.contextPath".equalsIgnoreCase(key)) {
                        this.renderLinkChild(fd, String.format("%s: %s", key, value), value);
                        continue;
                    }
                    if ("true".equalsIgnoreCase(value)) {
                        this.renderSimpleChild(fd, key);
                        continue;
                    }
                    this.renderSimpleChild(fd, String.format("%s: %s", key, value));
                }
                sb.deleteCharAt(sb.length() - 1);
            }
            if ((dependents = artifact.getDependents()).size() > 0) {
                sb.append(",");
                for (ArtifactAccessorPointer dependent : dependents) {
                    fd = new FormattingData(sb, parent, dependent.getType(), dependent.getName(), dependent.getVersion());
                    this.renderComplexChild(fd, dependent.getState());
                }
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        return sb.toString();
    }

    private void processScopedAtomicAttributes(Map<String, Object> attributes) {
        boolean containsAtomic = attributes.containsKey(ATOMIC);
        boolean containsScoped = attributes.containsKey(SCOPED);
        if (containsScoped && containsAtomic) {
            Object scopedObject = attributes.get(SCOPED);
            boolean scoped = Boolean.parseBoolean(scopedObject.toString());
            Object atomicObject = attributes.get(ATOMIC);
            boolean atomic = Boolean.parseBoolean(atomicObject.toString());
            if (scoped && atomic) {
                attributes.remove(SCOPED);
                attributes.remove(ATOMIC);
                attributes.put(SCOPED_ATOMIC, "true");
            }
        }
    }

    private void renderComplexChild(FormattingData fd, String state) {
        StringBuilder sb = fd.stringBuilder;
        sb.append("{");
        sb.append("id: '").append(fd.parentKey).append(fd.type).append(fd.name).append(fd.version).append("',");
        sb.append("label: '").append(fd.name).append("-").append(fd.version).append("',");
        sb.append("type: '").append(fd.type).append("',");
        sb.append("name: '").append(fd.name).append("',");
        sb.append("version: '").append(fd.version).append("',");
        sb.append("state: '").append(state).append("',");
        sb.append("tooltip: '").append(fd.type).append(" artifact',");
        sb.append("children: []");
        sb.append("},");
    }

    private void renderSimpleChild(FormattingData fd, String label) {
        StringBuilder sb = fd.stringBuilder;
        sb.append("{");
        sb.append("id: '").append(fd.parentKey).append(fd.type).append(fd.name).append(fd.version).append(label).append("',");
        sb.append("label: '").append(label).append("'");
        sb.append("},");
    }

    private void renderCustomIconChild(FormattingData fd, String label, String iconClass) {
        StringBuilder sb = fd.stringBuilder;
        sb.append("{");
        sb.append("id: '").append(fd.parentKey).append(fd.type).append(fd.name).append(fd.version).append(label).append("',");
        sb.append("label: '").append(label).append("',");
        sb.append("icon: '").append(iconClass).append("'");
        sb.append("},");
    }

    private void renderLinkChild(FormattingData fd, String linkText, String link) {
        StringBuilder sb = fd.stringBuilder;
        sb.append("{");
        sb.append("id: '").append(fd.parentKey).append(fd.type).append(fd.name).append(fd.version).append(linkText).append("',");
        sb.append("label: '").append(linkText).append("',");
        sb.append("link: '").append(link).append("'");
        sb.append("},");
    }
}

