/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.core.internal.blueprint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.core.internal.blueprint.StandardTicker;
import org.eclipse.virgo.kernel.core.internal.blueprint.Ticker;
import org.eclipse.virgo.kernel.diagnostics.KernelLogEvents;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContextDependencyMonitor
implements EventHandler {
    private static final String TOPIC_BLUEPRINT_EVENTS = "org/osgi/service/blueprint/container/";
    private static final String EVENT_WAITING = "org/osgi/service/blueprint/container/WAITING";
    private static final String EVENT_GRACE_PERIOD = "org/osgi/service/blueprint/container/GRACE_PERIOD";
    private static final String EVENT_FAILURE = "org/osgi/service/blueprint/container/FAILURE";
    private static final String EVENT_CREATED = "org/osgi/service/blueprint/container/CREATED";
    private static final int MAXIMUM_WARNING_INTERVAL = 60000;
    private static final int WARNING_INTERVAL_INCREASE_RATE_PERCENT = 200;
    private static final int INITIAL_WARNING_INTERVAL = 5000;
    private static final int SLOW_WARNING_INTERVAL = 300000;
    private final Logger logger;
    private final EventLogger eventLogger;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Map<Bundle, Map<ServiceDependency, Ticker>> tickers;
    private final Object monitor;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    public ApplicationContextDependencyMonitor(ScheduledExecutorService scheduledExecutorService, EventLogger eventLogger) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.tickers = new HashMap<Bundle, Map<ServiceDependency, Ticker>>();
            this.monitor = new Object();
            this.scheduledExecutorService = scheduledExecutorService;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                Object object = this.monitor;
                synchronized (object) {
                    Bundle bundle = (Bundle)event.getProperty("bundle");
                    if (EVENT_WAITING.equals(event.getTopic())) {
                        List<ServiceDependency> serviceDependencies = this.createServiceDependencies(event);
                        for (ServiceDependency serviceDependency : serviceDependencies) {
                            this.addServiceDependencyTicker(serviceDependency, bundle);
                        }
                    } else if (EVENT_GRACE_PERIOD.equals(event.getTopic())) {
                        List<ServiceDependency> remainingUnsatisfiedDependencies = this.createServiceDependencies(event);
                        this.changeInUnsatisfiedDependencies(remainingUnsatisfiedDependencies, bundle);
                    } else if (EVENT_FAILURE.equals(event.getTopic())) {
                        String[] dependenciesArray = (String[])event.getProperty("dependencies");
                        if (dependenciesArray != null) {
                            List<ServiceDependency> serviceDependencies = this.createServiceDependencies(event);
                            this.serviceDependenciesTimedOut(serviceDependencies, bundle);
                        } else {
                            this.containerCreationFailed(bundle);
                        }
                    } else if (EVENT_CREATED.equals(event.getTopic())) {
                        this.containerCreated(bundle);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void serviceDependenciesTimedOut(List<ServiceDependency> timedOutDependencies, Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                Map<ServiceDependency, Ticker> bundlesTickers = this.tickers.get(bundle);
                if (bundlesTickers != null) {
                    for (ServiceDependency timedOutDependency : timedOutDependencies) {
                        Ticker ticker = bundlesTickers.remove(timedOutDependency);
                        if (ticker == null) continue;
                        this.dependencyTimedOut(timedOutDependency, ticker, bundle);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void containerCreationFailed(Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                Map<ServiceDependency, Ticker> tickers = this.tickers.remove(bundle);
                if (tickers != null) {
                    for (Map.Entry<ServiceDependency, Ticker> ticker : tickers.entrySet()) {
                        ticker.getValue().cancel();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private void containerCreated(Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                Map<ServiceDependency, Ticker> bundlesTickers = this.tickers.remove(bundle);
                if (bundlesTickers != null) {
                    for (Map.Entry<ServiceDependency, Ticker> entry : bundlesTickers.entrySet()) {
                        this.dependencySatisfied(entry.getKey(), entry.getValue(), bundle);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void changeInUnsatisfiedDependencies(List<ServiceDependency> remainingUnsatisfiedDependencies, Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            try {
                Map<ServiceDependency, Ticker> tickers = this.tickers.get(bundle);
                if (tickers != null) {
                    Iterator<Map.Entry<ServiceDependency, Ticker>> entries = tickers.entrySet().iterator();
                    while (entries.hasNext()) {
                        Map.Entry<ServiceDependency, Ticker> entry = entries.next();
                        if (remainingUnsatisfiedDependencies.contains(entry.getKey())) continue;
                        this.dependencySatisfied(entry.getKey(), entry.getValue(), bundle);
                        entries.remove();
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private void dependencySatisfied(ServiceDependency serviceDependency, Ticker ticker, Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            try {
                this.logger.info("Service dependency '{}' has been satisfied", (Object)serviceDependency);
                this.handleRemovedTicker(ticker, serviceDependency, bundle, true);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    private void dependencyTimedOut(ServiceDependency serviceDependency, Ticker ticker, Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            try {
                this.logger.info("Service dependency '{}' has timed out", (Object)serviceDependency);
                this.handleRemovedTicker(ticker, serviceDependency, bundle, false);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    private void handleRemovedTicker(Ticker ticker, ServiceDependency serviceDependency, Bundle bundle, boolean satisfied) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_7);
            try {
                boolean hasTicked = ticker.cancel();
                if (hasTicked) {
                    if (satisfied) {
                        this.eventLogger.log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_SATISFIED, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                    } else {
                        this.eventLogger.log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_TIMED_OUT, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void addServiceDependencyTicker(final ServiceDependency serviceDependency, final Bundle bundle) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            try {
                Map<ServiceDependency, Ticker> serviceDependencyTickers = this.getServiceDependencyTickers(bundle);
                if (serviceDependencyTickers.containsKey(serviceDependency)) {
                    this.logger.warn("Service dependency '{}' already being waited upon", (Object)serviceDependency);
                } else {
                    boolean slowService = serviceDependency.getFilter().contains("(org.eclipse.virgo.server.slowservice=true)");
                    serviceDependencyTickers.put(serviceDependency, StandardTicker.createExponentialTicker(slowService ? 300000 : 5000, 200L, slowService ? 300000 : 60000, new Callable<Void>(){
                        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                        {
                            try {
                                try {
                                }
                                catch (RuntimeException runtimeException) {
                                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                    throw runtimeException;
                                }
                                return;
                            }
                            catch (RuntimeException runtimeException) {
                                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                throw runtimeException;
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Void call() throws Exception {
                            try {
                                Void void_;
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                                try {
                                    Object object = ApplicationContextDependencyMonitor.access$0(ApplicationContextDependencyMonitor.this);
                                    synchronized (object) {
                                        if (bundle.getState() == 1) {
                                            ApplicationContextDependencyMonitor.access$1(ApplicationContextDependencyMonitor.this, bundle);
                                        } else {
                                            ApplicationContextDependencyMonitor.access$2(ApplicationContextDependencyMonitor.this).log((LogEvent)KernelLogEvents.APPLICATION_CONTEXT_DEPENDENCY_DELAYED, new Object[]{serviceDependency.getBeanName(), bundle.getSymbolicName(), bundle.getVersion(), serviceDependency.getFilter()});
                                        }
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 2, 3] lbl11 : MonitorExitStatement: MONITOREXIT : var1_1
                                        void_ = null;
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                                    throw runtimeException;
                                }
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                                return void_;
                            }
                            catch (Throwable throwable) {
                                1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                                throw throwable;
                            }
                        }

                        static {
                            Factory factory = new Factory("ApplicationContextDependencyMonitor.java", Class.forName("org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$1"));
                            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "call", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$1", "", "", "java.lang.Exception:", "java.lang.Void"), 207);
                            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$1");
                        }
                    }, this.scheduledExecutorService));
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private Map<ServiceDependency, Ticker> getServiceDependencyTickers(Bundle bundle) {
        try {
            Map<ServiceDependency, Ticker> tickers = this.tickers.get(bundle);
            if (tickers == null) {
                tickers = new HashMap<ServiceDependency, Ticker>();
                this.tickers.put(bundle, tickers);
            }
            return tickers;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void stop() {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_9);
            try {
                this.scheduledExecutorService.shutdown();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_9);
            throw throwable;
        }
    }

    private List<ServiceDependency> createServiceDependencies(Event event) {
        try {
            ArrayList<ServiceDependency> arrayList;
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_10);
            try {
                String[] filters = (String[])event.getProperty("dependencies");
                String[] beanNames = (String[])event.getProperty("bean.name");
                ArrayList<ServiceDependency> serviceDependencies = new ArrayList<ServiceDependency>();
                if (filters != null) {
                    int i = 0;
                    while (i < filters.length) {
                        serviceDependencies.add(new ServiceDependency(filters[i], beanNames[i], null));
                        ++i;
                    }
                }
                arrayList = serviceDependencies;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_10);
            return arrayList;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_10);
            throw throwable;
        }
    }

    static /* synthetic */ Object access$0(ApplicationContextDependencyMonitor arg0) {
        try {
            Object object;
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_11);
            try {
                object = arg0.monitor;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_11);
            return object;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_11);
            throw throwable;
        }
    }

    static /* synthetic */ void access$1(ApplicationContextDependencyMonitor arg0, Bundle arg1) {
        try {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_12);
            try {
                arg0.containerCreationFailed(arg1);
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_12);
            return;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_12);
            throw throwable;
        }
    }

    static /* synthetic */ EventLogger access$2(ApplicationContextDependencyMonitor arg0) {
        try {
            EventLogger eventLogger;
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_13);
            try {
                eventLogger = arg0.eventLogger;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_13);
            return eventLogger;
        }
        catch (Throwable throwable) {
            ApplicationContextDependencyMonitor.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_13);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ApplicationContextDependencyMonitor.java", Class.forName("org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "handleEvent", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.osgi.service.event.Event:", "event:", "", "void"), 88);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "serviceDependenciesTimedOut", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "java.util.List:org.osgi.framework.Bundle:", "timedOutDependencies:bundle:", "", "void"), 115);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createServiceDependencies", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.osgi.service.event.Event:", "event:", "", "java.util.List"), 241);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor:", "arg0:", "", "java.lang.Object"), 71);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor:org.osgi.framework.Bundle:", "arg0:arg1:", "", "void"), 128);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$2", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor:", "arg0:", "", "org.eclipse.virgo.medic.eventlog.EventLogger"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "containerCreationFailed", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 128);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "containerCreated", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.osgi.framework.Bundle:", "bundle:", "", "void"), 137);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "changeInUnsatisfiedDependencies", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "java.util.List:org.osgi.framework.Bundle:", "remainingUnsatisfiedDependencies:bundle:", "", "void"), 147);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "dependencySatisfied", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency:org.eclipse.virgo.kernel.core.internal.blueprint.Ticker:org.osgi.framework.Bundle:", "serviceDependency:ticker:bundle:", "", "void"), 164);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "dependencyTimedOut", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency:org.eclipse.virgo.kernel.core.internal.blueprint.Ticker:org.osgi.framework.Bundle:", "serviceDependency:ticker:bundle:", "", "void"), 169);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleRemovedTicker", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.Ticker:org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency:org.osgi.framework.Bundle:boolean:", "ticker:serviceDependency:bundle:satisfied:", "", "void"), 174);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addServiceDependencyTicker", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency:org.osgi.framework.Bundle:", "serviceDependency:bundle:", "", "void"), 195);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor", "", "", "", "void"), 237);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor");
    }

    private static final class ServiceDependency {
        private final String filter;
        private final String beanName;
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

        private ServiceDependency(String filter, String beanName) {
            try {
                this.filter = filter;
                this.beanName = beanName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getFilter() {
            try {
                return this.filter;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public String getBeanName() {
            try {
                return this.beanName;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        public int hashCode() {
            try {
                int n;
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                try {
                    int result = 1;
                    result = 31 * result + this.beanName.hashCode();
                    n = result = 31 * result + this.filter.hashCode();
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return n;
            }
            catch (Throwable throwable) {
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        public boolean equals(Object obj) {
            try {
                boolean bl;
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                try {
                    if (this == obj) {
                        bl = true;
                    } else if (obj == null) {
                        bl = false;
                    } else if (this.getClass() != obj.getClass()) {
                        bl = false;
                    } else {
                        ServiceDependency other = (ServiceDependency)obj;
                        bl = !this.beanName.equals(other.beanName) ? false : this.filter.equals(other.filter);
                    }
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                return bl;
            }
            catch (Throwable throwable) {
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                throw throwable;
            }
        }

        public String toString() {
            try {
                String string;
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                try {
                    string = String.valueOf(this.filter) + " " + this.beanName;
                }
                catch (RuntimeException runtimeException) {
                    DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                    throw runtimeException;
                }
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return string;
            }
            catch (Throwable throwable) {
                ServiceDependency.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ServiceDependency(String string, String string2, ServiceDependency serviceDependency) {
            String string3 = string2;
            String string4 = string;
            ServiceDependency ajc$aspectInstance = this;
            try {
                void beanName;
                void filter;
                ajc$aspectInstance.filter = filter;
                ajc$aspectInstance.beanName = beanName;
                return;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
        }

        static {
            Factory factory = new Factory("ApplicationContextDependencyMonitor.java", Class.forName("org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hashCode", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency", "", "", "", "int"), 276);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "equals", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency", "java.lang.Object:", "obj:", "", "boolean"), 285);
            ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency", "", "", "", "java.lang.String"), 304);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.core.internal.blueprint.ApplicationContextDependencyMonitor$ServiceDependency");
        }
    }
}

