/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.DefaultJarScanner;
import org.apache.catalina.startup.Embedded;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.digester.Digester;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.gemini.web.tomcat.internal.BundleDependenciesJarScanner;
import org.eclipse.gemini.web.tomcat.internal.ChainingJarScanner;
import org.eclipse.gemini.web.tomcat.internal.TomcatConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.WebappConfigLocator;
import org.eclipse.gemini.web.tomcat.internal.loading.ChainedClassLoader;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.eclipse.gemini.web.tomcat.internal.support.PackageAdminBundleDependencyDeterminer;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

final class Tomcat
extends Embedded {
    private static final String ROOT_CONTEXT_PATH = "";
    private static final String ROOT_PATH = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(Tomcat.class);
    private final ExtendCatalina catalina = new ExtendCatalina();
    private final JarScanner jarScanner;
    private BundleContext bundleContext;
    private File configDir;
    private String defaultWeb;

    Tomcat(BundleContext context, PackageAdmin packageAdmin) {
        this.bundleContext = context;
        BundleDependenciesJarScanner bundleDependenciesJarScanner = new BundleDependenciesJarScanner(new PackageAdminBundleDependencyDeterminer(context, packageAdmin), BundleFileResolverFactory.createBundleFileResolver());
        DefaultJarScanner defaultJarScanner = new DefaultJarScanner();
        this.jarScanner = new ChainingJarScanner(new JarScanner[]{bundleDependenciesJarScanner, defaultJarScanner});
    }

    public void start() throws LifecycleException {
        super.start();
        Server server = this.getServer();
        if (server instanceof Lifecycle) {
            ((Lifecycle)server).start();
        }
    }

    public void stop() throws LifecycleException {
        Server server = this.getServer();
        this.stopConnectorsAndContainers(server);
        super.stop();
    }

    private void stopConnectorsAndContainers(Server server) throws LifecycleException {
        Service[] services = server.findServices();
        if (services != null) {
            Service[] serviceArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                Connector[] connectors;
                Service service = serviceArray[n2];
                Connector[] connectorArray = connectors = service.findConnectors();
                int n3 = connectors.length;
                int n4 = 0;
                while (n4 < n3) {
                    Connector connector = connectorArray[n4];
                    connector.stop();
                    ++n4;
                }
                Container container = service.getContainer();
                if (container instanceof Lifecycle) {
                    ((Lifecycle)container).stop();
                }
                ++n2;
            }
        }
    }

    public Engine findEngine() {
        Service[] findServices;
        Server server = this.getServer();
        Service[] serviceArray = findServices = server.findServices();
        int n = findServices.length;
        int n2 = 0;
        while (n2 < n) {
            Service service = serviceArray[n2];
            Container container = service.getContainer();
            if (container instanceof Engine) {
                return (Engine)container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Engine.");
    }

    public Host findHost() {
        Container[] children;
        Engine engine = this.findEngine();
        Container[] containerArray = children = engine.findChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Container container = containerArray[n2];
            if (container instanceof Host) {
                return (Host)container;
            }
            ++n2;
        }
        throw new IllegalStateException("Unable to locate Host.");
    }

    public void initialize() throws LifecycleException {
        this.getServer().initialize();
    }

    public Context createContext(String path, String docBase) {
        File configLocation;
        File contextXml;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Creating context '" + path + "' with docBase '" + docBase + "'");
        }
        ExtendedStandardContext context = new ExtendedStandardContext();
        ExtendedContextConfig config = new ExtendedContextConfig();
        if (this.configDir == null) {
            this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        }
        config.setConfigBase(this.configDir);
        if (this.defaultWeb == null) {
            this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
        }
        config.setDefaultWebXml(this.defaultWeb);
        String defaultContextXml = WebappConfigLocator.resolveDefaultContextXml(this.configDir);
        if (defaultContextXml != null) {
            config.setDefaultContextXml(defaultContextXml);
        }
        if ((contextXml = WebappConfigLocator.resolveWebappContextXml(path, docBase, configLocation = WebappConfigLocator.resolveWebappConfigDir(this.configDir, this.findHost()))) != null) {
            context.setConfigFile(contextXml.getAbsolutePath());
        }
        context.setDocBase(docBase);
        context.setPath(path.equals(ROOT_PATH) ? ROOT_CONTEXT_PATH : path);
        context.setJarScanner(this.jarScanner);
        config.setCustomAuthenticators(this.authenticators);
        context.addLifecycleListener((LifecycleListener)config);
        return context;
    }

    public void configure(InputStream configuration) {
        Digester digester = this.catalina.createStartDigester();
        digester.push((Object)this);
        ClassLoader[] loaders = new ClassLoader[]{Catalina.class.getClassLoader(), ((Object)((Object)this)).getClass().getClassLoader()};
        digester.setClassLoader((ClassLoader)ChainedClassLoader.create(loaders));
        try {
            digester.parse(configuration);
        }
        catch (IOException e) {
            throw new ServletContainerException("Error reading Tomcat configuration file.", (Throwable)e);
        }
        catch (SAXException e) {
            throw new ServletContainerException("Error parsing Tomcat XML configuration.", (Throwable)e);
        }
        this.configDir = TomcatConfigLocator.resolveConfigDir(this.bundleContext);
        this.defaultWeb = WebappConfigLocator.resolveDefaultWebXml(this.configDir);
    }

    private static class ExtendCatalina
    extends Catalina {
        private ExtendCatalina() {
        }

        public Digester createStartDigester() {
            return super.createStartDigester();
        }
    }

    private static class ExtendedContextConfig
    extends ContextConfig {
        private File configDir;

        private ExtendedContextConfig() {
        }

        protected File getConfigBase() {
            File configBase = super.getConfigBase();
            if (configBase != null) {
                return configBase;
            }
            if (this.configDir != null) {
                return this.configDir;
            }
            return null;
        }

        protected void setConfigBase(File configDir) {
            this.configDir = configDir;
        }
    }

    private static class ExtendedStandardContext
    extends StandardContext {
        private static final long serialVersionUID = 6914580440115519171L;

        private ExtendedStandardContext() {
        }

        public boolean isFilesystemBased() {
            String docBase = this.getDocBase();
            File f = new File(docBase);
            return f.isDirectory();
        }
    }
}

