/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.eclipse.gemini.web.tomcat.internal.loading.AbstractReadOnlyDirContext;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntry;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntryAttributes;
import org.eclipse.gemini.web.tomcat.internal.loading.URLResource;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolver;
import org.eclipse.gemini.web.tomcat.internal.support.BundleFileResolverFactory;
import org.osgi.framework.Bundle;

public final class BundleDirContext
extends AbstractReadOnlyDirContext {
    private volatile BundleEntry bundleEntry;
    private final BundleFileResolver bundleFileResolver = BundleFileResolverFactory.createBundleFileResolver();

    public BundleDirContext(Bundle bundle) {
        this(new BundleEntry(bundle));
    }

    private BundleDirContext(BundleEntry bundleEntry) {
        this.bundleEntry = bundleEntry;
    }

    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        List<NamingEntry> resources = this.doSafeList(name);
        return new NamingContextEnumeration(resources.iterator());
    }

    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        List<NamingEntry> resources = this.doSafeList(name);
        return new NamingContextBindingsEnumeration(resources.iterator(), (Context)((Object)this));
    }

    public Object doLookup(String name) throws NamingException {
        return this.entryToResult(this.getNamedEntry(name));
    }

    private List<NamingEntry> doSafeList(String name) throws NamingException {
        return this.doList(this.getNamedEntry(name));
    }

    private BundleEntry getNamedEntry(String name) throws NamingException {
        this.checkCanLookup(name);
        BundleEntry bundleEntry = this.bundleEntry.getEntry(name);
        if (bundleEntry == null) {
            throw new NamingException("Name '" + name + "' does not exist.");
        }
        return bundleEntry;
    }

    private List<NamingEntry> doList(BundleEntry bundleEntry) {
        List<BundleEntry> list = bundleEntry.list();
        ArrayList<NamingEntry> resources = new ArrayList<NamingEntry>();
        for (BundleEntry entry : list) {
            Object object = this.entryToResult(entry);
            resources.add(new NamingEntry(entry.getName(), object, 0));
        }
        return resources;
    }

    private Object entryToResult(BundleEntry entry) {
        Object result = entry.isDirectory() ? new BundleDirContext(entry) : new URLResource(entry.getURL());
        return result;
    }

    private void checkCanLookup(String name) throws NamingException {
        BundleEntry entry = this.bundleEntry;
        if (entry == null || entry.getBundle().getState() == 1) {
            throw new NamingException("Resource not found '" + name + "'");
        }
        this.checkNotAttemptingToLookupFromProtectedLocation(name);
    }

    private void checkNotAttemptingToLookupFromProtectedLocation(String name) throws NamingException {
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-INF/");
        this.checkNotAttemptingToLookupFrom(name, "/OSGI-OPT/");
    }

    private void checkNotAttemptingToLookupFrom(String name, String prefix) throws NamingException {
        if (name.startsWith(prefix)) {
            throw new NamingException("Resource cannot be obtained from " + prefix);
        }
    }

    public void close() throws NamingException {
        super.close();
        this.bundleEntry = null;
    }

    protected Attributes doGetAttributes(String name, String[] attrIds) throws NamingException {
        return new BundleEntryAttributes(this.getNamedEntry(name), attrIds);
    }

    protected String doGetRealPath(String path) {
        File bundleLocation;
        if (this.bundleEntry.getEntry(path) != null && (bundleLocation = this.bundleFileResolver.resolve(this.bundleEntry.getBundle())) != null && bundleLocation.isDirectory()) {
            return new File(bundleLocation, path).getAbsolutePath();
        }
        return null;
    }
}

