/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.management.internal;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionLifecycleListener;
import org.eclipse.virgo.kernel.osgi.region.management.ManageableRegion;
import org.eclipse.virgo.kernel.osgi.region.management.ManageableRegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.management.internal.RegionObjectNameCreator;
import org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegion;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;

public final class StandardManageableRegionDigraph
implements ManageableRegionDigraph {
    private final RegionDigraph regionDigraph;
    private final String domain;
    private final RegionObjectNameCreator regionObjectNameCreator;
    private final Map<String, ManageableRegion> manageableRegions = new ConcurrentHashMap<String, ManageableRegion>();
    private final BundleContext bundleContext;
    private final Object monitor = new Object();
    private final MBeanServer mbeanServer;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public StandardManageableRegionDigraph(RegionDigraph regionDigraph, String domain, BundleContext bundleContext) {
        this.regionDigraph = regionDigraph;
        this.domain = domain;
        this.regionObjectNameCreator = new RegionObjectNameCreator(domain);
        this.bundleContext = bundleContext;
        this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    private void registerRegionLifecycleListener() {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            RegionLifecycleListener regionLifecycleListener = new RegionLifecycleListener(){
                private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

                @Override
                public void regionAdded(Region region) {
                    try {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                        StandardManageableRegionDigraph.access$0(StandardManageableRegionDigraph.this, region);
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                        return;
                    }
                    catch (Throwable throwable) {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                        throw throwable;
                    }
                }

                @Override
                public void regionRemoving(Region region) {
                    try {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
                        StandardManageableRegionDigraph.access$1(StandardManageableRegionDigraph.this, region);
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
                        return;
                    }
                    catch (Throwable throwable) {
                        1.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
                        throw throwable;
                    }
                }

                static {
                    Factory factory = new Factory("StandardManageableRegionDigraph.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph$1"));
                    ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "regionAdded", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph$1", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 72);
                    ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "regionRemoving", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph$1", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 77);
                    ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph$1");
                }
            };
            this.bundleContext.registerService(RegionLifecycleListener.class, (Object)regionLifecycleListener, null);
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMBean() {
        try {
            ObjectName name;
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_1);
            this.registerRegionLifecycleListener();
            Object object = this.monitor;
            synchronized (object) {
                Set<Region> regions = this.regionDigraph.getRegions();
                for (Region region : regions) {
                    this.addRegion(region);
                }
            }
            try {
                name = new ObjectName(String.valueOf(this.domain) + ":type=RegionDigraph");
            }
            catch (MalformedObjectNameException e) {
                e.printStackTrace();
                throw new RuntimeException("Invalid domain name '" + this.domain + "'", e);
            }
            this.safelyRegisterMBean(this, name);
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void safelyRegisterMBean(Object mbean, ObjectName name) {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                try {
                    this.mbeanServer.registerMBean(mbean, name);
                }
                catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                    this.mbeanServer.unregisterMBean(name);
                    this.mbeanServer.registerMBean(mbean, name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("MBean registration failed", e);
            }
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManageableRegion[] getRegions() {
        ArrayList<ManageableRegion> regions = new ArrayList<ManageableRegion>();
        Object object = this.monitor;
        synchronized (object) {
            for (ManageableRegion manageableRegion : this.manageableRegions.values()) {
                regions.add(manageableRegion);
            }
        }
        return regions.toArray(new ManageableRegion[regions.size()]);
    }

    @Override
    public ManageableRegion getRegion(String regionName) {
        return this.manageableRegions.get(regionName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRegion(Region region) {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            StandardManageableRegion manageableRegion = new StandardManageableRegion(region, this, this.regionDigraph);
            this.safelyRegisterMBean(manageableRegion, this.regionObjectNameCreator.getRegionObjectName(region.getName()));
            Object object = this.monitor;
            synchronized (object) {
                this.manageableRegions.put(region.getName(), manageableRegion);
            }
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRegion(Region region) {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            String regionName = region.getName();
            Object object = this.monitor;
            synchronized (object) {
                this.manageableRegions.remove(regionName);
            }
            try {
                this.mbeanServer.unregisterMBean(this.regionObjectNameCreator.getRegionObjectName(regionName));
            }
            catch (MBeanRegistrationException e) {
                e.printStackTrace();
                throw new RuntimeException("Problem unregistering mbean", e);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
            }
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static /* synthetic */ void access$0(StandardManageableRegionDigraph arg0, Region arg1) {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
            arg0.addRegion(arg1);
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    static /* synthetic */ void access$1(StandardManageableRegionDigraph arg0, Region arg1) {
        try {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
            arg0.removeRegion(arg1);
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            StandardManageableRegionDigraph.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("StandardManageableRegionDigraph.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "registerRegionLifecycleListener", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "", "", "", "void"), 68);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "registerMBean", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "", "", "", "void"), 85);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "safelyRegisterMBean", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "java.lang.Object:javax.management.ObjectName:", "mbean:name:", "", "void"), 108);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "addRegion", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "removeRegion", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.Region:", "region:", "", "void"), 151);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph:org.eclipse.virgo.kernel.osgi.region.Region:", "arg0:arg1:", "", "void"), 142);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph", "org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph:org.eclipse.virgo.kernel.osgi.region.Region:", "arg0:arg1:", "", "void"), 150);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.management.internal.StandardManageableRegionDigraph");
    }
}

