/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.internal.url;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.eclipse.gemini.web.core.InstallationOptions;
import org.eclipse.gemini.web.core.WebBundleManifestTransformer;
import org.eclipse.gemini.web.internal.WebContainerUtils;
import org.eclipse.gemini.web.internal.url.DirTransformer;
import org.eclipse.gemini.web.internal.url.DirTransformingURLConnection;
import org.eclipse.gemini.web.internal.url.WebBundleUrl;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.io.JarTransformer;
import org.eclipse.virgo.util.io.JarTransformingURLConnection;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public final class WebBundleUrlStreamHandlerService
extends AbstractURLStreamHandlerService {
    private static final String FILE_PROTOCOL = "file";
    private final WebBundleManifestTransformer transformer;

    public WebBundleUrlStreamHandlerService(WebBundleManifestTransformer transformer) {
        this.transformer = transformer;
    }

    public URLConnection openConnection(URL u) throws IOException {
        WebBundleUrl url = new WebBundleUrl(u);
        URL actualUrl = new URL(url.getLocation());
        if (FILE_PROTOCOL.equals(actualUrl.getProtocol()) && new File(actualUrl.getPath()).isDirectory()) {
            DirTransformer dirTransformer = new DirTransformer(new Callback(actualUrl, url, this.transformer));
            return new DirTransformingURLConnection(actualUrl, dirTransformer, true);
        }
        JarTransformer jarTransformer = new JarTransformer((JarTransformer.JarTransformerCallback)new Callback(actualUrl, url, this.transformer));
        return new JarTransformingURLConnection(actualUrl, jarTransformer, true);
    }

    private static final class Callback
    implements JarTransformer.JarTransformerCallback,
    DirTransformer.DirTransformerCallback {
        private static final String META_INF = "META-INF";
        private static final String MANIFEST_MF = "MANIFEST.MF";
        private final WebBundleManifestTransformer transformer;
        private final URL sourceURL;
        private final WebBundleUrl webBundleUrl;

        Callback(URL sourceURL, WebBundleUrl url, WebBundleManifestTransformer transformer) {
            this.sourceURL = sourceURL;
            this.webBundleUrl = url;
            this.transformer = transformer;
        }

        public boolean transformEntry(String entryName, InputStream is, JarOutputStream jos) throws IOException {
            if ("META-INF/MANIFEST.MF".equals(entryName)) {
                jos.putNextEntry(new ZipEntry(entryName));
                this.transformManifest(is, jos);
                jos.closeEntry();
                return true;
            }
            return this.isSignatureFile(entryName);
        }

        private void transformManifest(InputStream inputStream, OutputStream outputStream) throws IOException {
            InputStreamReader reader = new InputStreamReader(inputStream);
            BundleManifest manifest = BundleManifestFactory.createBundleManifest((Reader)reader);
            InstallationOptions options = new InstallationOptions(this.webBundleUrl.getOptions());
            if (manifest.getHeader("SpringSource-DefaultWABHeaders") != null) {
                options.setDefaultWABHeaders(true);
            }
            boolean webBundle = WebContainerUtils.isWebApplicationBundle(manifest);
            this.transformer.transform(manifest, this.sourceURL, options, webBundle);
            Callback.toManifest(manifest.toDictionary()).write(outputStream);
        }

        private boolean isSignatureFile(String entryName) {
            String entryFileName;
            String[] entryNameComponents = entryName.split("/");
            return entryNameComponents.length == 2 && META_INF.equals(entryNameComponents[0]) && ((entryFileName = entryNameComponents[1]).endsWith(".SF") || entryFileName.endsWith(".DSA") || entryFileName.endsWith(".RSA"));
        }

        private static Manifest toManifest(Dictionary<String, String> headers) {
            Manifest manifest = new Manifest();
            Attributes attributes = manifest.getMainAttributes();
            Enumeration<String> names = headers.keys();
            while (names.hasMoreElements()) {
                String name = names.nextElement();
                String value = headers.get(name);
                attributes.putValue(name, value);
            }
            return manifest;
        }

        @Override
        public boolean transformFile(InputStream inputStream, PathReference toFile) throws IOException {
            if (MANIFEST_MF.equals(toFile.getName()) && META_INF.equals(toFile.getParent().getName())) {
                toFile.getParent().createDirectory();
                FileOutputStream outputStream = null;
                try {
                    outputStream = new FileOutputStream(toFile.toFile());
                    this.transformManifest(inputStream, outputStream);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(outputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((Closeable)outputStream);
                return true;
            }
            return this.isSignatureFile(toFile);
        }

        private boolean isSignatureFile(PathReference file) {
            String fileName;
            return META_INF.equals(file.getParent().getName()) && ((fileName = file.getName()).endsWith(".SF") || fileName.endsWith(".DSA") || fileName.endsWith(".RSA"));
        }
    }
}

