/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFS;
import org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry;
import org.eclipse.virgo.kernel.deployer.core.DeploymentException;
import org.eclipse.virgo.kernel.install.artifact.ScopeServiceRepository;
import org.eclipse.virgo.kernel.install.artifact.internal.SpringConfigServiceModelScanner;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.xml.XmlValidationModeDetector;

final class ServiceScoper {
    private static final String SPRING_CONFIG_DIR = "META-INF/spring/";
    private final Logger logger;
    private final XmlValidationModeDetector xmlValidationModeDetector;
    private final String scopeName;
    private final ScopeServiceRepository repository;
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public ServiceScoper(String scopeName, ScopeServiceRepository scopeServiceRepository, EventLogger eventLogger) {
        try {
            this.logger = LoggerFactory.getLogger(this.getClass());
            this.xmlValidationModeDetector = new XmlValidationModeDetector();
            this.scopeName = scopeName;
            this.repository = scopeServiceRepository;
            this.eventLogger = eventLogger;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void scope(Set<ArtifactFS> modules) throws DeploymentException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                HashMap<ArtifactFS, List<ArtifactFSEntry>> configFiles = new HashMap<ArtifactFS, List<ArtifactFSEntry>>();
                for (ArtifactFS moduleData : modules) {
                    configFiles.put(moduleData, this.findConfigFiles(moduleData));
                }
                this.doScope(configFiles);
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private List<ArtifactFSEntry> findConfigFiles(ArtifactFS bundleData) throws DeploymentException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                ArrayList<ArtifactFSEntry> configFiles = new ArrayList<ArtifactFSEntry>();
                ArtifactFSEntry entry = bundleData.getEntry(SPRING_CONFIG_DIR);
                if (entry.exists()) {
                    try {
                        configFiles.addAll(this.findConfigFiles(bundleData, entry));
                    }
                    catch (IOException e) {
                        throw new DeploymentException("Unable to read Spring config files.", e);
                    }
                }
                ArrayList<ArtifactFSEntry> arrayList = configFiles;
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return arrayList;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private List<ArtifactFSEntry> findConfigFiles(ArtifactFS bundleData, ArtifactFSEntry entry) throws IOException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                ArtifactFSEntry[] children = entry.getChildren();
                ArrayList<ArtifactFSEntry> configFiles = new ArrayList<ArtifactFSEntry>();
                ArtifactFSEntry[] artifactFSEntryArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ArtifactFSEntry e = artifactFSEntryArray[n2];
                    if (e.isDirectory()) {
                        configFiles.addAll(this.findConfigFiles(bundleData, e));
                    } else if (e.getPath().endsWith(".xml")) {
                        try {
                            int validationMode;
                            InputStream is = e.getInputStream();
                            try {
                                validationMode = this.xmlValidationModeDetector.detectValidationMode(is);
                            }
                            finally {
                                IOUtils.closeQuietly((Closeable)is);
                            }
                            if (validationMode != 2) {
                                configFiles.add(e);
                            } else {
                                this.logger.debug("Skipping entry '{}' as it uses a DTD.", (Object)e);
                            }
                        }
                        catch (IOException ioe) {
                            this.logger.debug("Unexpected error detecting validation mode of entry '{}'", (Object)ioe, (Object)e);
                            configFiles.add(e);
                        }
                    }
                    ++n2;
                }
                ArrayList<ArtifactFSEntry> arrayList = configFiles;
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return arrayList;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void rescope(ArtifactFS bundleData) throws DeploymentException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_3);
                HashMap<ArtifactFS, List<ArtifactFSEntry>> configFiles = new HashMap<ArtifactFS, List<ArtifactFSEntry>>();
                configFiles.put(bundleData, this.findConfigFiles(bundleData));
                this.doScope(configFiles);
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void doScope(Map<ArtifactFS, List<ArtifactFSEntry>> configFiles) throws DeploymentException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                SpringConfigServiceModelScanner scanner = new SpringConfigServiceModelScanner(this.scopeName, this.repository, this.eventLogger);
                Map<ArtifactFS, BundleManifest> manifests = this.loadBundleManifests((Collection<ArtifactFS>)configFiles.keySet());
                for (Map.Entry<ArtifactFS, List<ArtifactFSEntry>> entry : configFiles.entrySet()) {
                    BundleManifest bundleManifest = manifests.get(entry.getKey());
                    for (ArtifactFSEntry configFile : entry.getValue()) {
                        InputStream is = configFile.getInputStream();
                        try {
                            scanner.scanConfigFile(bundleManifest.getBundleSymbolicName().getSymbolicName(), bundleManifest.getBundleVersion(), configFile.getPath(), is);
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)is);
                        }
                    }
                }
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private Map<ArtifactFS, BundleManifest> loadBundleManifests(Collection<ArtifactFS> modules) throws DeploymentException {
        try {
            try {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                HashMap<ArtifactFS, BundleManifest> result = new HashMap<ArtifactFS, BundleManifest>();
                for (ArtifactFS module : modules) {
                    if (result.containsKey(module)) continue;
                    BundleManifest manifest = this.loadManifest(module);
                    result.put(module, manifest);
                }
                HashMap<ArtifactFS, BundleManifest> hashMap = result;
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return hashMap;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private BundleManifest loadManifest(ArtifactFS compositeArtifactFS) throws DeploymentException {
        try {
            try {
                BundleManifest bundleManifest;
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                ArtifactFSEntry entry = compositeArtifactFS.getEntry("META-INF/MANIFEST.MF");
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader(entry.getInputStream());
                    bundleManifest = BundleManifestFactory.createBundleManifest((Reader)reader);
                }
                catch (IOException ex) {
                    try {
                        throw new DeploymentException("Error reading MANIFEST.MF from '" + compositeArtifactFS + "'", ex);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((Closeable)reader);
                BundleManifest bundleManifest2 = bundleManifest;
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return bundleManifest2;
            }
            catch (Throwable throwable) {
                ServiceScoper.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ServiceScoper.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "scope", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "java.util.Set:", "modules:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 84);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findConfigFiles", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "bundleData:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.util.List"), 92);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "findConfigFiles", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:org.eclipse.virgo.kernel.artifact.fs.ArtifactFSEntry:", "bundleData:entry:", "java.io.IOException:", "java.util.List"), 107);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "rescope", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "bundleData:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 142);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "doScope", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "java.util.Map:", "configFiles:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "void"), 155);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadBundleManifests", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "java.util.Collection:", "modules:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "java.util.Map"), 172);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadManifest", "org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper", "org.eclipse.virgo.kernel.artifact.fs.ArtifactFS:", "compositeArtifactFS:", "org.eclipse.virgo.kernel.deployer.core.DeploymentException:", "org.eclipse.virgo.util.osgi.manifest.BundleManifest"), 183);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.ServiceScoper");
    }
}

