/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.install.artifact.internal;

import java.io.File;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity;
import org.eclipse.virgo.kernel.install.artifact.ArtifactIdentityDeterminer;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.repository.ArtifactBridge;
import org.eclipse.virgo.repository.ArtifactDescriptor;
import org.eclipse.virgo.repository.ArtifactGenerationException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardArtifactIdentityDeterminer
implements ArtifactIdentityDeterminer {
    private static final Logger LOGGER;
    private static final String JAR_EXTENSION = ".jar";
    private static final String PLAN_EXTENSION = ".plan";
    private static final String PROPERTIES_EXTENSION = ".properties";
    private static final String PAR_EXTENSION = ".par";
    private final Set<ArtifactBridge> bridges;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        Factory factory = new Factory("StandardArtifactIdentityDeterminer.java", Class.forName("org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactIdentityDeterminer"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "determineIdentityFromFile", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactIdentityDeterminer", "java.io.File:java.lang.String:", "file:scopeName:", "", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 56);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "trimExtension", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactIdentityDeterminer", "java.io.File:", "file:", "", "java.lang.String"), 82);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "determineIdentity", "org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactIdentityDeterminer", "java.io.File:java.lang.String:", "file:scopeName:", "", "org.eclipse.virgo.kernel.install.artifact.ArtifactIdentity"), 94);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.install.artifact.internal.StandardArtifactIdentityDeterminer");
        LOGGER = LoggerFactory.getLogger(StandardArtifactIdentityDeterminer.class);
    }

    public StandardArtifactIdentityDeterminer(Set<ArtifactBridge> bridges) {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            this.bridges = bridges;
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private ArtifactIdentity determineIdentityFromFile(File file, String scopeName) {
        try {
            try {
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
                String type = null;
                String name = null;
                String filename = file.getName();
                name = this.trimExtension(file);
                if (filename.endsWith(JAR_EXTENSION)) {
                    type = "bundle";
                } else if (filename.endsWith(PLAN_EXTENSION)) {
                    type = "plan";
                } else if (filename.endsWith(PROPERTIES_EXTENSION)) {
                    type = "configuration";
                } else if (filename.endsWith(PAR_EXTENSION)) {
                    type = "par";
                }
                ArtifactIdentity artifactIdentity = type != null && name != null ? new ArtifactIdentity(type, name, Version.emptyVersion, scopeName) : null;
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
                return artifactIdentity;
            }
            catch (Throwable throwable) {
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private String trimExtension(File file) {
        try {
            try {
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                String filename = file.getName();
                int lastIndexOf = filename.lastIndexOf(46);
                String string = lastIndexOf > 0 ? filename.substring(0, lastIndexOf) : filename;
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return string;
            }
            catch (Throwable throwable) {
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    @Override
    public ArtifactIdentity determineIdentity(File file, String scopeName) {
        try {
            try {
                ArtifactIdentity artifactIdentity;
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_2);
                ArtifactDescriptor artifactDescriptor = null;
                for (ArtifactBridge artifactBridge : this.bridges) {
                    try {
                        artifactDescriptor = artifactBridge.generateArtifactDescriptor(file);
                    }
                    catch (ArtifactGenerationException e) {
                        LOGGER.warn(String.format("Error occurred while determining the type of an Artifact '%s' with the bridge '%s'.", file, artifactBridge.getClass().getSimpleName()), (Throwable)e);
                    }
                    if (artifactDescriptor != null) break;
                }
                if (artifactDescriptor == null) {
                    artifactIdentity = this.determineIdentityFromFile(file, scopeName);
                } else {
                    String type = artifactDescriptor.getType();
                    String name = artifactDescriptor.getName();
                    Version version = artifactDescriptor.getVersion();
                    name = name == null ? this.trimExtension(file) : name;
                    version = version == null ? Version.emptyVersion : version;
                    artifactIdentity = new ArtifactIdentity(type, name, version, scopeName);
                }
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_2);
                return artifactIdentity;
            }
            catch (Throwable throwable) {
                StandardArtifactIdentityDeterminer.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }
}

