/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.config.internal;

import java.io.IOException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.config.internal.ConfigurationAdminDumpContributor;
import org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter;
import org.eclipse.virgo.kernel.config.internal.ConfigurationPublisher;
import org.eclipse.virgo.kernel.config.internal.KernelConfiguration;
import org.eclipse.virgo.kernel.config.internal.KernelConfigurationPropertiesSource;
import org.eclipse.virgo.kernel.config.internal.PropertiesSource;
import org.eclipse.virgo.kernel.config.internal.UserConfigurationPropertiesSource;
import org.eclipse.virgo.kernel.config.internal.commandline.CommandLinePropertiesSource;
import org.eclipse.virgo.kernel.config.internal.ovf.OvfPropertiesSource;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.dump.DumpContributor;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;

public final class ConfigurationInitialiser {
    private final ServiceRegistrationTracker tracker;
    private volatile ConfigurationAdminExporter configAdminExporter;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public ConfigurationInitialiser() {
        try {
            this.tracker = new ServiceRegistrationTracker();
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public KernelConfiguration start(BundleContext context, EventLogger eventLogger) throws IOException {
        try {
            KernelConfiguration kernelConfiguration;
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            try {
                ServiceReference configurationAdminReference = context.getServiceReference(ConfigurationAdmin.class);
                ConfigurationAdmin configAdmin = null;
                if (configurationAdminReference != null) {
                    configAdmin = (ConfigurationAdmin)context.getService(configurationAdminReference);
                }
                if (configAdmin == null) {
                    throw new IllegalStateException("ConfigurationAdmin service missing");
                }
                KernelConfiguration configuration = new KernelConfiguration(context);
                this.publishConfiguration(context, eventLogger, configuration, configAdmin);
                this.configAdminExporter = this.initializeConfigAdminExporter(context, configuration, configAdmin);
                this.initializeDumpContributor(context, configAdmin);
                kernelConfiguration = configuration;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return kernelConfiguration;
        }
        catch (Throwable throwable) {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private void publishConfiguration(BundleContext context, EventLogger eventLogger, KernelConfiguration configuration, ConfigurationAdmin configAdmin) throws IOException {
        try {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            try {
                PropertiesSource[] sources = new PropertiesSource[]{new UserConfigurationPropertiesSource(configuration.getConfigDirectories()), new OvfPropertiesSource(context, eventLogger), new KernelConfigurationPropertiesSource(configuration), new CommandLinePropertiesSource(context, eventLogger)};
                ConfigurationPublisher configPublisher = new ConfigurationPublisher(configAdmin, sources);
                configPublisher.publishConfigurations();
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void initializeDumpContributor(BundleContext context, ConfigurationAdmin configAdmin) {
        try {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            try {
                ConfigurationAdminDumpContributor dumpContributor = new ConfigurationAdminDumpContributor(configAdmin);
                this.tracker.track(context.registerService(DumpContributor.class.getName(), (Object)dumpContributor, null));
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private ConfigurationAdminExporter initializeConfigAdminExporter(BundleContext context, KernelConfiguration configuration, ConfigurationAdmin configAdmin) {
        try {
            ConfigurationAdminExporter configurationAdminExporter;
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            try {
                ConfigurationAdminExporter exporter = new ConfigurationAdminExporter(configuration.getDomain(), configAdmin);
                this.tracker.track(context.registerService(ConfigurationListener.class.getName(), (Object)exporter, null));
                exporter.init();
                configurationAdminExporter = exporter;
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return configurationAdminExporter;
        }
        catch (Throwable throwable) {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    public void stop() {
        try {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_4);
            try {
                this.tracker.unregisterAll();
                ConfigurationAdminExporter local = this.configAdminExporter;
                if (local != null) {
                    this.configAdminExporter = null;
                    local.stop();
                }
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            ConfigurationInitialiser.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("ConfigurationInitialiser.java", Class.forName("org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "start", "org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:", "context:eventLogger:", "java.io.IOException:", "org.eclipse.virgo.kernel.config.internal.KernelConfiguration"), 41);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "publishConfiguration", "org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser", "org.osgi.framework.BundleContext:org.eclipse.virgo.medic.eventlog.EventLogger:org.eclipse.virgo.kernel.config.internal.KernelConfiguration:org.osgi.service.cm.ConfigurationAdmin:", "context:eventLogger:configuration:configAdmin:", "java.io.IOException:", "void"), 63);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeDumpContributor", "org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser", "org.osgi.framework.BundleContext:org.osgi.service.cm.ConfigurationAdmin:", "context:configAdmin:", "", "void"), 72);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeConfigAdminExporter", "org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser", "org.osgi.framework.BundleContext:org.eclipse.virgo.kernel.config.internal.KernelConfiguration:org.osgi.service.cm.ConfigurationAdmin:", "context:configuration:configAdmin:", "", "org.eclipse.virgo.kernel.config.internal.ConfigurationAdminExporter"), 77);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stop", "org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser", "", "", "", "void"), 84);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.config.internal.ConfigurationInitialiser");
    }
}

