/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.osgi.console.telnet;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.osgi.framework.console.ConsoleSession;
import org.eclipse.virgo.osgi.console.telnet.TelnetConsoleSession;
import org.osgi.framework.BundleContext;

public class TelnetManager {
    private ConsoleSocketGetter csg;
    private int telnetPort = -1;
    private String host = null;
    private BundleContext context = null;
    private static final String PROP_CONSOLE = "osgi.console";

    public TelnetManager(BundleContext bundleContext) {
        String consoleValue = null;
        try {
            consoleValue = bundleContext.getProperty(PROP_CONSOLE);
            if (consoleValue != null && !"".equals(consoleValue) && !"none".equals(consoleValue)) {
                this.parseHostAndPort(consoleValue);
            }
        }
        catch (NumberFormatException e) {
            System.out.println("Invalid host/port in " + consoleValue + "; " + e.getMessage());
            e.printStackTrace();
        }
        this.context = bundleContext;
    }

    public void startConsoleListener() {
        if (this.telnetPort != -1) {
            try {
                this.csg = this.host != null ? new ConsoleSocketGetter(new ServerSocket(this.telnetPort, 0, InetAddress.getByName(this.host)), this.context) : new ConsoleSocketGetter(new ServerSocket(this.telnetPort), this.context);
            }
            catch (IOException e) {
                System.out.println("Unable to open telnet. Reason: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (this.csg != null) {
            this.csg.shutdown();
        }
    }

    public BundleContext getContext() {
        return this.context;
    }

    private void parseHostAndPort(String consoleValue) {
        int index = consoleValue.lastIndexOf(":");
        if (index > -1) {
            this.host = consoleValue.substring(0, index);
        }
        this.telnetPort = Integer.parseInt(consoleValue.substring(index + 1));
    }

    static class ConsoleSocketGetter
    implements Runnable {
        private final ServerSocket server;
        private final BundleContext context;
        private volatile boolean shutdown = false;

        ConsoleSocketGetter(ServerSocket server, BundleContext context) {
            this.server = server;
            this.context = context;
            try {
                Method reuseAddress = server.getClass().getMethod("setReuseAddress", Boolean.TYPE);
                reuseAddress.invoke((Object)server, Boolean.TRUE);
            }
            catch (Exception exception) {}
            Thread t = new Thread((Runnable)this, "ConsoleSocketGetter");
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void run() {
            System.out.println("Listening on port: " + Integer.toString(this.server.getLocalPort()));
            while (!this.shutdown) {
                try {
                    Socket socket = this.server.accept();
                    if (socket == null) {
                        throw new IOException("No socket available.  Probably caused by a shutdown.");
                    }
                    TelnetConsoleSession session = new TelnetConsoleSession(socket, this.context);
                    session.start();
                    this.context.registerService(ConsoleSession.class.getName(), (Object)session, null);
                }
                catch (Exception e) {
                    if (this.shutdown) continue;
                    e.printStackTrace();
                }
            }
        }

        public void shutdown() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

