/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.shell.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.shell.internal.CommandDescriptor;
import org.eclipse.virgo.kernel.shell.internal.CommandResolver;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public final class CommandRegistry {
    private final CommandResolver commandResolver;
    private final BundleContext bundleContext;
    private final List<CommandDescriptor> commandDescriptors = new ArrayList<CommandDescriptor>();
    private final Map<ServiceReference<?>, List<CommandDescriptor>> commandDescriptorsByService = new HashMap();
    private final Object monitor = new Object();
    private final CommandRegistryServiceListener commandRegistryServiceListener = new CommandRegistryServiceListener();
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public CommandRegistry(CommandResolver commandResolver, BundleContext bundleContext) {
        this.commandResolver = commandResolver;
        this.bundleContext = bundleContext;
    }

    void initialize() {
        try {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_0);
            this.bundleContext.addServiceListener((ServiceListener)this.commandRegistryServiceListener);
            try {
                ServiceReference[] serviceReferences = this.bundleContext.getServiceReferences(null, null);
                if (serviceReferences != null) {
                    ServiceReference[] serviceReferenceArray = serviceReferences;
                    int n = serviceReferences.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ServiceReference serviceReference = serviceReferenceArray[n2];
                        this.serviceRegistered(serviceReference);
                        ++n2;
                    }
                }
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("Unexpected InvalidSyntaxException", e);
            }
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CommandDescriptor> getCommandDescriptors() {
        Object object = this.monitor;
        synchronized (object) {
            return new ArrayList<CommandDescriptor>(this.commandDescriptors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceRegistered(ServiceReference<?> serviceReference) {
        try {
            List<CommandDescriptor> commands;
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            Object service = this.bundleContext.getService(serviceReference);
            if (service != null && !(commands = this.commandResolver.resolveCommands(serviceReference, service)).isEmpty()) {
                Object object = this.monitor;
                synchronized (object) {
                    this.commandDescriptors.addAll(commands);
                    this.commandDescriptorsByService.put(serviceReference, commands);
                }
            }
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceUnregistering(ServiceReference<?> serviceReference) {
        try {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            Object object = this.monitor;
            synchronized (object) {
                List<CommandDescriptor> commandDescriptorsForService = this.commandDescriptorsByService.remove(serviceReference);
                this.commandDescriptors.removeAll(commandDescriptorsForService);
            }
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    static /* synthetic */ void access$0(CommandRegistry arg0, ServiceReference arg1) {
        try {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            arg0.serviceRegistered(arg1);
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return;
        }
        catch (Throwable throwable) {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    static /* synthetic */ void access$1(CommandRegistry arg0, ServiceReference arg1) {
        try {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            arg0.serviceUnregistering(arg1);
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            CommandRegistry.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    static {
        Factory factory = new Factory("CommandRegistry.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.CommandRegistry"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "initialize", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry", "", "", "", "void"), 60);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "serviceRegistered", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry", "org.osgi.framework.ServiceReference:", "serviceReference:", "", "void"), 82);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "serviceUnregistering", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry", "org.osgi.framework.ServiceReference:", "serviceReference:", "", "void"), 95);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$0", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry:org.osgi.framework.ServiceReference:", "arg0:arg1:", "", "void"), 81);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "access$1", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry:org.osgi.framework.ServiceReference:", "arg0:arg1:", "", "void"), 94);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.CommandRegistry");
    }

    private final class CommandRegistryServiceListener
    implements ServiceListener {
        private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        private CommandRegistryServiceListener() {
        }

        public void serviceChanged(ServiceEvent event) {
            try {
                CommandRegistryServiceListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                if (1 == event.getType()) {
                    CommandRegistry.access$0(CommandRegistry.this, event.getServiceReference());
                } else if (4 == event.getType()) {
                    CommandRegistry.access$1(CommandRegistry.this, event.getServiceReference());
                }
                CommandRegistryServiceListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                CommandRegistryServiceListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }

        static {
            Factory factory = new Factory("CommandRegistry.java", Class.forName("org.eclipse.virgo.kernel.shell.internal.CommandRegistry$CommandRegistryServiceListener"));
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serviceChanged", "org.eclipse.virgo.kernel.shell.internal.CommandRegistry$CommandRegistryServiceListener", "org.osgi.framework.ServiceEvent:", "event:", "", "void"), 107);
            ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.shell.internal.CommandRegistry$CommandRegistryServiceListener");
        }
    }
}

