/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.userregionfactory;

import java.net.URI;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.virgo.kernel.core.Shutdown;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkLogEvents;
import org.eclipse.virgo.kernel.osgi.framework.OsgiFrameworkUtils;
import org.eclipse.virgo.kernel.osgi.framework.OsgiServiceHolder;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.osgi.region.RegionPackageImportPolicy;
import org.eclipse.virgo.kernel.osgi.region.StandardRegionFilter;
import org.eclipse.virgo.kernel.userregionfactory.PackageImportWildcardExpander;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionFactoryParserLogger;
import org.eclipse.virgo.kernel.userregionfactory.UserRegionPackageImportPolicy;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.osgi.launcher.parser.ArgumentParser;
import org.eclipse.virgo.osgi.launcher.parser.BundleEntry;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.eclipse.virgo.util.osgi.manifest.BundleManifest;
import org.eclipse.virgo.util.osgi.manifest.BundleManifestFactory;
import org.eclipse.virgo.util.osgi.manifest.RequireBundle;
import org.eclipse.virgo.util.osgi.manifest.RequiredBundle;
import org.eclipse.virgo.util.osgi.manifest.parse.ParserLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

public final class Activator
implements BundleActivator {
    private static final String CLASS_LIST_SEPARATOR = ",";
    private static final long MAX_SECONDS_WAIT_FOR_SERVICE = 30L;
    private static final long MAX_MILLIS_WAIT_FOR_SERVICE = TimeUnit.SECONDS.toMillis(30L);
    private static final String USER_REGION_CONFIGURATION_PID = "org.eclipse.virgo.kernel.userregion";
    private static final String USER_REGION_BASE_BUNDLES_PROPERTY = "baseBundles";
    private static final String USER_REGION_PACKAGE_IMPORTS_PROPERTY = "packageImports";
    private static final String USER_REGION_SERVICE_IMPORTS_PROPERTY = "serviceImports";
    private static final String USER_REGION_BUNDLE_IMPORTS_PROPERTY = "bundleImports";
    private static final String USER_REGION_SERVICE_EXPORTS_PROPERTY = "serviceExports";
    private static final String USER_REGION_BUNDLE_CONTEXT_SERVICE_PROPERTY = "org.eclipse.virgo.kernel.regionContext";
    private static final String REGION_USER = "org.eclipse.virgo.region.user";
    private static final String EVENT_REGION_STARTING = "org/eclipse/virgo/kernel/region/STARTING";
    private static final String EVENT_PROPERTY_REGION_BUNDLECONTEXT = "region.bundleContext";
    private EventAdmin eventAdmin;
    private String regionBundles;
    private String regionPackageImports;
    private String regionServiceImports;
    private String regionBundleImports;
    private String regionServiceExports;
    private BundleContext bundleContext;
    private final ArgumentParser parser = new ArgumentParser();
    private final ServiceRegistrationTracker tracker = new ServiceRegistrationTracker();

    public void start(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        RegionDigraph regionDigraph = Activator.getPotentiallyDelayedService(bundleContext, RegionDigraph.class);
        this.eventAdmin = Activator.getPotentiallyDelayedService(bundleContext, EventAdmin.class);
        ConfigurationAdmin configAdmin = Activator.getPotentiallyDelayedService(bundleContext, ConfigurationAdmin.class);
        EventLogger eventLogger = Activator.getPotentiallyDelayedService(bundleContext, EventLogger.class);
        Shutdown shutdown = Activator.getPotentiallyDelayedService(bundleContext, Shutdown.class);
        this.getRegionConfiguration(configAdmin, eventLogger, shutdown);
        this.createUserRegion(bundleContext, regionDigraph, eventLogger);
    }

    private void getRegionConfiguration(ConfigurationAdmin configAdmin, EventLogger eventLogger, Shutdown shutdown) {
        try {
            Configuration config = configAdmin.getConfiguration(USER_REGION_CONFIGURATION_PID, null);
            Dictionary properties = config.getProperties();
            if (properties != null) {
                this.regionBundles = (String)properties.get(USER_REGION_BASE_BUNDLES_PROPERTY);
                this.regionPackageImports = (String)properties.get(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
                this.regionServiceImports = (String)properties.get(USER_REGION_SERVICE_IMPORTS_PROPERTY);
                this.regionBundleImports = (String)properties.get(USER_REGION_BUNDLE_IMPORTS_PROPERTY);
                this.regionServiceExports = (String)properties.get(USER_REGION_SERVICE_EXPORTS_PROPERTY);
            } else {
                eventLogger.log((LogEvent)OsgiFrameworkLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, new Object[0]);
                shutdown.immediateShutdown();
            }
        }
        catch (Exception e) {
            eventLogger.log((LogEvent)OsgiFrameworkLogEvents.USER_REGION_CONFIGURATION_UNAVAILABLE, (Throwable)e, new Object[0]);
            shutdown.immediateShutdown();
        }
    }

    private void createUserRegion(BundleContext userRegionBundleContext, RegionDigraph regionDigraph, EventLogger eventLogger) throws BundleException {
        BundleContext systemBundleContext = this.getSystemBundleContext();
        Bundle userRegionFactoryBundle = userRegionBundleContext.getBundle();
        Region kernelRegion = this.getKernelRegion(regionDigraph);
        kernelRegion.removeBundle(userRegionFactoryBundle);
        Region userRegion = regionDigraph.createRegion(REGION_USER);
        userRegion.addBundle(userRegionFactoryBundle);
        RegionFilter kernelFilter = this.createKernelFilter(systemBundleContext, eventLogger);
        userRegion.connectRegion(kernelRegion, kernelFilter);
        RegionFilter userRegionFilter = this.createUserRegionFilter();
        kernelRegion.connectRegion(userRegion, userRegionFilter);
        this.notifyUserRegionStarting(userRegionBundleContext);
        this.initialiseUserRegionBundles(userRegion);
        this.registerRegionService(userRegion);
        this.publishUserRegionBundleContext(userRegionBundleContext);
    }

    private RegionFilter createUserRegionFilter() throws BundleException {
        Filter serviceFilter;
        StandardRegionFilter userRegionFilter = new StandardRegionFilter();
        try {
            serviceFilter = this.bundleContext.createFilter(this.classesToFilter(this.regionServiceExports));
        }
        catch (InvalidSyntaxException e) {
            throw new BundleException("Invalid serviceExportsin user region configuration: '" + this.regionServiceExports + "'", (Throwable)e);
        }
        userRegionFilter.setServiceFilter(serviceFilter);
        return userRegionFilter;
    }

    private Region getKernelRegion(RegionDigraph regionDigraph) {
        return (Region)regionDigraph.iterator().next();
    }

    private RegionFilter createKernelFilter(BundleContext systemBundleContext, EventLogger eventLogger) throws BundleException {
        Filter serviceFilter;
        StandardRegionFilter kernelFilter = new StandardRegionFilter();
        this.allowImportedBundles((RegionFilter)kernelFilter, eventLogger);
        kernelFilter.setPackageImportPolicy((RegionPackageImportPolicy)this.createUserRegionPackageImportPolicy(systemBundleContext));
        try {
            serviceFilter = this.bundleContext.createFilter(this.classesToFilter(this.regionServiceImports));
        }
        catch (InvalidSyntaxException e) {
            throw new BundleException("Invalid serviceImportsin user region configuration: '" + this.regionServiceImports + "'", (Throwable)e);
        }
        kernelFilter.setServiceFilter(serviceFilter);
        return kernelFilter;
    }

    private void allowImportedBundles(RegionFilter kernelFilter, EventLogger eventLogger) {
        String userRegionBundleImports = this.regionBundleImports != null ? this.regionBundleImports : this.bundleContext.getProperty(USER_REGION_BUNDLE_IMPORTS_PROPERTY);
        RequireBundle bundleImportsAsRequireBundle = this.representBundleImportsAsRequireBundle(userRegionBundleImports, eventLogger);
        List importedBundles = bundleImportsAsRequireBundle.getRequiredBundles();
        for (RequiredBundle importedBundle : importedBundles) {
            kernelFilter.allowBundle(importedBundle.getBundleSymbolicName(), importedBundle.getBundleVersion());
        }
    }

    private RequireBundle representBundleImportsAsRequireBundle(String userRegionBundleImportsProperty, EventLogger eventLogger) {
        Hashtable<String, String> headers = new Hashtable<String, String>();
        ((Dictionary)headers).put("Require-Bundle", userRegionBundleImportsProperty);
        BundleManifest manifest = BundleManifestFactory.createBundleManifest(headers, (ParserLogger)new UserRegionFactoryParserLogger(eventLogger));
        return manifest.getRequireBundle();
    }

    private String classesToFilter(String classList) {
        if (classList == null) {
            return "";
        }
        String[] classes = classList.split(CLASS_LIST_SEPARATOR);
        if (classes.length == 0) {
            return "";
        }
        StringBuffer filter = new StringBuffer();
        filter.append("(|");
        String[] stringArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            filter.append("(objectClass=" + className + ")");
            ++n2;
        }
        filter.append(")");
        return filter.toString();
    }

    private UserRegionPackageImportPolicy createUserRegionPackageImportPolicy(BundleContext systemBundleContext) {
        String userRegionImportsProperty = this.regionPackageImports != null ? this.regionPackageImports : this.bundleContext.getProperty(USER_REGION_PACKAGE_IMPORTS_PROPERTY);
        String expandedUserRegionImportsProperty = null;
        if (userRegionImportsProperty != null) {
            expandedUserRegionImportsProperty = PackageImportWildcardExpander.expandPackageImportsWildcards(userRegionImportsProperty, systemBundleContext);
        }
        UserRegionPackageImportPolicy userRegionPackageImportPolicy = new UserRegionPackageImportPolicy(expandedUserRegionImportsProperty);
        return userRegionPackageImportPolicy;
    }

    private BundleContext getSystemBundleContext() {
        return this.bundleContext.getBundle(0L).getBundleContext();
    }

    private void notifyUserRegionStarting(BundleContext userRegionBundleContext) {
        HashMap<String, BundleContext> properties = new HashMap<String, BundleContext>();
        properties.put(EVENT_PROPERTY_REGION_BUNDLECONTEXT, userRegionBundleContext);
        this.eventAdmin.sendEvent(new Event(EVENT_REGION_STARTING, properties));
    }

    private void initialiseUserRegionBundles(Region userRegion) throws BundleException {
        String userRegionBundlesProperty;
        String string = userRegionBundlesProperty = this.regionBundles != null ? this.regionBundles : this.bundleContext.getProperty(USER_REGION_BASE_BUNDLES_PROPERTY);
        if (userRegionBundlesProperty != null) {
            ArrayList<Bundle> bundlesToStart = new ArrayList<Bundle>();
            BundleEntry[] bundleEntryArray = this.parser.parseBundleEntries(userRegionBundlesProperty);
            int n = bundleEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                BundleEntry entry = bundleEntryArray[n2];
                URI uri = entry.getURI();
                Bundle bundle = userRegion.installBundle(uri.toString());
                if (entry.isAutoStart()) {
                    bundlesToStart.add(bundle);
                }
                ++n2;
            }
            for (Bundle bundle : bundlesToStart) {
                try {
                    bundle.start();
                }
                catch (BundleException e) {
                    throw new BundleException("Failed to start bundle " + bundle.getSymbolicName() + " " + bundle.getVersion(), (Throwable)e);
                }
            }
        }
    }

    private void registerRegionService(Region region) {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("org.eclipse.virgo.kernel.region.name", region.getName());
        this.tracker.track(this.bundleContext.registerService(Region.class, (Object)region, props));
    }

    private void publishUserRegionBundleContext(BundleContext userRegionBundleContext) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        ((Dictionary)properties).put(USER_REGION_BUNDLE_CONTEXT_SERVICE_PROPERTY, "true");
        this.bundleContext.registerService(BundleContext.class, (Object)userRegionBundleContext, properties);
    }

    public void stop(BundleContext context) throws Exception {
    }

    private static <T> T getPotentiallyDelayedService(BundleContext context, Class<T> serviceClass) throws TimeoutException, InterruptedException {
        Object service = null;
        long millisWaited = 0L;
        while (service == null && millisWaited <= MAX_MILLIS_WAIT_FOR_SERVICE) {
            try {
                OsgiServiceHolder serviceHolder = OsgiFrameworkUtils.getService((BundleContext)context, serviceClass);
                if (serviceHolder != null) {
                    service = serviceHolder.getService();
                    continue;
                }
                millisWaited += Activator.sleepABitMore();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (service == null) {
            throw new TimeoutException(serviceClass.getName());
        }
        return (T)service;
    }

    private static long sleepABitMore() throws InterruptedException {
        long before = System.currentTimeMillis();
        Thread.sleep(100L);
        return System.currentTimeMillis() - before;
    }
}

