/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.medic.impl;

import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.virgo.medic.dump.DumpGenerator;
import org.eclipse.virgo.medic.dump.impl.DumpContributorPublisher;
import org.eclipse.virgo.medic.dump.impl.StandardDumpContributorResolver;
import org.eclipse.virgo.medic.dump.impl.StandardDumpGenerator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.EventLoggerFactory;
import org.eclipse.virgo.medic.eventlog.impl.BundleSearchingPropertyResourceBundleResolver;
import org.eclipse.virgo.medic.eventlog.impl.EventLoggerServiceFactory;
import org.eclipse.virgo.medic.eventlog.impl.StandardLocaleResolver;
import org.eclipse.virgo.medic.eventlog.impl.logback.LogBackEventLoggerFactory;
import org.eclipse.virgo.medic.impl.config.ConfigurationAdminConfigurationProvider;
import org.eclipse.virgo.medic.impl.config.ConfigurationProvider;
import org.eclipse.virgo.medic.log.ConfigurationPublicationFailedException;
import org.eclipse.virgo.medic.log.DelegatingPrintStream;
import org.eclipse.virgo.medic.log.LoggingConfigurationPublisher;
import org.eclipse.virgo.medic.log.impl.CallingBundleResolver;
import org.eclipse.virgo.medic.log.impl.ClassSelector;
import org.eclipse.virgo.medic.log.impl.ExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.LoggingLevel;
import org.eclipse.virgo.medic.log.impl.LoggingPrintStreamWrapper;
import org.eclipse.virgo.medic.log.impl.PackageNameFilteringClassSelector;
import org.eclipse.virgo.medic.log.impl.SecurityManagerExecutionStackAccessor;
import org.eclipse.virgo.medic.log.impl.StandardCallingBundleResolver;
import org.eclipse.virgo.medic.log.impl.StandardDelegatingPrintStream;
import org.eclipse.virgo.medic.log.impl.config.BundleResourceConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.CompositeConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.ConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.ServiceRegistryConfigurationLocator;
import org.eclipse.virgo.medic.log.impl.config.StandardLoggingConfigurationPublisher;
import org.eclipse.virgo.medic.log.impl.logback.DelegatingContextSelector;
import org.eclipse.virgo.medic.log.impl.logback.JoranLoggerContextConfigurer;
import org.eclipse.virgo.medic.log.impl.logback.StandardContextSelectorDelegate;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.service.cm.ConfigurationListener;

public final class MedicActivator
implements BundleActivator {
    private static final String LOGGER_NAME_SYSERR = "System.err";
    private static final String LOGGER_NAME_SYSOUT = "System.out";
    private static final String LOGGER_NAME_SYSERR_DELEGATE = "delegating.System.err";
    private static final String LOGGER_NAME_SYSOUT_DELEGATE = "delegating.System.out";
    private static final String PROPERTY_MEDIC_CONFIG_PATH = "org.eclipse.virgo.medic.log.config.path";
    private static final String DEFAULT_CONTEXT_SELECTOR = "ch.qos.logback.classic.selector.DefaultContextSelector";
    private static final String PROPERTY_LOGBACK_CONTEXT_SELECTOR = "logback.ContextSelector";
    private final ServiceRegistrationTracker registrationTracker = new ServiceRegistrationTracker();
    private volatile StandardDumpGenerator dumpGenerator;
    private volatile LogBackEventLoggerFactory eventLoggerFactory;
    private volatile DumpContributorPublisher dumpContributorPublisher;
    private volatile PrintStream sysOut;
    private volatile PrintStream sysErr;
    private static final List<String> DEFAULT_LOGGING_PACKAGES = Arrays.asList("org.apache.commons.logging", "org.apache.log4j", "org.slf4j", "org.slf4j.impl", "org.eclipse.virgo.medic.log", "org.eclipse.virgo.medic.log.impl", "org.eclipse.virgo.medic.log.impl.logback");

    public void start(BundleContext context) throws Exception {
        ConfigurationAdminConfigurationProvider configurationProvider = new ConfigurationAdminConfigurationProvider(context);
        this.registrationTracker.track(context.registerService(ConfigurationListener.class.getName(), (Object)configurationProvider, null));
        this.logStart(context, configurationProvider);
        this.eventLogStart(context);
        this.dumpStart(context, configurationProvider);
    }

    public void stop(BundleContext context) throws Exception {
        this.registrationTracker.unregisterAll();
        this.dumpStop();
        this.logStop(context);
    }

    private void dumpStart(BundleContext context, ConfigurationProvider configurationProvider) {
        this.dumpGenerator = new StandardDumpGenerator(new StandardDumpContributorResolver(context), configurationProvider, this.eventLoggerFactory.createEventLogger(context.getBundle()));
        this.registrationTracker.track(context.registerService(DumpGenerator.class.getName(), (Object)this.dumpGenerator, null));
        this.dumpContributorPublisher = new DumpContributorPublisher(context);
        this.dumpContributorPublisher.publishDumpContributors();
    }

    private void dumpStop() {
        if (this.dumpGenerator != null) {
            this.dumpGenerator.close();
        }
        if (this.dumpContributorPublisher != null) {
            this.dumpContributorPublisher.retractDumpContributors();
        }
    }

    private void logStart(BundleContext context, ConfigurationProvider configurationProvider) throws ConfigurationPublicationFailedException {
        StandardContextSelectorDelegate delegate = MedicActivator.createContextSelectorDelegate(context);
        this.registrationTracker.track(context.registerService(BundleListener.class.getName(), (Object)delegate, null));
        DelegatingContextSelector.setDelegate(delegate);
        StandardLoggingConfigurationPublisher loggingConfigurationPublisher = new StandardLoggingConfigurationPublisher(context);
        this.registrationTracker.track(context.registerService(LoggingConfigurationPublisher.class.getName(), (Object)loggingConfigurationPublisher, null));
        this.publishDefaultConfigurationIfAvailable(context, loggingConfigurationPublisher);
        System.setProperty(PROPERTY_LOGBACK_CONTEXT_SELECTOR, DelegatingContextSelector.class.getName());
        SecurityManagerExecutionStackAccessor stackAccessor = new SecurityManagerExecutionStackAccessor();
        Dictionary<String, String> configuration = configurationProvider.getConfiguration();
        StandardDelegatingPrintStream delegatingSysOut = new StandardDelegatingPrintStream(System.out);
        StandardDelegatingPrintStream delegatingSysErr = new StandardDelegatingPrintStream(System.err);
        this.sysOut = System.out;
        this.sysErr = System.err;
        System.setOut(delegatingSysOut);
        System.setErr(delegatingSysErr);
        if (Boolean.valueOf(configuration.get("log.wrapSysOut")).booleanValue()) {
            this.publishDelegatingPrintStream(delegatingSysOut, LOGGER_NAME_SYSOUT_DELEGATE, context);
            this.publishPrintStream(this.sysOut, LOGGER_NAME_SYSOUT, context);
            System.setOut(this.wrapPrintStream(System.out, LOGGER_NAME_SYSOUT, LoggingLevel.INFO, stackAccessor, configurationProvider, "log.wrapSysOut"));
        }
        if (Boolean.valueOf(configuration.get("log.wrapSysErr")).booleanValue()) {
            this.publishDelegatingPrintStream(delegatingSysErr, LOGGER_NAME_SYSERR_DELEGATE, context);
            this.publishPrintStream(this.sysErr, LOGGER_NAME_SYSERR, context);
            System.setErr(this.wrapPrintStream(System.err, LOGGER_NAME_SYSERR, LoggingLevel.ERROR, stackAccessor, configurationProvider, "log.wrapSysErr"));
        }
    }

    private PrintStream wrapPrintStream(PrintStream printStream, String loggerName, LoggingLevel loggingLevel, ExecutionStackAccessor stackAccessor, ConfigurationProvider configurationProvider, String configurationProperty) {
        LoggingPrintStreamWrapper wrapper = new LoggingPrintStreamWrapper(printStream, loggerName, loggingLevel, stackAccessor, configurationProvider, configurationProperty);
        return wrapper;
    }

    private void publishPrintStream(PrintStream printStream, String name, BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("org.eclipse.virgo.medic.log.printStream", name);
        this.registrationTracker.track(context.registerService(PrintStream.class.getName(), (Object)printStream, properties));
    }

    private void publishDelegatingPrintStream(PrintStream printStream, String name, BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("org.eclipse.virgo.medic.log.printStream", name);
        String[] classes = new String[]{DelegatingPrintStream.class.getName()};
        this.registrationTracker.track(context.registerService(classes, (Object)printStream, properties));
    }

    private void publishDefaultConfigurationIfAvailable(BundleContext context, StandardLoggingConfigurationPublisher publisher) throws ConfigurationPublicationFailedException {
        File logConfigFile;
        String logConfigPath = context.getProperty(PROPERTY_MEDIC_CONFIG_PATH);
        if (logConfigPath != null && (logConfigFile = new File(logConfigPath)).exists()) {
            publisher.publishDefaultConfiguration(new File(logConfigPath));
        }
    }

    private static StandardContextSelectorDelegate createContextSelectorDelegate(BundleContext bundleContext) {
        ConfigurationLocator configurationLocator = MedicActivator.createConfigurationLocator(bundleContext);
        CallingBundleResolver loggingCallerLocator = MedicActivator.createLoggingCallerLocator();
        JoranLoggerContextConfigurer loggerContextConfigurer = new JoranLoggerContextConfigurer();
        return new StandardContextSelectorDelegate(loggingCallerLocator, configurationLocator, bundleContext.getBundle(), loggerContextConfigurer);
    }

    private static ConfigurationLocator createConfigurationLocator(BundleContext bundleContext) {
        return new CompositeConfigurationLocator(new ServiceRegistryConfigurationLocator(bundleContext), new BundleResourceConfigurationLocator());
    }

    private static CallingBundleResolver createLoggingCallerLocator() {
        ClassSelector classSelector = MedicActivator.createClassSelector();
        ExecutionStackAccessor executionStackAccessor = MedicActivator.createExecutionStackAccessor();
        return new StandardCallingBundleResolver(executionStackAccessor, classSelector);
    }

    private static ClassSelector createClassSelector() {
        return new PackageNameFilteringClassSelector(DEFAULT_LOGGING_PACKAGES);
    }

    private static ExecutionStackAccessor createExecutionStackAccessor() {
        return new SecurityManagerExecutionStackAccessor();
    }

    void logStop(BundleContext context) {
        System.setProperty(PROPERTY_LOGBACK_CONTEXT_SELECTOR, DEFAULT_CONTEXT_SELECTOR);
        DelegatingContextSelector.setDelegate(null);
        if (this.sysOut != null) {
            System.setOut(this.sysOut);
        }
        if (this.sysErr != null) {
            System.setErr(this.sysErr);
        }
    }

    private void eventLogStart(BundleContext context) {
        this.eventLoggerFactory = this.createFactory(context);
        EventLoggerServiceFactory serviceFactory = new EventLoggerServiceFactory(this.eventLoggerFactory);
        this.registrationTracker.track(context.registerService(EventLoggerFactory.class.getName(), (Object)this.eventLoggerFactory, null));
        this.registrationTracker.track(context.registerService(EventLogger.class.getName(), (Object)serviceFactory, null));
    }

    private LogBackEventLoggerFactory createFactory(BundleContext context) {
        BundleSearchingPropertyResourceBundleResolver resourceBundleResolver = new BundleSearchingPropertyResourceBundleResolver();
        return new LogBackEventLoggerFactory(resourceBundleResolver, new StandardLocaleResolver(), context.getBundle());
    }
}

