/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.apps.admin.core.BundleHolder;
import org.eclipse.virgo.apps.admin.core.ExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.ImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.RequiredBundleHolder;
import org.eclipse.virgo.apps.admin.core.ServiceHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardExportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardImportedPackageHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardRequiredBundleHolder;
import org.eclipse.virgo.apps.admin.core.state.StandardServiceHolder;
import org.eclipse.virgo.kernel.module.Component;
import org.eclipse.virgo.kernel.module.ModuleContext;
import org.eclipse.virgo.kernel.module.ModuleContextAccessor;
import org.eclipse.virgo.kernel.module.NoSuchComponentException;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiBundle;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiExportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiImportPackage;
import org.eclipse.virgo.kernel.osgi.quasi.QuasiRequiredBundle;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveBundle;
import org.eclipse.virgo.kernel.shell.state.QuasiLiveService;
import org.osgi.framework.Bundle;

final class StandardBundleHolder
implements BundleHolder {
    private final ModuleContextAccessor moduleContextAccessor;
    private final QuasiBundle quasiBundle;

    public StandardBundleHolder(QuasiBundle bundle, ModuleContextAccessor moduleContextAccessor) {
        if (bundle == null || moduleContextAccessor == null) {
            throw new IllegalArgumentException("StandardBundleHolder must be provided with non-null QuasiBundle and ModuleContextAccessor.");
        }
        this.quasiBundle = bundle;
        this.moduleContextAccessor = moduleContextAccessor;
    }

    @Override
    public Long getBundleId() {
        return this.quasiBundle.getBundleId();
    }

    @Override
    public String getSymbolicName() {
        return this.quasiBundle.getSymbolicName();
    }

    @Override
    public String getState() {
        if (this.quasiBundle instanceof QuasiLiveBundle) {
            QuasiLiveBundle quasiLiveBundle = (QuasiLiveBundle)this.quasiBundle;
            return quasiLiveBundle.getState();
        }
        return this.quasiBundle.isResolved() ? "Resolved" : "Unresolved";
    }

    @Override
    public boolean isResolved() {
        return this.quasiBundle.isResolved();
    }

    @Override
    public String getVersion() {
        return this.quasiBundle.getVersion().toString();
    }

    @Override
    public Bundle getRawBundle() {
        return this.quasiBundle.getBundle();
    }

    @Override
    public String getBundleLocation() {
        Bundle bundle2 = this.quasiBundle.getBundle();
        if (bundle2 != null) {
            return bundle2.getLocation();
        }
        return "";
    }

    @Override
    public String getSpringName() {
        ModuleContext moduleContext;
        Bundle realBundle = this.quasiBundle.getBundle();
        if (realBundle != null && (moduleContext = this.moduleContextAccessor.getModuleContext(realBundle)) != null) {
            return moduleContext.getDisplayName();
        }
        return "";
    }

    @Override
    public List<Component> getBeans() {
        ModuleContext moduleContext;
        ArrayList<Component> beans = new ArrayList<Component>();
        Bundle realBundle = this.quasiBundle.getBundle();
        if (realBundle != null && (moduleContext = this.moduleContextAccessor.getModuleContext(realBundle)) != null) {
            String[] stringArray = moduleContext.getComponentNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                try {
                    beans.add(moduleContext.getComponent(name));
                }
                catch (NoSuchComponentException noSuchComponentException) {}
                ++n2;
            }
        }
        return beans;
    }

    @Override
    public List<ExportedPackageHolder> getExportPackages() {
        ArrayList<ExportedPackageHolder> exportedPackageHolders = new ArrayList<ExportedPackageHolder>();
        List exportPackages = this.quasiBundle.getExportPackages();
        for (QuasiExportPackage exportPackage : exportPackages) {
            exportedPackageHolders.add(new StandardExportedPackageHolder(exportPackage, this.moduleContextAccessor));
        }
        return exportedPackageHolders;
    }

    @Override
    public List<ImportedPackageHolder> getImportPackages() {
        ArrayList<ImportedPackageHolder> importedPackageHolders = new ArrayList<ImportedPackageHolder>();
        List importPackages = this.quasiBundle.getImportPackages();
        for (QuasiImportPackage importPackage : importPackages) {
            importedPackageHolders.add(new StandardImportedPackageHolder(importPackage, this.moduleContextAccessor));
        }
        return importedPackageHolders;
    }

    @Override
    public List<RequiredBundleHolder> getRequiredBundles() {
        List quasiRequiredBundles = this.quasiBundle.getRequiredBundles();
        ArrayList<RequiredBundleHolder> requiredBundleHolders = new ArrayList<RequiredBundleHolder>();
        if (quasiRequiredBundles != null) {
            for (QuasiRequiredBundle quasiRequiredBundle : quasiRequiredBundles) {
                requiredBundleHolders.add(new StandardRequiredBundleHolder(quasiRequiredBundle, this.moduleContextAccessor));
            }
        }
        return requiredBundleHolders;
    }

    @Override
    public List<BundleHolder> getHosts() {
        ArrayList<BundleHolder> artifactHolders = new ArrayList<BundleHolder>();
        List hosts = this.quasiBundle.getHosts();
        if (hosts != null) {
            for (QuasiBundle hostQuasiBundle : hosts) {
                artifactHolders.add(new StandardBundleHolder(hostQuasiBundle, this.moduleContextAccessor));
            }
        }
        return artifactHolders;
    }

    @Override
    public List<BundleHolder> getFragments() {
        ArrayList<BundleHolder> artifactHolders = new ArrayList<BundleHolder>();
        List fragments = this.quasiBundle.getFragments();
        if (fragments != null) {
            for (QuasiBundle fragmentQuasiBundle : fragments) {
                artifactHolders.add(new StandardBundleHolder(fragmentQuasiBundle, this.moduleContextAccessor));
            }
        }
        return artifactHolders;
    }

    @Override
    public List<ServiceHolder> getExportedServices() {
        ArrayList<ServiceHolder> serviceHolders = new ArrayList<ServiceHolder>();
        if (this.quasiBundle instanceof QuasiLiveBundle) {
            QuasiLiveBundle quasiLiveBundle = (QuasiLiveBundle)this.quasiBundle;
            List exportedServices = quasiLiveBundle.getExportedServices();
            for (QuasiLiveService quasiLiveService : exportedServices) {
                serviceHolders.add(new StandardServiceHolder(quasiLiveService, this.moduleContextAccessor));
            }
        }
        return serviceHolders;
    }

    @Override
    public List<ServiceHolder> getImportedServices() {
        ArrayList<ServiceHolder> serviceHolders = new ArrayList<ServiceHolder>();
        if (this.quasiBundle instanceof QuasiLiveBundle) {
            QuasiLiveBundle quasiLiveBundle = (QuasiLiveBundle)this.quasiBundle;
            List importedServices = quasiLiveBundle.getImportedServices();
            for (QuasiLiveService quasiLiveService : importedServices) {
                serviceHolders.add(new StandardServiceHolder(quasiLiveService, this.moduleContextAccessor));
            }
        }
        return serviceHolders;
    }

    @Override
    public int compareTo(BundleHolder o) {
        return this.getBundleId().compareTo(o.getBundleId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)this.quasiBundle.getBundleId();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StandardBundleHolder other = (StandardBundleHolder)obj;
        return this.quasiBundle.getBundleId() == other.quasiBundle.getBundleId();
    }
}

