/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.apps.admin.core.state;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.ZipException;
import org.eclipse.virgo.apps.admin.core.DumpExtractor;
import org.eclipse.virgo.apps.admin.core.dump.DumpPathLocator;
import org.eclipse.virgo.kernel.services.work.WorkArea;
import org.eclipse.virgo.util.io.FileSystemUtils;
import org.eclipse.virgo.util.io.PathReference;
import org.eclipse.virgo.util.io.ZipUtils;

final class StateDumpExtractor
implements DumpExtractor {
    private final File stagingDir;
    private final DumpPathLocator dumpPathLocator;

    public StateDumpExtractor(WorkArea workArea, DumpPathLocator dumpPathLocator) {
        this.stagingDir = workArea.getWorkDirectory().newChild("extracted-state-dumps").createDirectory().toFile();
        this.dumpPathLocator = dumpPathLocator;
    }

    @Override
    public File getStateDump(String dump) throws ZipException, IOException {
        if (dump == null) {
            throw new IllegalArgumentException("Requested dump can not be null");
        }
        File dumpFolder = this.dumpPathLocator.getDumpFolder(dump);
        if (dumpFolder == null) {
            throw new IOException(String.format("Requested dump does not exist or is not a folder '%s'", dump));
        }
        File[] stateDumpZipFiles = FileSystemUtils.listFiles((File)dumpFolder, (FilenameFilter)new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals("osgi.zip");
            }
        });
        if (stateDumpZipFiles.length != 1) {
            throw new IOException(String.format("Exactly 1 state dump zip expected, found '%s'", stateDumpZipFiles.length));
        }
        File stateDumpZipFile = stateDumpZipFiles[0];
        File stateDump = this.unzip(stateDumpZipFile);
        return stateDump;
    }

    private File unzip(File stateDumpZipFile) throws IOException {
        PathReference zipFile = new PathReference(stateDumpZipFile);
        PathReference dest = new PathReference(this.stagingDir);
        return new File(ZipUtils.unzipTo((PathReference)zipFile, (PathReference)dest).toFile(), "state");
    }
}

