/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.hook;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.hooks.bundle.FindHook;

public final class RegionBundleFindHook
implements FindHook {
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public RegionBundleFindHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void find(BundleContext context, Collection<Bundle> bundles) {
        try {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            if (context.getBundle().getBundleId() != 0L) {
                Region finderRegion = this.getRegion(context);
                if (finderRegion == null) {
                    bundles.clear();
                } else {
                    Set<Bundle> allowed = this.getAllowed(finderRegion, bundles, new HashSet<Region>());
                    bundles.retainAll(allowed);
                }
            }
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Set<Bundle> getAllowed(Region r, Collection<Bundle> bundles, Set<Region> path) {
        HashSet<Bundle> allowed = new HashSet<Bundle>();
        if (!path.contains(r)) {
            this.allowBundlesInRegion(allowed, r, bundles);
            this.allowImportedBundles(allowed, r, bundles, path);
        }
        return allowed;
    }

    private void allowImportedBundles(Set<Bundle> allowed, Region r, Collection<Bundle> bundles, Set<Region> path) {
        try {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            for (RegionDigraph.FilteredRegion fr : this.regionDigraph.getEdges(r)) {
                Set<Bundle> a = this.getAllowed(fr.getRegion(), bundles, this.extendPath(r, path));
                this.filter(a, fr.getFilter());
                allowed.addAll(a);
            }
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void allowBundlesInRegion(Set<Bundle> allowed, Region r, Collection<Bundle> bundles) {
        try {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            for (Bundle b : bundles) {
                if (!r.contains(b)) continue;
                allowed.add(b);
            }
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Set<Region> extendPath(Region r, Set<Region> path) {
        try {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            HashSet<Region> newPath = new HashSet<Region>(path);
            newPath.add(r);
            HashSet<Region> hashSet = newPath;
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return hashSet;
        }
        catch (Throwable throwable) {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void filter(Set<Bundle> bundles, RegionFilter filter) {
        try {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            Iterator<Bundle> i = bundles.iterator();
            while (i.hasNext()) {
                Bundle b = i.next();
                if (filter.isBundleAllowed(b.getSymbolicName(), b.getVersion())) continue;
                i.remove();
            }
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            RegionBundleFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private Region getRegion(BundleContext context) {
        Bundle b = context.getBundle();
        for (Region r : this.regionDigraph) {
            if (!r.contains(b)) continue;
            return r;
        }
        return null;
    }

    static {
        Factory factory = new Factory("RegionBundleFindHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "find", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook", "org.osgi.framework.BundleContext:java.util.Collection:", "context:bundles:", "", "void"), 47);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowImportedBundles", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:java.util.Set:", "allowed:r:bundles:path:", "", "void"), 74);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowBundlesInRegion", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:", "allowed:r:bundles:", "", "void"), 82);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extendPath", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook", "org.eclipse.virgo.kernel.osgi.region.Region:java.util.Set:", "r:path:", "", "java.util.Set"), 90);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filter", "org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "bundles:filter:", "", "void"), 96);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionBundleFindHook");
    }
}

