/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.hook;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.kernel.osgi.region.RegionPackageImportPolicy;
import org.eclipse.virgo.kernel.serviceability.Assert;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;

final class RegionResolverHook
implements ResolverHook {
    private static final long INVALID_BUNDLE_ID = -1L;
    private static final Boolean DEBUG;
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    static {
        Factory factory = new Factory("RegionResolverHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterMatches", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRequirement:java.util.Collection:", "requirement:candidates:", "", "void"), 53);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowImportedPackages", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:java.util.Set:", "allowed:r:candidates:path:", "", "void"), 118);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowPackagesInRegion", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:", "allowed:r:candidates:", "", "void"), 126);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extendPath", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.eclipse.virgo.kernel.osgi.region.Region:java.util.Set:", "r:path:", "", "java.util.Set"), 134);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filter", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "capabilities:filter:", "", "void"), 140);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "end", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "", "", "", "void"), 171);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterResolvable", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "java.util.Collection:", "candidates:", "", "void"), 175);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "filterSingletonCollisions", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleCapability:java.util.Collection:", "singleton:collisionCandidates:", "", "void"), 179);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "debugEntry", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRevision:java.util.Collection:", "requirer:candidates:", "", "void"), 183);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "debugExit", "org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook", "org.osgi.framework.wiring.BundleRevision:java.util.Collection:", "requirer:candidates:", "", "void"), 206);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionResolverHook");
        DEBUG = false;
    }

    RegionResolverHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            BundleRevision requirer = requirement.getRevision();
            try {
                if (DEBUG.booleanValue()) {
                    this.debugEntry(requirer, candidates);
                }
                if (this.getBundleId(requirer) != 0L) {
                    Region requirerRegion = this.getRegion(requirer);
                    if (requirerRegion == null) {
                        candidates.clear();
                    } else {
                        Set<BundleCapability> allowed = this.getAllowed(requirerRegion, candidates, new HashSet<Region>());
                        candidates.retainAll(allowed);
                    }
                }
            }
            finally {
                if (DEBUG.booleanValue()) {
                    this.debugExit(requirer, candidates);
                }
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Region getRegion(BundleRevision bundleRevision) {
        Bundle bundle = bundleRevision.getBundle();
        if (bundle != null) {
            return this.getRegion(bundle);
        }
        Long bundleId = this.getBundleId(bundleRevision);
        return this.getRegion(bundleId);
    }

    private Region getRegion(Long bundleId) {
        return this.regionDigraph.getRegion(bundleId);
    }

    private Long getBundleId(BundleRevision bundleRevision) {
        Bundle bundle = bundleRevision.getBundle();
        if (bundle != null) {
            return bundle.getBundleId();
        }
        if (bundleRevision instanceof BundleDescription) {
            BundleDescription bundleDescription = (BundleDescription)bundleRevision;
            return bundleDescription.getBundleId();
        }
        Assert.isTrue((boolean)false, (String)"Cannot determine bundle id of BundleRevision '%s'", (Object[])new Object[]{bundleRevision});
        return -1L;
    }

    private Set<BundleCapability> getAllowed(Region r, Collection<BundleCapability> candidates, Set<Region> path) {
        HashSet<BundleCapability> allowed = new HashSet<BundleCapability>();
        if (!path.contains(r)) {
            this.allowPackagesInRegion(allowed, r, candidates);
            this.allowImportedPackages(allowed, r, candidates, path);
        }
        return allowed;
    }

    private void allowImportedPackages(Set<BundleCapability> allowed, Region r, Collection<BundleCapability> candidates, Set<Region> path) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            for (RegionDigraph.FilteredRegion fr : this.regionDigraph.getEdges(r)) {
                Set<BundleCapability> a = this.getAllowed(fr.getRegion(), candidates, this.extendPath(r, path));
                this.filter(a, fr.getFilter());
                allowed.addAll(a);
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void allowPackagesInRegion(Set<BundleCapability> allowed, Region r, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            for (BundleCapability b : candidates) {
                if (!r.equals(this.getRegion(b.getRevision()))) continue;
                allowed.add(b);
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Set<Region> extendPath(Region r, Set<Region> path) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            HashSet<Region> newPath = new HashSet<Region>(path);
            newPath.add(r);
            HashSet<Region> hashSet = newPath;
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return hashSet;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void filter(Set<BundleCapability> capabilities, RegionFilter filter) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            RegionPackageImportPolicy packageImportPolicy = filter.getPackageImportPolicy();
            Iterator<BundleCapability> i = capabilities.iterator();
            while (i.hasNext()) {
                BundleCapability c = i.next();
                String namespace = c.getNamespace();
                if ("osgi.wiring.package".equals(namespace)) {
                    if (packageImportPolicy.isImported((String)c.getAttributes().get("osgi.wiring.package"), c.getAttributes(), c.getDirectives())) continue;
                    i.remove();
                    continue;
                }
                BundleRevision providerRevision = c.getRevision();
                if (filter.isBundleAllowed(providerRevision.getSymbolicName(), providerRevision.getVersion())) continue;
                i.remove();
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private Region getRegion(Bundle bundle) {
        for (Region r : this.regionDigraph) {
            if (!r.contains(bundle)) continue;
            return r;
        }
        return null;
    }

    public void end() {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_5);
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_5);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_5);
            throw throwable;
        }
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_6);
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_6);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_6);
            throw throwable;
        }
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisionCandidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_7);
            collisionCandidates.clear();
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_7);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_7);
            throw throwable;
        }
    }

    private void debugEntry(BundleRevision requirer, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_8);
            System.out.println("Requirer: " + requirer.getSymbolicName() + "_" + requirer.getVersion() + "[" + this.getBundleId(requirer) + "]");
            System.out.println("  Candidates: ");
            for (BundleCapability c : candidates) {
                BundleRevision providerRevision;
                String namespace = c.getNamespace();
                if ("osgi.wiring.package".equals(namespace)) {
                    providerRevision = c.getRevision();
                    String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                    System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                    if (!pkg.equals("slow")) continue;
                    System.out.println(">>> put breakpoint here <<<");
                    continue;
                }
                providerRevision = c.getRevision();
                System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_8);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_8);
            throw throwable;
        }
    }

    private void debugExit(BundleRevision requirer, Collection<BundleCapability> candidates) {
        try {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_9);
            System.out.println("  Filtered candidates: ");
            for (BundleCapability c : candidates) {
                BundleRevision providerRevision;
                String namespace = c.getNamespace();
                if ("osgi.wiring.package".equals(namespace)) {
                    providerRevision = c.getRevision();
                    String pkg = (String)c.getAttributes().get("osgi.wiring.package");
                    System.out.println("    Package " + pkg + " from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
                    if (!pkg.equals("slow")) continue;
                    System.out.println(">>> put breakpoint here <<<");
                    continue;
                }
                providerRevision = c.getRevision();
                System.out.println("    Bundle from provider " + providerRevision.getSymbolicName() + "_" + providerRevision.getVersion() + "[" + this.getBundleId(providerRevision) + "]");
            }
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_9);
            return;
        }
        catch (Throwable throwable) {
            RegionResolverHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_9);
            throw throwable;
        }
    }
}

