/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.web.tomcat;

import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.connector.Connector;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.serviceability.dump.DumpCoordinator;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.eclipse.virgo.util.io.NetUtils;
import org.eclipse.virgo.web.tomcat.TomcatLogEvents;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public final class ServerLifecycleLoggingListener
implements LifecycleListener {
    private final EventLogger eventLogger;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public ServerLifecycleLoggingListener() {
        try {
            try {
            }
            catch (RuntimeException runtimeException) {
                DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
                throw runtimeException;
            }
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            this.eventLogger = (EventLogger)bundleContext.getService(bundleContext.getServiceReference(EventLogger.class.getName()));
            return;
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    public void lifecycleEvent(LifecycleEvent event) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
                Object source = event.getSource();
                if (source instanceof Server) {
                    this.handleServerLifecycle((Server)source, event);
                } else if (source instanceof Service) {
                    this.handleServiceLifecycle((Service)source, event);
                } else if (source instanceof Connector) {
                    this.handleConnectorLifecycle((Connector)source, event);
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleConnectorLifecycle(Connector source, LifecycleEvent event) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
                String type = event.getType();
                if ("start".equals(type)) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.CREATING_CONNECTOR, new Object[]{source.getProtocol(), source.getScheme(), source.getPort()});
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleServiceLifecycle(Service service, LifecycleEvent event) {
        try {
            try {
                Connector[] connectors;
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
                String type = event.getType();
                Connector[] connectorArray = connectors = service.findConnectors();
                int n = connectors.length;
                int n2 = 0;
                while (n2 < n) {
                    Connector connector = connectorArray[n2];
                    if ("before_start".equals(type)) {
                        connector.addLifecycleListener((LifecycleListener)this);
                    } else if ("after_stop".equals(type)) {
                        connector.removeLifecycleListener((LifecycleListener)this);
                    }
                    ++n2;
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void handleServerLifecycle(Server server, LifecycleEvent event) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
                String type = event.getType();
                if ("before_start".equals(type)) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.STARTING_TOMCAT, new Object[0]);
                } else if ("after_start".equals(type)) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.TOMCAT_STARTED, new Object[0]);
                } else if ("before_stop".equals(type)) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.STOPPING_TOMCAT, new Object[0]);
                } else if ("after_stop".equals(type)) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.TOMCAT_STOPPED, new Object[0]);
                }
                Service[] services = server.findServices();
                if ("init".equals(type)) {
                    this.checkConnectorPortsAvailable(services);
                }
                this.propagateListeners(event, services);
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void checkConnectorPortsAvailable(Service[] services) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
                Service[] serviceArray = services;
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    Connector[] connectors;
                    Service service = serviceArray[n2];
                    Connector[] connectorArray = connectors = service.findConnectors();
                    int n3 = connectors.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Connector connector = connectorArray[n4];
                        this.checkPortAvailability(connector);
                        ++n4;
                    }
                    ++n2;
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void propagateListeners(LifecycleEvent event, Service[] services) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_5);
                String type = event.getType();
                Service[] serviceArray = services;
                int n = services.length;
                int n2 = 0;
                while (n2 < n) {
                    Service service = serviceArray[n2];
                    if (service instanceof Lifecycle) {
                        if ("before_start".equals(type)) {
                            ((Lifecycle)service).addLifecycleListener((LifecycleListener)this);
                        } else if ("after_stop".equals(type)) {
                            ((Lifecycle)service).removeLifecycleListener((LifecycleListener)this);
                        }
                    }
                    ++n2;
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_5);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_5);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    private void checkPortAvailability(Connector connector) {
        try {
            try {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_6);
                String hostName = (String)connector.getProperty("address");
                if (hostName == null) {
                    if (!NetUtils.isPortAvailable((int)connector.getPort())) {
                        this.eventLogger.log((LogEvent)TomcatLogEvents.PORT_IN_USE, new Object[]{connector.getPort()});
                        System.exit(-1);
                    }
                } else if (!NetUtils.isPortAvailable((String)hostName, (int)connector.getPort())) {
                    this.eventLogger.log((LogEvent)TomcatLogEvents.PORT_IN_USE, new Object[]{connector.getPort(), hostName});
                    System.exit(-1);
                }
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_6);
                return;
            }
            catch (Throwable throwable) {
                ServerLifecycleLoggingListener.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_6);
                throw throwable;
            }
        }
        catch (RuntimeException runtimeException) {
            DumpCoordinator.aspectOf().ajc$afterThrowing$org_eclipse_virgo_kernel_serviceability_dump_DumpCoordinator$1$7340b330(runtimeException);
            throw runtimeException;
        }
    }

    static {
        Factory factory = new Factory("ServerLifecycleLoggingListener.java", Class.forName("org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "lifecycleEvent", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.LifecycleEvent:", "event:", "", "void"), 36);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleConnectorLifecycle", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.connector.Connector:org.apache.catalina.LifecycleEvent:", "source:event:", "", "void"), 47);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleServiceLifecycle", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.Service:org.apache.catalina.LifecycleEvent:", "service:event:", "", "void"), 54);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleServerLifecycle", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.Server:org.apache.catalina.LifecycleEvent:", "server:event:", "", "void"), 66);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkConnectorPortsAvailable", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "[Lorg.apache.catalina.Service;:", "services:", "", "void"), 85);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "propagateListeners", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.LifecycleEvent:[Lorg.apache.catalina.Service;:", "event:services:", "", "void"), 94);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "checkPortAvailability", "org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener", "org.apache.catalina.connector.Connector:", "connector:", "", "void"), 107);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.web.tomcat.ServerLifecycleLoggingListener");
    }
}

