/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.osgi.manifest.parse.standard;

import org.eclipse.virgo.util.osgi.manifest.parse.standard.HeaderToken;

public enum HeaderTokenKind {
    NUMBER("Number", true),
    ALPHAS("Alphas", true),
    ALPHANUMERIC("Alphanumeric", true),
    DOT("."),
    DOTSTAR(".*"),
    TOKEN("Token", true),
    QUOTEDSTRING("QuotedString"),
    IDENTIFIER("Identifier"),
    SEMICOLON(";"),
    COLONEQUALS(":="),
    COMMA(","),
    EQUALS("="),
    STAR("*"),
    SLASH("/"),
    PATHELEMENT("PathElement");

    private String tokenString;
    private boolean canBeTreatedAsToken;

    private HeaderTokenKind(String messageString, boolean canBeTreatedAsToken) {
        this.tokenString = messageString;
        this.canBeTreatedAsToken = canBeTreatedAsToken;
    }

    private HeaderTokenKind(String messageString) {
        this(messageString, false);
    }

    public String getString() {
        return this.tokenString;
    }

    public static boolean isNumber(HeaderToken token) {
        return token.getKind() == NUMBER;
    }

    public static boolean isAlphas(HeaderToken token) {
        return token.getKind() == ALPHAS;
    }

    public static boolean isAlphanumeric(HeaderToken token) {
        return token.getKind() == ALPHANUMERIC;
    }

    public static boolean isToken(HeaderToken token) {
        return token.getKind() == TOKEN;
    }

    public static boolean isEquals(HeaderToken token) {
        return token.getKind() == EQUALS;
    }

    public static boolean isColonEquals(HeaderToken token) {
        return token.getKind() == COLONEQUALS;
    }

    public static boolean isQuotedString(HeaderToken token) {
        return token.getKind() == QUOTEDSTRING;
    }

    public static boolean isDot(HeaderToken token) {
        return token.getKind() == DOT;
    }

    public static boolean isSemicolon(HeaderToken token) {
        return token.getKind() == SEMICOLON;
    }

    public static boolean isSlash(HeaderToken token) {
        return token.getKind() == SLASH;
    }

    public static boolean isComma(HeaderToken token) {
        return token.getKind() == COMMA;
    }

    public static boolean isIdentifier(HeaderToken token) {
        return token.getKind() == IDENTIFIER;
    }

    public static boolean canBeTreatedAsIdentifier(HeaderToken t) {
        return t.getKind() == IDENTIFIER || t.getKind().canBeTreatedAsToken && (t.firstCharIsLetter() || Character.isJavaIdentifierStart(t.firstChar()));
    }

    public static boolean canBeTreatedAsToken(HeaderToken token) {
        return token.getKind().canBeTreatedAsToken;
    }

    public static boolean canBeTreatedAsExtendedToken(HeaderToken argumentToken) {
        return HeaderTokenKind.canBeTreatedAsToken(argumentToken) || HeaderTokenKind.isDot(argumentToken);
    }

    public static boolean isSemicolonOrComma(HeaderToken t) {
        HeaderTokenKind k = t.getKind();
        return k == SEMICOLON || k == COMMA;
    }

    public static boolean isStar(HeaderToken token) {
        return token.getKind() == STAR;
    }

    public static boolean isDotStar(HeaderToken token2) {
        return token2.getKind() == DOTSTAR;
    }

    public static boolean canBeTreatedAsPathElement(HeaderToken t) {
        boolean pathElement;
        if (t == null) {
            return false;
        }
        HeaderTokenKind k = t.getKind();
        boolean bl = pathElement = k == DOT || k == STAR || k == DOTSTAR || k == COLONEQUALS || k == PATHELEMENT || HeaderTokenKind.canBeTreatedAsIdentifier(t);
        if (pathElement) {
            return true;
        }
        return k == TOKEN && t.firstChar() == '-';
    }
}

