/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.eclipse.gemini.web.core.spi.ServletContainerException;
import org.eclipse.virgo.util.io.IOUtils;
import org.eclipse.virgo.util.io.PathReference;

public class WebappConfigLocator {
    static final String DEFAULT_CONFIG_DIRECTORY = "config";
    private static final String DEFAULT_CONTEXT_XML = "context.xml";
    private static final String DEFAULT_WEB_XML = "web.xml";
    private static final String CONTEXT_XML = "META-INF/context.xml";
    private static final String XML_EXTENSION = ".xml";
    private static final String ROOT_PATH = "/";
    private static final String ROOT_CONTEXT_FILE = "ROOT";
    private static final char SLASH_SEPARATOR = '/';
    private static final char HASH_SEPARATOR = '#';

    public static String resolveDefaultContextXml(File configLocation) {
        if (configLocation == null) {
            return null;
        }
        File defaultContextXml = new File(configLocation, DEFAULT_CONTEXT_XML);
        if (defaultContextXml.exists()) {
            return WebappConfigLocator.getRelativePath(defaultContextXml);
        }
        return null;
    }

    public static String resolveDefaultWebXml(File configLocation) {
        if (configLocation == null) {
            return null;
        }
        File defaultWebXml = new File(configLocation, DEFAULT_WEB_XML);
        if (defaultWebXml.exists()) {
            return defaultWebXml.getAbsolutePath();
        }
        return null;
    }

    public static File resolveWebappContextXml(String path, String docBase, File configLocation) {
        File contextXml = new File(configLocation, String.valueOf(path = WebappConfigLocator.formatContextPath(path)) + XML_EXTENSION);
        if (contextXml.exists()) {
            return contextXml;
        }
        File docBaseFile = new File(docBase);
        if (docBaseFile.isDirectory()) {
            contextXml = new File(docBaseFile, CONTEXT_XML);
            if (contextXml.exists()) {
                return contextXml;
            }
        } else {
            JarFile jar;
            try {
                jar = new JarFile(docBaseFile);
            }
            catch (IOException e) {
                throw new ServletContainerException("Cannot open for reading " + docBaseFile.getAbsolutePath(), (Throwable)e);
            }
            ZipEntry contextXmlEntry = jar.getEntry(CONTEXT_XML);
            if (contextXmlEntry != null) {
                File destination = new File(configLocation, String.valueOf(path) + XML_EXTENSION);
                try {
                    WebappConfigLocator.copyFile(jar.getInputStream(contextXmlEntry), destination);
                }
                catch (IOException e) {
                    throw new ServletContainerException("Cannot copy " + contextXml.getAbsolutePath() + " to " + destination.getAbsolutePath(), (Throwable)e);
                }
                return destination;
            }
        }
        return null;
    }

    public static File resolveWebappConfigDir(File mainConfigDir, Host host) {
        File configLocation = mainConfigDir = mainConfigDir != null ? mainConfigDir : new File(DEFAULT_CONFIG_DIRECTORY);
        Container parent = host.getParent();
        if (parent != null && parent instanceof Engine) {
            configLocation = new File(configLocation, parent.getName());
        }
        return new File(configLocation, host.getName());
    }

    private static String formatContextPath(String contextPath) {
        if (contextPath.equals(ROOT_PATH)) {
            contextPath = ROOT_CONTEXT_FILE;
        } else if ('/' == contextPath.charAt(0)) {
            contextPath = contextPath.substring(1);
        }
        return contextPath.replace('/', '#');
    }

    private static void copyFile(InputStream source, File destination) throws IOException {
        PathReference destinationRef = new PathReference(destination);
        destinationRef.getParent().createDirectory();
        FileOutputStream outputStream = null;
        try {
            int read;
            outputStream = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            while ((read = source.read(buffer)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, read);
            }
        }
        finally {
            IOUtils.closeQuietly((Closeable)source);
            IOUtils.closeQuietly((Closeable)outputStream);
        }
    }

    private static String getRelativePath(File file) {
        return new File(".").toURI().relativize(file.toURI()).toString();
    }
}

