/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.modeler.Registry;

abstract class BaseWebappLoader
implements Loader,
Lifecycle,
PropertyChangeListener,
MBeanRegistration {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.loader");
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private boolean delegate = false;
    private Container container = null;
    private boolean initialized = false;
    private ObjectName controller;
    private ObjectName objectName;
    private boolean reloadable = false;

    BaseWebappLoader() {
    }

    protected final void ensureGrandparentIsAnEngine(StandardContext standardContext) {
        if (!(standardContext.getParent().getParent() instanceof Engine)) {
            throw new IllegalStateException("Grandparent of [" + standardContext + "] is not an instanceof [" + Engine.class.getName() + "].");
        }
    }

    protected String getCatalinaContextPath(StandardContext context) {
        String contextPath = context.getPath();
        if (contextPath.equals("")) {
            contextPath = "/";
        }
        return contextPath;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.objectName == null && this.container instanceof StandardContext) {
            try {
                StandardContext ctx = (StandardContext)this.container;
                this.ensureGrandparentIsAnEngine(ctx);
                this.objectName = new ObjectName(String.valueOf(ctx.getEngineName()) + ":type=Loader,path=" + this.getCatalinaContextPath(ctx) + ",host=" + ctx.getParent().getName());
                Registry.getRegistry(null, null).registerComponent((Object)this, this.objectName, null);
                this.controller = this.objectName;
            }
            catch (Exception e) {
                this.log.error((Object)"Error registering loader", (Throwable)e);
            }
        }
    }

    protected void destroy() {
        if (this.controller == this.objectName) {
            Registry.getRegistry(null, null).unregisterComponent(this.objectName);
            this.objectName = null;
        }
        this.initialized = false;
    }

    protected final ObjectName getObjectName() {
        return this.objectName;
    }

    public void backgroundProcess() {
        if (this.reloadable && this.modified()) {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                if (this.getContainer() instanceof StandardContext) {
                    ((StandardContext)this.getContainer()).reload();
                }
            }
            finally {
                if (this.getContainer().getLoader() != null) {
                    Thread.currentThread().setContextClassLoader(this.getContainer().getLoader().getClassLoader());
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container != null && this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public final Container getContainer() {
        return this.container;
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public boolean getReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public boolean getDelegate() {
        return this.delegate;
    }

    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("reloadable")) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (Exception exception) {
                this.log.error((Object)sm.getString("webappLoader.reloadable", (Object)event.getNewValue().toString()));
            }
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        return objectName;
    }
}

