/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.osgi.region.hook;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.virgo.kernel.osgi.region.Region;
import org.eclipse.virgo.kernel.osgi.region.RegionDigraph;
import org.eclipse.virgo.kernel.osgi.region.RegionFilter;
import org.eclipse.virgo.medic.log.EntryExitTrace;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.hooks.service.FindHook;

public final class RegionServiceFindHook
implements FindHook {
    private final RegionDigraph regionDigraph;
    private static transient /* synthetic */ EntryExitTrace ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    public RegionServiceFindHook(RegionDigraph regionDigraph) {
        this.regionDigraph = regionDigraph;
    }

    public void find(BundleContext context, String name, String filter, boolean allServices, Collection<ServiceReference<?>> references) {
        try {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$1$557a3571(ajc$tjp_0);
            if (context.getBundle().getBundleId() != 0L) {
                Region finderRegion = this.getRegion(context);
                if (finderRegion == null) {
                    references.clear();
                } else {
                    Set<ServiceReference<?>> allowed = this.getAllowed(finderRegion, references, new HashSet<Region>());
                    references.retainAll(allowed);
                }
            }
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$2$557a3571(ajc$tjp_0);
            return;
        }
        catch (Throwable throwable) {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$3$557a3571(throwable, ajc$tjp_0);
            throw throwable;
        }
    }

    private Set<ServiceReference<?>> getAllowed(Region r, Collection<ServiceReference<?>> references, Set<Region> path) {
        HashSet allowed = new HashSet();
        if (!path.contains(r)) {
            this.allowServiceReferencesInRegion(allowed, r, references);
            this.allowImportedBundles(allowed, r, references, path);
        }
        return allowed;
    }

    private void allowImportedBundles(Set<ServiceReference<?>> allowed, Region r, Collection<ServiceReference<?>> references, Set<Region> path) {
        try {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_1);
            for (RegionDigraph.FilteredRegion fr : this.regionDigraph.getEdges(r)) {
                Set<ServiceReference<?>> a = this.getAllowed(fr.getRegion(), references, this.extendPath(r, path));
                this.filter(a, fr.getFilter());
                allowed.addAll(a);
            }
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_1);
            return;
        }
        catch (Throwable throwable) {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_1);
            throw throwable;
        }
    }

    private void allowServiceReferencesInRegion(Set<ServiceReference<?>> allowed, Region r, Collection<ServiceReference<?>> references) {
        try {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_2);
            for (ServiceReference<?> b : references) {
                if (!r.contains(b.getBundle())) continue;
                allowed.add(b);
            }
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_2);
            return;
        }
        catch (Throwable throwable) {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_2);
            throw throwable;
        }
    }

    private Set<Region> extendPath(Region r, Set<Region> path) {
        try {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_3);
            HashSet<Region> newPath = new HashSet<Region>(path);
            newPath.add(r);
            HashSet<Region> hashSet = newPath;
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_3);
            return hashSet;
        }
        catch (Throwable throwable) {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_3);
            throw throwable;
        }
    }

    private void filter(Set<ServiceReference<?>> references, RegionFilter filter) {
        try {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$before$org_eclipse_virgo_medic_log_EntryExitTrace$4$4844ef3f(ajc$tjp_4);
            Filter serviceFilter = filter.getServiceFilter();
            Iterator<ServiceReference<?>> i = references.iterator();
            while (i.hasNext()) {
                ServiceReference<?> sr = i.next();
                if (serviceFilter.match(sr)) continue;
                i.remove();
            }
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterReturning$org_eclipse_virgo_medic_log_EntryExitTrace$5$4844ef3f(ajc$tjp_4);
            return;
        }
        catch (Throwable throwable) {
            RegionServiceFindHook.ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance.ajc$afterThrowing$org_eclipse_virgo_medic_log_EntryExitTrace$6$4844ef3f(throwable, ajc$tjp_4);
            throw throwable;
        }
    }

    private Region getRegion(BundleContext context) {
        Bundle b = context.getBundle();
        for (Region r : this.regionDigraph) {
            if (!r.contains(b)) continue;
            return r;
        }
        return null;
    }

    static {
        Factory factory = new Factory("RegionServiceFindHook.java", Class.forName("org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "find", "org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook", "org.osgi.framework.BundleContext:java.lang.String:java.lang.String:boolean:java.util.Collection:", "context:name:filter:allServices:references:", "", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowImportedBundles", "org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:java.util.Set:", "allowed:r:references:path:", "", "void"), 77);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "allowServiceReferencesInRegion", "org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.Region:java.util.Collection:", "allowed:r:references:", "", "void"), 85);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "extendPath", "org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook", "org.eclipse.virgo.kernel.osgi.region.Region:java.util.Set:", "r:path:", "", "java.util.Set"), 93);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "filter", "org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook", "java.util.Set:org.eclipse.virgo.kernel.osgi.region.RegionFilter:", "references:filter:", "", "void"), 99);
        ajc$org_eclipse_virgo_medic_log_EntryExitTrace$ptwAspectInstance = EntryExitTrace.ajc$createAspectInstance((String)"org.eclipse.virgo.kernel.osgi.region.hook.RegionServiceFindHook");
    }
}

