/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.declarations;

import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.ast.ASTVisitor;
import org.eclipse.dltk.mod.ast.DLTKToken;
import org.eclipse.dltk.mod.ast.declarations.Declaration;
import org.eclipse.dltk.mod.ast.references.SimpleReference;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class Argument
extends Declaration {
    protected ASTNode initialization;

    public Argument(DLTKToken name, int start, int end, ASTNode init) {
        super(name, start, end);
        this.initialization = init;
    }

    public Argument(SimpleReference name, int start, ASTNode init, int mods) {
        super(start, 0);
        if (name != null) {
            this.setName(name.getName());
            this.setEnd(start + name.getName().length());
        }
        this.modifiers = mods;
        this.initialization = init;
        if (init != null) {
            this.setEnd(init.sourceEnd());
        }
    }

    public Argument(SimpleReference name, int start, int end, ASTNode init, int mods) {
        super(start, 0);
        if (name != null) {
            this.setName(name.getName());
            this.setEnd(start + name.getName().length());
        }
        this.modifiers = mods;
        this.initialization = init;
        if (init != null) {
            this.setEnd(init.sourceEnd());
        }
    }

    public Argument() {
        this.setStart(0);
        this.setEnd(-1);
    }

    @Override
    public int getKind() {
        return 3000;
    }

    public final void set(SimpleReference mn, ASTNode initialization) {
        this.initialization = initialization;
        this.ref = mn;
        this.setStart(mn.sourceStart());
        this.setEnd(mn.sourceEnd());
    }

    public final ASTNode getInitialization() {
        return this.initialization;
    }

    public final void setInitializationExpression(ASTNode initialization) {
        this.initialization = initialization;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            if (this.initialization != null) {
                this.initialization.traverse(visitor);
            }
            visitor.endvisit(this);
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        if (this.initialization != null) {
            sb.append('=');
            sb.append(this.initialization);
        }
        return sb.toString();
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrint("Argument" + this.getSourceRange().toString() + ":");
        output.formatPrintLn(super.toString());
    }

    public void setArgumentName(String name) {
        this.setName(name);
    }
}

