/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast.expressions;

import org.eclipse.dltk.mod.ast.DLTKToken;
import org.eclipse.dltk.mod.ast.expressions.ExpressionConstants;
import org.eclipse.dltk.mod.ast.statements.Statement;
import org.eclipse.dltk.mod.utils.CorePrinter;

public abstract class Expression
extends Statement
implements ExpressionConstants {
    protected Expression(int start, int end) {
        super(start, end);
    }

    protected Expression() {
    }

    public Expression(DLTKToken token) {
        super(token);
    }

    public String getOperator() {
        switch (this.getKind()) {
            case 1007: {
                return " and ";
            }
            case 1006: {
                return " or ";
            }
            case 1011: {
                return " xor ";
            }
            case 1003: {
                return "/";
            }
            case 1013: {
                return "==";
            }
            case 1014: {
                return "<";
            }
            case 1015: {
                return "<=";
            }
            case 1016: {
                return ">";
            }
            case 1017: {
                return ">=";
            }
            case 1019: {
                return "%";
            }
            case 1018: {
                return ".";
            }
            case 1005: {
                return " xor ";
            }
            case 1008: {
                return "&&";
            }
            case 1004: {
                return "||";
            }
            case 1009: {
                return "<<";
            }
            case 1001: {
                return "-";
            }
            case 1000: {
                return "+";
            }
            case 1002: {
                return "*";
            }
            case 1010: {
                return ">>";
            }
            case 1020: {
                return ".=";
            }
            case 1022: {
                return "===";
            }
            case 1024: {
                return "!===";
            }
            case 1026: {
                return "!";
            }
            case 1027: {
                return "~";
            }
            case 1028: {
                return "~=";
            }
            case 1029: {
                return "!=";
            }
            case 1030: {
                return "<>";
            }
            case 1031: {
                return "/=";
            }
            case 1032: {
                return "+=";
            }
            case 1033: {
                return "++";
            }
            case 1034: {
                return "-=";
            }
            case 1035: {
                return "--";
            }
            case 1036: {
                return "%=";
            }
            case 1037: {
                return "*=";
            }
            case 1038: {
                return ">>=";
            }
            case 1039: {
                return "<<=";
            }
            case 1040: {
                return "^=";
            }
            case 1041: {
                return "&=";
            }
            case 1042: {
                return "=>";
            }
            case 1043: {
                return "->";
            }
            case 1074: {
                return "@";
            }
            case 1045: {
                return "$";
            }
            case 1046: {
                return ",";
            }
            case 1047: {
                return "|=";
            }
            case 1048: {
                return ".=";
            }
            case 1075: {
                return "~";
            }
            case 1076: {
                return "**=";
            }
            case 1077: {
                return "//=";
            }
            case 1078: {
                return "**";
            }
        }
        return "*";
    }

    @Override
    public void printNode(CorePrinter output) {
        output.formatPrintLn("Expression" + this.getSourceRange() + ":" + this.getKind());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Statement) {
            Statement s = (Statement)obj;
            return this.sourceStart() == s.sourceStart() && this.sourceEnd() == s.sourceEnd() && this.getKind() == s.getKind();
        }
        return false;
    }
}

