/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.internal.codeassist.InternalCompletionProposal;

public final class CompletionProposal
extends InternalCompletionProposal {
    public static final int FIELD_REF = 1;
    public static final int KEYWORD = 2;
    public static final int LABEL_REF = 3;
    public static final int LOCAL_VARIABLE_REF = 4;
    public static final int METHOD_REF = 5;
    public static final int METHOD_DECLARATION = 6;
    public static final int TYPE_REF = 7;
    public static final int VARIABLE_DECLARATION = 8;
    public static final int POTENTIAL_METHOD_DECLARATION = 9;
    public static final int METHOD_NAME_REFERENCE = 10;
    public static final int PACKAGE_REF = 11;
    public static final int USER = 15;
    protected static final int FIRST_KIND = 1;
    protected static final int LAST_KIND = 22;
    private boolean updateCompletion = false;
    private int completionKind;
    private int completionLocation;
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private char[] completion = CharOperation.NO_CHAR;
    public Object extraInfo;
    private int replaceStart = 0;
    private int replaceEnd = 0;
    private int relevance = 1;
    private char[] declarationKey = null;
    private char[] name = null;
    private char[] key = null;
    private int flags = 0;
    private char[][] parameterNames = null;
    private IModelElement modelElement;

    public static CompletionProposal create(int kind, int completionOffset) {
        return new CompletionProposal(kind, completionOffset);
    }

    protected CompletionProposal(int kind, int completionLocation) {
        if (kind < 1 || kind > 22) {
            throw new IllegalArgumentException();
        }
        if (this.completion == null || completionLocation < 0) {
            if (this.completion == null || completionLocation != -1) {
                throw new IllegalArgumentException();
            }
            completionLocation = 0;
        }
        this.completionKind = kind;
        this.completionLocation = completionLocation;
    }

    public int getKind() {
        return this.completionKind;
    }

    public int getCompletionLocation() {
        return this.completionLocation;
    }

    public int getTokenStart() {
        return this.tokenStart;
    }

    public int getTokenEnd() {
        return this.tokenEnd;
    }

    public void setTokenRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.tokenStart = startIndex;
        this.tokenEnd = endIndex;
    }

    public char[] getCompletion() {
        if (this.completionKind == 6) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length);
                    int start = 0;
                    int end = CharOperation.indexOf('%', this.completion);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = CharOperation.indexOf('%', this.completion, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length - start);
                        }
                        ++i;
                    }
                    int nameLength = completionBuffer.length();
                    this.completion = new char[nameLength];
                    completionBuffer.getChars(0, nameLength, this.completion, 0);
                }
            }
        } else if (this.completionKind == 5) {
            this.findParameterNames(null);
            if (this.updateCompletion) {
                this.updateCompletion = false;
                if (this.parameterNames != null) {
                    int length = this.parameterNames.length;
                    StringBuffer completionBuffer = new StringBuffer(this.completion.length);
                    int start = 0;
                    int end = CharOperation.indexOf('%', this.completion);
                    completionBuffer.append(this.completion, start, end - start);
                    int i = 0;
                    while (i < length) {
                        completionBuffer.append(this.parameterNames[i]);
                        start = end + 1;
                        end = CharOperation.indexOf('%', this.completion, start);
                        if (end > -1) {
                            completionBuffer.append(this.completion, start, end - start);
                        } else {
                            completionBuffer.append(this.completion, start, this.completion.length - start);
                        }
                        ++i;
                    }
                    int nameLength = completionBuffer.length();
                    this.completion = new char[nameLength];
                    completionBuffer.getChars(0, nameLength, this.completion, 0);
                }
            }
        }
        return this.completion;
    }

    public void setCompletion(char[] completion) {
        this.completion = (char[])completion.clone();
    }

    public int getReplaceStart() {
        return this.replaceStart;
    }

    public int getReplaceEnd() {
        return this.replaceEnd;
    }

    public void setReplaceRange(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IllegalArgumentException();
        }
        this.replaceStart = startIndex;
        this.replaceEnd = endIndex;
    }

    public int getRelevance() {
        return this.relevance;
    }

    public void setRelevance(int rating) {
        if (rating <= 0) {
            throw new IllegalArgumentException();
        }
        this.relevance = rating;
    }

    public char[] getDeclarationKey() {
        return (char[])this.declarationKey.clone();
    }

    public void setDeclarationKey(char[] key) {
        this.declarationKey = (char[])key.clone();
    }

    public char[] getName() {
        return (char[])this.name.clone();
    }

    public void setName(char[] name) {
        this.name = (char[])name.clone();
    }

    public char[] getKey() {
        return (char[])this.key.clone();
    }

    public void setKey(char[] key) {
        this.key = (char[])key.clone();
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public char[][] findParameterNames(IProgressMonitor monitor) {
        return this.parameterNames;
    }

    public void setParameterNames(char[][] parameterNames) {
        this.parameterNames = (char[][])parameterNames.clone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        switch (this.completionKind) {
            case 1: {
                buffer.append("FIELD_REF");
                break;
            }
            case 2: {
                buffer.append("KEYWORD");
                break;
            }
            case 3: {
                buffer.append("LABEL_REF");
                break;
            }
            case 4: {
                buffer.append("LOCAL_VARIABLE_REF");
                break;
            }
            case 6: {
                buffer.append("METHOD_DECLARATION");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 5: {
                buffer.append("METHOD_REF");
                if (!this.isConstructor()) break;
                buffer.append("<CONSTRUCTOR>");
                break;
            }
            case 7: {
                buffer.append("TYPE_REF");
                break;
            }
            case 8: {
                buffer.append("VARIABLE_DECLARATION");
                break;
            }
            case 9: {
                buffer.append("POTENTIAL_METHOD_DECLARATION");
                break;
            }
            case 10: {
                buffer.append("METHOD_IMPORT");
                break;
            }
            default: {
                buffer.append("PROPOSAL");
            }
        }
        buffer.append("]{completion:");
        if (this.completion != null) {
            buffer.append(this.completion);
        }
        buffer.append(", declSign:");
        buffer.append(", declKey:");
        if (this.declarationKey != null) {
            buffer.append(this.declarationKey);
        }
        buffer.append(", key:");
        if (this.key != null) {
            buffer.append(this.key);
        }
        buffer.append(", name:");
        if (this.name != null) {
            buffer.append(this.name);
        }
        buffer.append(", [");
        buffer.append(this.replaceStart);
        buffer.append(',');
        buffer.append(this.replaceEnd);
        buffer.append("], relevance=");
        buffer.append(this.relevance);
        buffer.append('}');
        return buffer.toString();
    }

    public IModelElement getModelElement() {
        return this.modelElement;
    }

    public void setModelElement(IModelElement modelElement) {
        this.modelElement = modelElement;
    }
}

