/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.BuiltinScriptFolderInfo;
import org.eclipse.dltk.mod.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelElementInfo;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.util.MementoTokenizer;

public class BuiltinScriptFolder
extends ScriptFolder {
    public BuiltinScriptFolder(ProjectFragment parent, IPath path) {
        super(parent, path);
    }

    void computeForeignResources(BuiltinScriptFolderInfo info) {
        info.setForeignResources(ModelElementInfo.NO_NON_SCRIPT_RESOURCES);
    }

    @Override
    public ISourceModule getSourceModule(String name) {
        return new BuiltinSourceModule(this, name, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
    }

    protected boolean computeChildren(OpenableElementInfo info, String[] entryNames) {
        if (entryNames != null && entryNames.length > 0) {
            ArrayList<ISourceModule> vChildren = new ArrayList<ISourceModule>();
            int iter = 0;
            while (iter < entryNames.length) {
                String child = entryNames[iter];
                ISourceModule classFile = this.getSourceModule(child);
                vChildren.add(classFile);
                ++iter;
            }
            IModelElement[] children = new IModelElement[vChildren.size()];
            vChildren.toArray(children);
            info.setChildren(children);
        } else {
            info.setChildren(NO_ELEMENTS);
        }
        return true;
    }

    @Override
    public ISourceModule[] getSourceModules() throws ModelException {
        ArrayList list = this.getChildrenOfType(5);
        ISourceModule[] array = new ISourceModule[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
        Openable openableParent = (Openable)this.parent;
        if (!openableParent.isOpen()) {
            openableParent.generateInfos(openableParent.createElementInfo(), newElements, pm);
        }
    }

    @Override
    public IModelElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '{': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String classFileName = memento.nextToken();
                ModelElement classFile = (ModelElement)((Object)this.getSourceModule(classFileName));
                return classFile.getHandleFromMemento(memento, owner);
            }
        }
        return null;
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    protected boolean resourceExists() {
        return this.path.toPortableString().length() == 0;
    }

    @Override
    public Object[] getForeignResources() throws ModelException {
        return ((BuiltinScriptFolderInfo)this.getElementInfo()).getForeignResources();
    }
}

