/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.BuildpathChange;
import org.eclipse.dltk.mod.internal.core.BuildpathValidation;
import org.eclipse.dltk.mod.internal.core.DeltaProcessingState;
import org.eclipse.dltk.mod.internal.core.ExternalFolderChange;
import org.eclipse.dltk.mod.internal.core.ModelElementDelta;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ProjectReferenceChange;
import org.eclipse.dltk.mod.internal.core.ScriptProject;

public abstract class ChangeBuildpathOperation
extends ModelOperation {
    protected boolean canChangeResources;

    public ChangeBuildpathOperation(IModelElement[] elements, boolean canChangeResources) {
        super(elements);
        this.canChangeResources = canChangeResources;
    }

    @Override
    protected boolean canModifyRoots() {
        return true;
    }

    protected void buildpathChanged(BuildpathChange change) throws ModelException {
        ScriptProject project = change.project;
        project.resetCaches();
        if (this.canChangeResources) {
            if (this.isTopLevelOperation() && !ResourcesPlugin.getWorkspace().isTreeLocked()) {
                new BuildpathValidation(project).validate();
            }
            new ProjectReferenceChange(project, change.oldResolvedBuildpath).updateProjectReferencesIfNecessary();
            new ExternalFolderChange(project, change.oldResolvedBuildpath).updateExternalFoldersIfNecessary(true, null);
        } else {
            DeltaProcessingState state = ModelManager.getModelManager().deltaState;
            ModelElementDelta delta = new ModelElementDelta(this.getModel());
            int result = change.generateDelta(delta);
            if ((result & BuildpathChange.HAS_DELTA) != 0) {
                this.addDelta(delta);
                state.rootsAreStale = true;
                change.requestIndexing();
                state.addBuildpathValidation(project);
            }
            if ((result & BuildpathChange.HAS_PROJECT_CHANGE) != 0) {
                state.addProjectReferenceChange(project, change.oldResolvedBuildpath);
            }
            if ((result & BuildpathChange.HAS_LIBRARY_CHANGE) != 0) {
                state.addExternalFolderChange(project, change.oldResolvedBuildpath);
            }
        }
    }

    @Override
    protected ISchedulingRule getSchedulingRule() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return !this.canChangeResources;
    }
}

