/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.builder;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.builder.IBuildContext;
import org.eclipse.dltk.mod.core.builder.IBuildParticipant;
import org.eclipse.dltk.mod.core.builder.IBuildParticipantExtension;
import org.eclipse.dltk.mod.core.builder.IBuildParticipantExtension2;
import org.eclipse.dltk.mod.core.builder.IScriptBuilder;
import org.eclipse.dltk.mod.core.builder.IScriptBuilderExtension;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.builder.BuildParticipantManager;
import org.eclipse.dltk.mod.internal.core.builder.BuildProblemReporter;
import org.eclipse.dltk.mod.internal.core.builder.BuildUtils;
import org.eclipse.dltk.mod.internal.core.builder.ExternalModuleBuildContext;
import org.eclipse.dltk.mod.internal.core.builder.Messages;
import org.eclipse.dltk.mod.internal.core.builder.SourceModuleBuildContext;
import org.eclipse.dltk.mod.internal.core.builder.SubTaskProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class StandardScriptBuilder
implements IScriptBuilder,
IScriptBuilderExtension {
    private static final boolean DEBUG = false;
    private static final int WORK_BUILD = 100;
    private boolean beginBuildDone = false;
    private boolean endBuildNeeded = false;
    private IBuildParticipant[] participants = null;
    private IDLTKLanguageToolkit toolkit = null;

    @Override
    public IStatus buildModelElements(IScriptProject project, List elements, IProgressMonitor monitor, int buildType) {
        monitor.beginTask("", 100);
        try {
            this.buildModules(project, elements, buildType, BuildUtils.subMonitorFor(monitor, 100));
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void buildExternalElements(ScriptProject project, List externalElements, IProgressMonitor monitor, int buildType) {
        this.beginBuild(buildType, monitor);
        IBuildParticipantExtension2[] extensions = this.selectExtension2();
        if (extensions != null) {
            int remainingWork = externalElements.size();
            Iterator j = externalElements.iterator();
            while (j.hasNext()) {
                if (monitor.isCanceled()) {
                    return;
                }
                ISourceModule module = (ISourceModule)j.next();
                monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildExternalModuleSubTask, (Object)String.valueOf(remainingWork), (Object)module.getElementName()));
                ExternalModuleBuildContext context = new ExternalModuleBuildContext(module);
                try {
                    int i = 0;
                    while (i < extensions.length) {
                        if (monitor.isCanceled()) {
                            return;
                        }
                        extensions[i].buildExternalModule(context);
                        ++i;
                    }
                }
                catch (CoreException e) {
                    DLTKCore.error(NLS.bind((String)"Error building external module {0}", (Object)module.getElementName()), e);
                }
                --remainingWork;
            }
        }
    }

    private IBuildParticipantExtension2[] selectExtension2() {
        if (this.participants != null) {
            int count = 0;
            int i = 0;
            while (i < this.participants.length) {
                IBuildParticipant participant = this.participants[i];
                if (participant instanceof IBuildParticipantExtension2) {
                    ++count;
                }
                ++i;
            }
            if (count != 0) {
                IBuildParticipantExtension2[] result = new IBuildParticipantExtension2[count];
                count = 0;
                int i2 = 0;
                while (i2 < this.participants.length) {
                    IBuildParticipant participant = this.participants[i2];
                    if (participant instanceof IBuildParticipantExtension2) {
                        result[count++] = (IBuildParticipantExtension2)((Object)participant);
                    }
                    ++i2;
                }
                return result;
            }
        }
        return null;
    }

    private void buildModules(IScriptProject project, List elements, int buildType, IProgressMonitor monitor) {
        long startTime = 0L;
        monitor.beginTask(Messages.ValidatorBuilder_buildingModules, elements.size());
        if (this.toolkit != null) {
            this.buildNatureModules(project, buildType, elements, monitor);
        }
        monitor.done();
    }

    private void buildNatureModules(IScriptProject project, int buildType, List modules, IProgressMonitor monitor) {
        boolean secondPass = this.beginBuild(buildType, monitor);
        ArrayList<BuildProblemReporter> reporters = secondPass ? new ArrayList<BuildProblemReporter>() : null;
        int counter = 0;
        Iterator j = modules.iterator();
        while (j.hasNext()) {
            if (monitor.isCanceled()) {
                return;
            }
            ISourceModule module = (ISourceModule)j.next();
            monitor.subTask(NLS.bind((String)Messages.ValidatorBuilder_buildModuleSubTask, (Object)String.valueOf(modules.size() - counter), (Object)module.getElementName()));
            SourceModuleBuildContext context = new SourceModuleBuildContext(module);
            if (context.reporter != null) {
                this.buildModule(context);
                if (reporters != null) {
                    reporters.add(context.reporter);
                } else {
                    context.reporter.flush();
                }
            }
            monitor.worked(1);
            ++counter;
        }
        if (reporters != null) {
            monitor.subTask(Messages.ValidatorBuilder_finalizeBuild);
            SubTaskProgressMonitor finalizeMonitor = new SubTaskProgressMonitor(monitor, Messages.ValidatorBuilder_finalizeBuild);
            if (this.participants != null) {
                int j2 = 0;
                while (j2 < this.participants.length) {
                    IBuildParticipant participant = this.participants[j2];
                    if (participant instanceof IBuildParticipantExtension) {
                        ((IBuildParticipantExtension)((Object)participant)).endBuild((IProgressMonitor)finalizeMonitor);
                    }
                    ++j2;
                }
            }
            for (BuildProblemReporter reporter : reporters) {
                reporter.flush();
            }
        }
    }

    private boolean beginBuild(int buildType, IProgressMonitor monitor) {
        if (!this.beginBuildDone) {
            monitor.subTask(Messages.ValidatorBuilder_InitializeBuilders);
            this.endBuildNeeded = false;
            int j = 0;
            while (j < this.participants.length) {
                IBuildParticipant participant = this.participants[j];
                if (participant instanceof IBuildParticipantExtension) {
                    ((IBuildParticipantExtension)((Object)participant)).beginBuild(buildType);
                    this.endBuildNeeded = true;
                }
                ++j;
            }
            this.beginBuildDone = true;
        }
        return this.endBuildNeeded;
    }

    private void buildModule(IBuildContext context) {
        int k = 0;
        while (k < this.participants.length) {
            IBuildParticipant participant = this.participants[k];
            try {
                participant.build(context);
            }
            catch (CoreException e) {
                DLTKCore.error("", e);
            }
            ++k;
        }
    }

    @Override
    public IStatus buildResources(IScriptProject project, List resources, IProgressMonitor monitor, int buildType) {
        SubProgressMonitor sub = new SubProgressMonitor(monitor, resources.size() * 2);
        try {
            sub.beginTask("", resources.size());
            try {
                for (IResource resource : resources) {
                    String template = Messages.ValidatorBuilder_clearingResourceMarkers;
                    sub.subTask(NLS.bind((String)template, (Object)resource.getName()));
                    resource.deleteMarkers("org.eclipse.dltk.mod.core.problem", true, 2);
                    resource.deleteMarkers("org.eclipse.dltk.mod.core.task", true, 2);
                    sub.worked(1);
                }
            }
            catch (CoreException e) {
                String msg = Messages.ValidatorBuilder_errorDeleteResourceMarkers;
                DLTKCore.error(msg, e);
            }
        }
        finally {
            sub.done();
        }
        return Status.OK_STATUS;
    }

    @Override
    public void clean(IScriptProject project, IProgressMonitor monitor) {
    }

    @Override
    public IScriptBuilder.DependencyResponse getDependencies(IScriptProject project, int buildType, Set localElements, Set externalElements, Set oldExternalFolders, Set externalFolders) {
        if (this.participants == null) {
            return null;
        }
        HashSet localDependencies = null;
        HashSet externalDependencies = null;
        boolean fullLocal = false;
        int i = 0;
        while (i < this.participants.length) {
            IScriptBuilder.DependencyResponse response;
            IBuildParticipant participant = this.participants[i];
            if (participant instanceof IBuildParticipantExtension2 && (response = ((IBuildParticipantExtension2)((Object)participant)).getDependencies(buildType, localElements, externalElements, oldExternalFolders, externalFolders)) != null) {
                if (response.isFullExternalBuild()) {
                    return response;
                }
                if (response.isFullLocalBuild()) {
                    fullLocal = true;
                } else if (!response.getLocalDependencies().isEmpty()) {
                    if (localDependencies == null) {
                        localDependencies = new HashSet();
                    }
                    localDependencies.addAll(response.getLocalDependencies());
                }
                if (!response.getExternalDependencies().isEmpty()) {
                    if (externalDependencies == null) {
                        externalDependencies = new HashSet();
                    }
                    externalDependencies.addAll(response.getExternalDependencies());
                }
            }
            ++i;
        }
        if (externalDependencies == null) {
            if (fullLocal) {
                return IScriptBuilder.DependencyResponse.FULL_LOCAL_BUILD;
            }
            return IScriptBuilder.DependencyResponse.createLocal(localDependencies);
        }
        return IScriptBuilder.DependencyResponse.create(fullLocal, localDependencies, externalDependencies);
    }

    @Override
    public void initialize(IScriptProject project) {
        this.toolkit = project.getLanguageToolkit();
        if (this.toolkit != null) {
            this.participants = BuildParticipantManager.getBuildParticipants(project, this.toolkit.getNatureId());
        }
        this.beginBuildDone = false;
        this.endBuildNeeded = false;
    }

    @Override
    public void reset(IScriptProject project) {
        this.participants = null;
        this.toolkit = null;
        this.beginBuildDone = false;
        this.endBuildNeeded = false;
    }
}

