/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISearchableEnvironment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.mod.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.dltk.mod.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws ModelException {
        this.setRequestor(hierarchy);
    }

    @Override
    public void build(boolean computeSubtypes) {
        ModelManager manager = ModelManager.getModelManager();
        try {
            manager.cacheZipFiles();
            if (this.hierarchy.focusType == null || computeSubtypes) {
                SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
                HashMap allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)typeInRegionMonitor);
                this.hierarchy.initialize(allOpenablesInRegion.size());
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
                this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)buildMonitor);
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles();
        }
    }

    private void createTypeHierarchyBasedOnRegion(HashMap allOpenablesInRegion, IProgressMonitor monitor) {
        int size = allOpenablesInRegion.size();
        if (size == 0) {
            if (monitor != null) {
                monitor.done();
            }
            return;
        }
        this.infoToHandle = new HashMap(size);
        for (Map.Entry entry : allOpenablesInRegion.entrySet()) {
            ScriptProject project = (ScriptProject)entry.getKey();
            ArrayList allOpenables = (ArrayList)entry.getValue();
            Openable[] openables = new Openable[allOpenables.size()];
            allOpenables.toArray(openables);
            try {
                try {
                    if (monitor != null) {
                        monitor.beginTask("", size * 2);
                    }
                    ISearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.hierarchy.workingCopies);
                    this.nameLookup = searchableEnvironment.getNameLookup();
                }
                catch (ModelException modelException) {
                    if (monitor == null) continue;
                    monitor.done();
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            if (monitor == null) continue;
            monitor.done();
        }
    }

    private HashMap determineOpenablesInRegion(IProgressMonitor monitor) {
        try {
            HashMap allOpenables = new HashMap();
            IModelElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            int i = 0;
            while (i < length) {
                IModelElement root = roots[i];
                IScriptProject javaProject = root.getScriptProject();
                ArrayList<IModelElement> openables = (ArrayList<IModelElement>)allOpenables.get(javaProject);
                if (openables == null) {
                    openables = new ArrayList<IModelElement>();
                    allOpenables.put(javaProject, openables);
                }
                switch (root.getElementType()) {
                    case 2: {
                        this.injectAllOpenablesForJavaProject((IScriptProject)root, openables);
                        break;
                    }
                    case 3: {
                        this.injectAllOpenablesForPackageFragmentRoot((IProjectFragment)root, openables);
                        break;
                    }
                    case 4: {
                        this.injectAllOpenablesForPackageFragment((IScriptFolder)root, openables);
                        break;
                    }
                    case 5: {
                        openables.add(root);
                        break;
                    }
                    case 7: {
                        IType type = (IType)root;
                        openables.add(type.getSourceModule());
                        break;
                    }
                }
                this.worked(monitor, 1);
                ++i;
            }
            HashMap hashMap = allOpenables;
            return hashMap;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void injectAllOpenablesForJavaProject(IScriptProject project, ArrayList openables) {
        try {
            IProjectFragment[] devPathRoots = ((ScriptProject)project).getProjectFragments();
            if (devPathRoots == null) {
                return;
            }
            int i = 0;
            while (i < devPathRoots.length) {
                IProjectFragment root = devPathRoots[i];
                this.injectAllOpenablesForPackageFragmentRoot(root, openables);
                ++i;
            }
        }
        catch (ModelException modelException) {}
    }

    private void injectAllOpenablesForPackageFragment(IScriptFolder packFrag, ArrayList openables) {
        try {
            IProjectFragment root = (IProjectFragment)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    ISourceModule[] cus = packFrag.getSourceModules();
                    int i = 0;
                    while (i < cus.length) {
                        openables.add(cus[i]);
                        ++i;
                    }
                }
            }
        }
        catch (ModelException modelException) {}
    }

    private void injectAllOpenablesForPackageFragmentRoot(IProjectFragment root, ArrayList openables) {
        try {
            IModelElement[] packFrags = root.getChildren();
            int i = 0;
            while (i < packFrags.length) {
                IScriptFolder packFrag = (IScriptFolder)packFrags[i];
                this.injectAllOpenablesForPackageFragment(packFrag, openables);
                ++i;
            }
        }
        catch (ModelException modelException) {
            return;
        }
    }
}

