/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.environment.IEnvironment;
import org.eclipse.dltk.mod.core.search.index.Index;
import org.eclipse.dltk.mod.internal.core.mixin.MixinExternalProjectFragmentRequest;

class MixinBuiltinProjectFragmentRequest
extends MixinExternalProjectFragmentRequest {
    private final long lastModified;

    public MixinBuiltinProjectFragmentRequest(IProjectFragment fragment, IDLTKLanguageToolkit toolkit, long lastModified) {
        super(fragment, toolkit);
        this.lastModified = lastModified;
    }

    @Override
    protected List checkChanges(Index index, Collection modules, IPath containerPath, IEnvironment environment) throws ModelException, IOException {
        long indexLastModified = index.getIndexFile().lastModified();
        if (this.lastModified > indexLastModified) {
            ArrayList<String> changes = new ArrayList<String>();
            String[] documentNames = this.queryDocumentNames(index);
            if (documentNames != null) {
                int i = 0;
                while (i < documentNames.length) {
                    changes.add(documentNames[i]);
                    ++i;
                }
            }
            changes.addAll(modules);
            return changes;
        }
        return super.checkChanges(index, modules, containerPath, environment);
    }

    @Override
    protected IEnvironment getEnvironment() {
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof MixinBuiltinProjectFragmentRequest && super.equals(obj);
    }
}

