/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.search.processing;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.mod.internal.core.search.processing.IJob;
import org.eclipse.dltk.mod.internal.core.util.Messages;
import org.eclipse.dltk.mod.internal.core.util.Util;

public abstract class JobManager
implements Runnable {
    protected IJob[] awaitingJobs = new IJob[10];
    protected int jobStart = 0;
    protected int jobEnd = -1;
    protected boolean executing = false;
    protected Thread processingThread;
    protected Job progressJob;
    private int enableCount = 1;
    public static final boolean VERBOSE = false;
    public boolean activated = false;
    private int awaitingClients = 0;

    public void activateProcessing() {
        this.activated = true;
    }

    public synchronized int awaitingJobsCount() {
        return this.activated ? this.jobEnd - this.jobStart + 1 : 1;
    }

    public synchronized IJob currentJob() {
        if (this.enableCount > 0 && this.jobStart <= this.jobEnd) {
            return this.awaitingJobs[this.jobStart];
        }
        return null;
    }

    public void disable() {
        --this.enableCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discardJobs(String jobFamily) {
        try {
            IJob currentJob;
            JobManager jobManager = this;
            synchronized (jobManager) {
                currentJob = this.currentJob();
                this.disable();
            }
            if (currentJob != null && (jobFamily == null || currentJob.belongsTo(jobFamily))) {
                currentJob.cancel();
                while (this.processingThread != null && this.executing) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            int loc = -1;
            JobManager jobManager2 = this;
            synchronized (jobManager2) {
                int i = this.jobStart;
                while (i <= this.jobEnd) {
                    currentJob = this.awaitingJobs[i];
                    if (currentJob != null) {
                        this.awaitingJobs[i] = null;
                        if (jobFamily != null && !currentJob.belongsTo(jobFamily)) {
                            this.awaitingJobs[++loc] = currentJob;
                        } else {
                            currentJob.cancel();
                        }
                    }
                    ++i;
                }
                this.jobStart = 0;
                this.jobEnd = loc;
            }
        }
        finally {
            this.enable();
        }
    }

    public synchronized void enable() {
        ++this.enableCount;
        this.notifyAll();
    }

    public synchronized boolean isJobWaiting(IJob request) {
        int i = this.jobEnd;
        while (i > this.jobStart) {
            if (request.equals(this.awaitingJobs[i])) {
                return true;
            }
            --i;
        }
        return false;
    }

    protected synchronized void moveToNextJob() {
        if (this.jobStart <= this.jobEnd) {
            this.awaitingJobs[this.jobStart++] = null;
            if (this.jobStart > this.jobEnd) {
                this.jobStart = 0;
                this.jobEnd = -1;
            }
        }
    }

    protected void notifyIdle(long idlingTime) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean performConcurrentJob(IJob searchJob, int waitingPolicy, IProgressMonitor progress) {
        block31: {
            searchJob.ensureReadyToRun();
            concurrentJobWork = 100;
            if (progress != null) {
                progress.beginTask("", concurrentJobWork);
            }
            status = false;
            if (this.awaitingJobsCount() <= 0) break block31;
            switch (waitingPolicy) {
                case 1: {
                    try {
                        this.disable();
                        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
                    }
                    finally {
                        this.enable();
                    }
                    return status;
                }
                case 2: {
                    throw new OperationCanceledException();
                }
                case 3: {
                    previousJob = null;
                    subProgress = null;
                    totalWork = this.awaitingJobsCount();
                    if (progress != null && totalWork > 0) {
                        subProgress = new SubProgressMonitor(progress, concurrentJobWork / 2);
                        subProgress.beginTask("", totalWork);
                        concurrentJobWork /= 2;
                    }
                    originalPriority = (t = this.processingThread) == null ? -1 : t.getPriority();
                    try {
                        if (t != null) {
                            t.setPriority(Thread.currentThread().getPriority());
                        }
                        var13_13 = this;
                        synchronized (var13_13) {
                            ++this.awaitingClients;
                            // MONITOREXIT @DISABLED, blocks:[1, 2, 6, 9, 12] lbl35 : MonitorExitStatement: MONITOREXIT : var13_13
                            if (true) ** GOTO lbl52
                        }
                        do {
                            if (subProgress != null && subProgress.isCanceled()) {
                                throw new OperationCanceledException();
                            }
                            currentJob = this.currentJob();
                            if (currentJob != null && currentJob != previousJob) {
                                if (subProgress != null) {
                                    subProgress.subTask(Messages.bind(Messages.manager_filesToIndex, Integer.toString(awaitingWork)));
                                    subProgress.worked(1);
                                }
                                previousJob = currentJob;
                            }
                            try {
                                Thread.sleep(searchJob instanceof WaitJob != false ? 250 : 50);
                            }
                            catch (InterruptedException v1) {}
lbl52:
                            // 3 sources

                        } while ((awaitingWork = this.awaitingJobsCount()) > 0);
                    }
                    catch (Throwable var14_15) {
                        var15_16 = this;
                        synchronized (var15_16) {
                            --this.awaitingClients;
                        }
                        if (t != null && originalPriority > -1 && t.isAlive()) {
                            t.setPriority(originalPriority);
                        }
                        throw var14_15;
                    }
                    var15_17 = this;
                    synchronized (var15_17) {
                        --this.awaitingClients;
                    }
                    if (t != null && originalPriority > -1 && t.isAlive()) {
                        t.setPriority(originalPriority);
                    }
                    if (subProgress == null) break;
                    subProgress.done();
                }
            }
        }
        status = searchJob.execute((IProgressMonitor)(progress == null ? null : new SubProgressMonitor(progress, concurrentJobWork)));
        if (progress != null) {
            progress.done();
        }
        return status;
    }

    public abstract String processName();

    public void waitUntilReady() {
        this.performConcurrentJob(new WaitJob(), 3, null);
    }

    public synchronized void request(IJob job) {
        job.ensureReadyToRun();
        int size = this.awaitingJobs.length;
        if (++this.jobEnd == size) {
            this.jobEnd -= this.jobStart;
            this.awaitingJobs = new IJob[size * 2];
            System.arraycopy(this.awaitingJobs, this.jobStart, this.awaitingJobs, 0, this.jobEnd);
            this.jobStart = 0;
        }
        this.awaitingJobs[this.jobEnd] = job;
        this.notifyAll();
    }

    public synchronized void reset() {
        if (this.processingThread != null) {
            this.discardJobs(null);
        } else {
            this.processingThread = new Thread((Runnable)this, this.processName());
            this.processingThread.setDaemon(true);
            this.processingThread.setPriority(4);
            this.processingThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long idlingStart = -1L;
        this.activateProcessing();
        try {
            this.progressJob = null;
            while (this.processingThread != null) {
                try {
                    IJob job;
                    JobManager jobManager = this;
                    synchronized (jobManager) {
                        if (this.processingThread == null) {
                            continue;
                        }
                        job = this.currentJob();
                        if (job == null) {
                            if (this.progressJob != null) {
                                this.progressJob.cancel();
                                this.progressJob = null;
                            }
                            if (idlingStart < 0L) {
                                idlingStart = System.currentTimeMillis();
                            } else {
                                this.notifyIdle(System.currentTimeMillis() - idlingStart);
                            }
                            this.wait();
                        } else {
                            idlingStart = -1L;
                        }
                    }
                    if (job == null) {
                        this.notifyIdle(System.currentTimeMillis() - idlingStart);
                        Thread.sleep(500L);
                        continue;
                    }
                    try {
                        this.executing = true;
                        if (this.progressJob == null) {
                            class ProgressJob
                            extends Job {
                                ProgressJob(String name) {
                                    super(name);
                                }

                                protected IStatus run(IProgressMonitor monitor) {
                                    int awaitingJobsCount;
                                    monitor.beginTask(Messages.manager_indexingTask, -1);
                                    while (!monitor.isCanceled() && (awaitingJobsCount = JobManager.this.awaitingJobsCount()) > 0) {
                                        monitor.subTask(Messages.bind(Messages.manager_filesToIndex, Integer.toString(awaitingJobsCount)));
                                        try {
                                            Thread.sleep(500L);
                                        }
                                        catch (InterruptedException interruptedException) {}
                                    }
                                    monitor.done();
                                    return Status.OK_STATUS;
                                }
                            }
                            this.progressJob = new ProgressJob(Messages.manager_indexingInProgress);
                            this.progressJob.setPriority(30);
                            this.progressJob.setSystem(true);
                            this.progressJob.schedule();
                        }
                        job.execute(null);
                    }
                    finally {
                        this.executing = false;
                        this.moveToNextJob();
                        if (this.awaitingClients == 0) {
                            Thread.sleep(50L);
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (RuntimeException e) {
            if (this.processingThread != null) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
        catch (Error e) {
            if (this.processingThread != null && !(e instanceof ThreadDeath)) {
                Util.log(e, "Background Indexer Crash Recovery");
                this.discardJobs(null);
                this.processingThread = null;
                this.reset();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.disable();
        this.discardJobs(null);
        Thread thread = this.processingThread;
        try {
            Job job;
            if (thread != null) {
                JobManager jobManager = this;
                synchronized (jobManager) {
                    this.processingThread = null;
                    this.notifyAll();
                }
                thread.join();
            }
            if ((job = this.progressJob) != null) {
                job.cancel();
                job.join();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append("Enable count:").append(this.enableCount).append('\n');
        int numJobs = this.jobEnd - this.jobStart + 1;
        buffer.append("Jobs in queue:").append(numJobs).append('\n');
        int i = 0;
        while (i < numJobs && i < 15) {
            buffer.append(i).append(" - job[" + i + "]: ").append(this.awaitingJobs[this.jobStart + i]).append('\n');
            ++i;
        }
        return buffer.toString();
    }

    private static final class WaitJob
    implements IJob {
        private WaitJob() {
        }

        @Override
        public boolean belongsTo(String jobFamily) {
            return false;
        }

        @Override
        public void cancel() {
        }

        @Override
        public void ensureReadyToRun() {
        }

        @Override
        public boolean execute(IProgressMonitor progress) {
            return false;
        }

        public String toString() {
            return "WAIT-UNTIL-READY-JOB";
        }
    }
}

