/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ti;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.ti.GoalEngine;
import org.eclipse.dltk.mod.ti.GoalState;
import org.eclipse.dltk.mod.ti.IGoalEvaluatorFactory;
import org.eclipse.dltk.mod.ti.IPruner;
import org.eclipse.dltk.mod.ti.ITypeInferencer;
import org.eclipse.dltk.mod.ti.TimelimitPruner;
import org.eclipse.dltk.mod.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.mod.ti.goals.FieldReferencesGoal;
import org.eclipse.dltk.mod.ti.goals.FieldReferencesGoalEvaluator;
import org.eclipse.dltk.mod.ti.goals.GoalEvaluator;
import org.eclipse.dltk.mod.ti.goals.IGoal;
import org.eclipse.dltk.mod.ti.goals.MethodCallsGoal;
import org.eclipse.dltk.mod.ti.goals.MethodCallsGoalEvaluator;
import org.eclipse.dltk.mod.ti.goals.NullGoalEvaluator;
import org.eclipse.dltk.mod.ti.statistics.IEvaluationStatisticsRequestor;
import org.eclipse.dltk.mod.ti.types.IEvaluatedType;

public class DefaultTypeInferencer
implements ITypeInferencer {
    private Map evaluators = new HashMap();
    private static Set statRequestors = new HashSet();
    private final GoalEngine engine;
    private final IGoalEvaluatorFactory userFactory;
    private final ProxyStatisticsRequestor stat = new ProxyStatisticsRequestor();

    private void initStdGoals() {
        this.registerEvaluator(FieldReferencesGoal.class, FieldReferencesGoalEvaluator.class);
        this.registerEvaluator(MethodCallsGoal.class, MethodCallsGoalEvaluator.class);
    }

    public DefaultTypeInferencer(IGoalEvaluatorFactory userFactory) {
        this.engine = new GoalEngine(new MapBasedEvaluatorFactory());
        this.userFactory = userFactory;
        this.initStdGoals();
    }

    public void registerEvaluator(Class goalClass, Class evaluatorClass) {
        Assert.isLegal((boolean)IGoal.class.isAssignableFrom(goalClass));
        Assert.isLegal((boolean)GoalEvaluator.class.isAssignableFrom(evaluatorClass));
        this.evaluators.put(goalClass, evaluatorClass);
    }

    @Override
    public IEvaluatedType evaluateType(AbstractTypeGoal goal, int timeLimit) {
        IEvaluatedType result = this.evaluateType(goal, new TimelimitPruner(timeLimit));
        return result;
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal, IPruner pruner) {
        return (IEvaluatedType)this.engine.evaluateGoal(goal, pruner, this.stat);
    }

    protected Object evaluateGoal(IGoal goal, IPruner pruner) {
        return this.engine.evaluateGoal(goal, pruner, this.stat);
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal) {
        return this.evaluateType(goal, null);
    }

    public static void addEvaluationStatisticsRequestor(IEvaluationStatisticsRequestor r) {
        statRequestors.add(r);
    }

    public static void removeEvaluationStatisticsRequestor(IEvaluationStatisticsRequestor r) {
        statRequestors.remove(r);
    }

    private class MapBasedEvaluatorFactory
    implements IGoalEvaluatorFactory {
        private MapBasedEvaluatorFactory() {
        }

        @Override
        public GoalEvaluator createEvaluator(IGoal goal) {
            GoalEvaluator evaluator = null;
            if (DefaultTypeInferencer.this.userFactory != null && (evaluator = DefaultTypeInferencer.this.userFactory.createEvaluator(goal)) != null) {
                return evaluator;
            }
            Class<?> goalClass = goal.getClass();
            evaluator = DefaultTypeInferencer.this.evaluators.get(goalClass);
            if (evaluator == null || !(evaluator instanceof Class)) {
                String className = goalClass.getName();
                if (DLTKCore.DEBUG) {
                    System.err.println("No evaluator registered for " + className.substring(className.lastIndexOf(46)) + ": " + goal + " - using NullGoalEvaluator");
                }
                return new NullGoalEvaluator(goal);
            }
            Class evalClass = (Class)((Object)evaluator);
            try {
                GoalEvaluator newInstance = (GoalEvaluator)evalClass.getConstructor(IGoal.class).newInstance(goal);
                return newInstance;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static class ProxyStatisticsRequestor
    implements IEvaluationStatisticsRequestor {
        private ProxyStatisticsRequestor() {
        }

        @Override
        public void evaluationStarted(IGoal rootGoal) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.evaluationStarted(rootGoal);
            }
        }

        @Override
        public void evaluatorInitialized(GoalEvaluator evaluator, IGoal[] subgoals, long time) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.evaluatorInitialized(evaluator, subgoals, time);
            }
        }

        @Override
        public void evaluatorProducedResult(GoalEvaluator evaluator, Object result, long time) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.evaluatorProducedResult(evaluator, result, time);
            }
        }

        @Override
        public void evaluatorReceivedResult(GoalEvaluator evaluator, IGoal finishedGoal, IGoal[] newSubgoals, long time) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.evaluatorReceivedResult(evaluator, finishedGoal, newSubgoals, time);
            }
        }

        @Override
        public void goalEvaluatorAssigned(IGoal goal, GoalEvaluator evaluator) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.goalEvaluatorAssigned(goal, evaluator);
            }
        }

        @Override
        public void goalStateChanged(IGoal goal, GoalState state, GoalState oldState) {
            for (IEvaluationStatisticsRequestor t : statRequestors) {
                if (t == null) continue;
                t.goalStateChanged(goal, state, oldState);
            }
        }
    }
}

