/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.debug.ui.launchConfigurations;

import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.mod.debug.ui.ScriptDebugImages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ScriptBuildTab
extends AbstractLaunchConfigurationTab {
    private Button buildBeforeLaunch;
    private Group buildOpitionsGroup;
    private Button java2jsBeforeLaunch;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        composite.setLayoutData((Object)new GridData(1808));
        this.setControl((Control)composite);
        this.buildBeforeLaunch = new Button(composite, 32);
        this.buildBeforeLaunch.setText("Build before Launch");
        this.buildBeforeLaunch.setLayoutData((Object)new GridData(768));
        this.buildBeforeLaunch.addSelectionListener((SelectionListener)new SelectionHandler());
        this.buildOpitionsGroup = new Group(composite, 0);
        this.buildOpitionsGroup.setLayout((Layout)new GridLayout(1, true));
        this.buildOpitionsGroup.setLayoutData((Object)new GridData(768));
        this.java2jsBeforeLaunch = new Button((Composite)this.buildOpitionsGroup, 32);
        this.java2jsBeforeLaunch.setText("Java 2 JS");
        this.java2jsBeforeLaunch.setLayoutData((Object)new GridData(768));
        this.java2jsBeforeLaunch.addSelectionListener((SelectionListener)new SelectionHandler());
    }

    private void handleSelection(SelectionEvent e) {
        if (e.getSource() == this.buildBeforeLaunch) {
            boolean isBuildBeforeLaunch = this.buildBeforeLaunch.getSelection();
            if (isBuildBeforeLaunch) {
                this.buildOpitionsGroup.setEnabled(true);
                this.java2jsBeforeLaunch.setEnabled(true);
            } else {
                this.buildOpitionsGroup.setEnabled(false);
                this.java2jsBeforeLaunch.setSelection(false);
                this.java2jsBeforeLaunch.setEnabled(false);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    public String getName() {
        return "Build";
    }

    public Image getImage() {
        return ScriptDebugImages.get("IMG_VIEW_ARGUMENTS_TAB");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            boolean isBuildBeforeLaunch = configuration.getAttribute("buildBeforeLaunch", false);
            boolean isJava2JsBeforeLaunch = configuration.getAttribute("java2jsBeforeLaunch", false);
            if (isBuildBeforeLaunch) {
                this.buildBeforeLaunch.setSelection(true);
                this.java2jsBeforeLaunch.setSelection(isJava2JsBeforeLaunch);
            } else {
                if (this.java2jsBeforeLaunch.isEnabled()) {
                    this.java2jsBeforeLaunch.setSelection(false);
                }
                this.buildBeforeLaunch.setSelection(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        boolean isBuildBeforeLaunch = this.buildBeforeLaunch.getSelection();
        if (isBuildBeforeLaunch) {
            configuration.setAttribute("buildBeforeLaunch", this.buildBeforeLaunch.getSelection());
            configuration.setAttribute("java2jsBeforeLaunch", this.java2jsBeforeLaunch.getSelection());
        } else {
            configuration.setAttribute("buildBeforeLaunch", false);
            configuration.setAttribute("java2jsBeforeLaunch", false);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("buildBeforeLaunch", false);
        configuration.setAttribute("java2jsBeforeLaunch", false);
        if (this.java2jsBeforeLaunch != null) {
            this.java2jsBeforeLaunch.setSelection(false);
        }
        if (this.buildBeforeLaunch != null) {
            this.buildBeforeLaunch.setSelection(false);
        }
    }

    private class SelectionHandler
    implements SelectionListener {
        private SelectionHandler() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            ScriptBuildTab.this.handleSelection(e);
        }

        public void widgetSelected(SelectionEvent e) {
            ScriptBuildTab.this.handleSelection(e);
        }
    }
}

