/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.formatter.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class ExcludeRegionList {
    private final List excludes = new ArrayList();
    private static final Comparator REGION_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((IRegion)o1).getOffset() - ((IRegion)o2).getOffset();
        }
    };

    public boolean isExcluded(int start, int end) {
        if (!this.excludes.isEmpty()) {
            for (IRegion region : this.excludes) {
                int regionEnd = region.getOffset() + region.getLength();
                if (start > regionEnd || region.getOffset() > end) continue;
                return true;
            }
        }
        return false;
    }

    public IRegion[] selectValidRanges(int start, int end) {
        ArrayList<Region> result = new ArrayList<Region>();
        for (IRegion region : this.excludes) {
            int regionEnd = region.getOffset() + region.getLength();
            if (start > regionEnd || region.getOffset() > end) continue;
            if (start < region.getOffset()) {
                int validEnd = Math.min(end, region.getOffset());
                result.add(new Region(start, validEnd - start));
            }
            if ((start = regionEnd) > end) break;
        }
        if (start < end) {
            result.add(new Region(start, end - start));
        }
        return result.toArray(new IRegion[result.size()]);
    }

    public List getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public void excludeRegion(IRegion region) {
        int start = region.getOffset();
        int end = region.getOffset() + region.getLength();
        if (!this.excludes.isEmpty()) {
            Iterator i = this.excludes.iterator();
            while (i.hasNext()) {
                IRegion r = (IRegion)i.next();
                int rEnd = r.getOffset() + r.getLength();
                if (r.getOffset() > end || start > rEnd) continue;
                if (region.getOffset() >= r.getOffset() && region.getOffset() + region.getLength() <= rEnd) {
                    return;
                }
                if (r.getOffset() < start) {
                    start = r.getOffset();
                }
                if (rEnd > end) {
                    end = rEnd;
                }
                i.remove();
            }
        }
        if (start == region.getOffset() && end == region.getOffset() + region.getLength()) {
            this.excludes.add(region);
        } else {
            this.excludes.add(new Region(start, end - start));
        }
        Collections.sort(this.excludes, REGION_COMPARATOR);
    }
}

