/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ui;

import java.util.StringTokenizer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MembersOrderPreferenceCache
implements IPropertyChangeListener {
    public static final int TYPE_INDEX = 0;
    public static final int CONSTRUCTORS_INDEX = 1;
    public static final int METHOD_INDEX = 2;
    public static final int FIELDS_INDEX = 3;
    public static final int N_CATEGORIES = 4;
    private int[] fCategoryOffsets = null;
    private IPreferenceStore fPreferenceStore = null;

    public void install(IPreferenceStore store) {
        this.fPreferenceStore = store;
        store.addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        this.fPreferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        this.fPreferenceStore = null;
    }

    public static boolean isMemberOrderProperty(String property) {
        return "outlinesortoption".equals(property);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("outlinesortoption".equals(property)) {
            this.fCategoryOffsets = null;
        }
    }

    public int getCategoryIndex(int kind) {
        if (this.fCategoryOffsets == null) {
            this.fCategoryOffsets = this.getCategoryOffsets();
        }
        return this.fCategoryOffsets[kind];
    }

    private int[] getCategoryOffsets() {
        int[] offsets = new int[4];
        IPreferenceStore store = this.fPreferenceStore;
        String key = "outlinesortoption";
        boolean success = this.fillCategoryOffsetsFromPreferenceString(store.getString(key), offsets);
        if (!success) {
            store.setToDefault(key);
            this.fillCategoryOffsetsFromPreferenceString(store.getDefaultString(key), offsets);
        }
        return offsets;
    }

    private boolean fillCategoryOffsetsFromPreferenceString(String str, int[] offsets) {
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if ("T".equals(token)) {
                offsets[0] = i++;
                continue;
            }
            if ("M".equals(token)) {
                offsets[2] = i++;
                continue;
            }
            if ("F".equals(token)) {
                offsets[3] = i++;
                continue;
            }
            if (!"C".equals(token)) continue;
            offsets[1] = i++;
        }
        return i == 4;
    }
}

