/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.af.common.error.ErrorList;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReportPolicy;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;

public abstract class BaseFindTypeSupport
implements IFindTypeSupport {
    public static final ErrorReporter NO_ERROR_REPORTER = new ErrorReporter(){

        @Override
        public void error(String message, String resource, int line, int column) {
        }

        @Override
        public void error(String message, String resource, int start, int end, int line, int column) {
        }

        @Override
        public ErrorList getErrors() {
            return new ErrorList(0);
        }

        @Override
        public ErrorList getWarnings() {
            return new ErrorList(0);
        }

        @Override
        public boolean hasErrors() {
            return false;
        }

        @Override
        public boolean hasWarnings() {
            return false;
        }

        @Override
        public void report(ErrorReportPolicy.ReportLevel level, String message, String resource, int line, int column) {
        }

        @Override
        public void reportAll() {
        }

        @Override
        public void reportErrors() {
        }

        @Override
        public void reportWarnings() {
        }

        @Override
        public void setReportErrors(boolean value) {
        }

        @Override
        public void setReportWarnings(boolean value) {
        }

        @Override
        public void warning(String message, String resource, int line, int column) {
        }

        @Override
        public void warning(String message, String resource, int start, int end, int line, int column) {
        }
    };
    public static final IFindTypeSupport.ILineInfoProvider ZERO_LINE_INFO_PROVIDER = new IFindTypeSupport.ILineInfoProvider(){

        @Override
        public int line(int beginOffset) {
            return 0;
        }

        @Override
        public int col(int beginOffset) {
            return 0;
        }
    };
    private IJstType m_currentType;
    private ErrorReporter m_errorReporter = NO_ERROR_REPORTER;
    private IFindTypeSupport.ILineInfoProvider m_lineInfoProvider = ZERO_LINE_INFO_PROVIDER;
    private char[] m_originalSource = new char[0];
    private Map<String, IJstType> m_symbol2TypeMap = new HashMap<String, IJstType>(0);

    @Override
    public IJstType getCurrentType() {
        return this.m_currentType;
    }

    public BaseFindTypeSupport setCurrentType(IJstType currentType) {
        this.m_currentType = currentType;
        return this;
    }

    @Override
    public ErrorReporter getErrorReporter() {
        return this.m_errorReporter;
    }

    public BaseFindTypeSupport setErrorReporter(ErrorReporter ep) {
        this.m_errorReporter = ep;
        return this;
    }

    @Override
    public IFindTypeSupport.ILineInfoProvider getLineInfoProvider() {
        if (this.m_lineInfoProvider == null && this.getOriginalSource() != null) {
            this.m_lineInfoProvider = new JstSourceUtil(this.getLineEndings(), 0, this.m_originalSource.length);
        }
        return this.m_lineInfoProvider;
    }

    public BaseFindTypeSupport setLineInfoProvider(IFindTypeSupport.ILineInfoProvider li) {
        this.m_lineInfoProvider = li;
        return this;
    }

    @Override
    public char[] getOriginalSource() {
        return this.m_originalSource;
    }

    public BaseFindTypeSupport setOriginalSource(char[] source) {
        this.m_originalSource = source;
        return this;
    }

    public BaseFindTypeSupport setSymbol2TypeMap(Map<String, IJstType> symbol2TypeMap) {
        if (symbol2TypeMap != null) {
            this.m_symbol2TypeMap.clear();
            this.m_symbol2TypeMap.putAll(symbol2TypeMap);
        }
        return this;
    }

    @Override
    public IJstType findTypeByName(String name) {
        IJstType foundFromOwningMap = this.m_symbol2TypeMap.get(name);
        if (foundFromOwningMap == null) {
            return JstCache.getInstance().getType(name);
        }
        return foundFromOwningMap;
    }
}

