/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstParamType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentCollector;
import org.eclipse.vjet.dsf.jstojava.report.DefaultErrorReporter;
import org.eclipse.vjet.dsf.jstojava.report.ErrorReporter;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.ISectionTranslatorProvider;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateConfig;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.TranslatorProvider;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.VjoSectionTranlationProvider;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class TranslateCtx
implements IFindTypeSupport {
    private TranslatorProvider m_provider;
    private CommentCollector m_comments;
    private VjoConvention m_convention;
    private boolean m_allowStatementsProcessing = true;
    private int completionPos = -1;
    private boolean isCreatedCompletion = false;
    private Stack<SourceOffset> currentBlock = new Stack();
    private Stack<ScopeId> blockStack;
    private JstType m_currentType;
    private HashMap<String, IJstType> m_typeSymbolMap;
    private CompilationUnitDeclaration m_ast;
    private String m_originalSource;
    private String group;
    private ErrorReporter m_errorReporter;
    private List<JstCompletion> m_syntaxErrors;
    private IFindTypeSupport.ILineInfoProvider m_sourceUtil;
    private TranslateConfig m_config;
    private List<JstBlock> m_listBlocks;
    private Map<IJstType, JstFunctionRefType> m_functionRefReplacement;
    private ISectionTranslatorProvider m_sectionTranslatorProvider;
    private String m_scopeForGlobals;
    private IFindTypeSupport.ILineInfoProvider m_lineProvider;
    private List<JstCompletion> m_getBlockCompletions;
    private int[] m_lineEndings;

    public TranslateCtx() {
        this.currentBlock.push(new SourceOffset());
        this.blockStack = new Stack();
        this.m_typeSymbolMap = null;
        this.m_listBlocks = null;
        this.m_scopeForGlobals = null;
        this.m_config = new TranslateConfig();
    }

    public TranslateCtx(TranslateConfig config) {
        this.currentBlock.push(new SourceOffset());
        this.blockStack = new Stack();
        this.m_typeSymbolMap = null;
        this.m_listBlocks = null;
        this.m_scopeForGlobals = null;
        if (config == null) {
            config = new TranslateConfig();
        }
        this.m_config = config;
    }

    public void setCompletionPos(int completionPos) {
        this.completionPos = completionPos;
    }

    public int getCompletionPos() {
        return this.completionPos;
    }

    public TranslatorProvider getProvider() {
        if (this.m_provider == null) {
            this.m_provider = new TranslatorProvider(this);
            return this.m_provider;
        }
        return this.m_provider;
    }

    public void setProvider(TranslatorProvider provider) {
        this.m_provider = provider;
    }

    public CommentCollector getCommentCollector() {
        if (this.m_comments == null) {
            this.m_comments = new CommentCollector();
        }
        return this.m_comments;
    }

    public void setCommentCollector(CommentCollector comments) {
        this.m_comments = comments;
    }

    public boolean isAllowPartialJST() {
        return this.m_config.isAllowPartialJST();
    }

    @Override
    public ErrorReporter getErrorReporter() {
        if (this.m_errorReporter == null) {
            this.m_errorReporter = new DefaultErrorReporter();
        }
        return this.m_errorReporter;
    }

    protected VjoConvention getVjoConvention() {
        if (this.m_convention == null) {
            this.m_convention = new VjoConvention();
        }
        return this.m_convention;
    }

    public void setAllowStatementsProcessing(boolean allow) {
        this.m_allowStatementsProcessing = allow;
    }

    public boolean isAllowStatementsProcesing() {
        return this.m_allowStatementsProcessing;
    }

    @Override
    public char[] getOriginalSource() {
        return this.m_ast.compilationResult.compilationUnit.getContents();
    }

    public String getOriginalSourceAsString() {
        if (this.m_originalSource == null && this.getOriginalSource() != null) {
            this.m_originalSource = String.valueOf(this.getOriginalSource());
        }
        return this.m_originalSource;
    }

    public boolean isCreatedCompletion() {
        return this.isCreatedCompletion;
    }

    public void setCreatedCompletion(boolean isCreatedCompletion) {
        this.isCreatedCompletion = isCreatedCompletion;
    }

    public int getPreviousNodeSourceEnd() {
        int previousNodeSourceEnd = this.getCurrentSourceOffset().previousNodeSourceEnd;
        if (previousNodeSourceEnd != 0) {
            return previousNodeSourceEnd;
        }
        int size = this.currentBlock.size();
        int length = size - 1;
        while (size > 0) {
            if (((SourceOffset)this.currentBlock.get((int)length)).previousNodeSourceEnd != 0) {
                return ((SourceOffset)this.currentBlock.get((int)length)).previousNodeSourceEnd;
            }
            --size;
        }
        return previousNodeSourceEnd;
    }

    public void setPreviousNodeSourceEnd(int previousNodeSourceEnd) {
        this.getCurrentSourceOffset().previousNodeSourceEnd = previousNodeSourceEnd;
    }

    public int getNextNodeSourceStart() {
        return this.getCurrentSourceOffset().nextNodeSourceStart;
    }

    public void setNextNodeSourceStart(int nextNodeSourceStart) {
        this.getCurrentSourceOffset().nextNodeSourceStart = nextNodeSourceStart;
    }

    public void enterBlock(ScopeId scope) {
        this.blockStack.push(scope);
        this.currentBlock.push(new SourceOffset());
    }

    public void exitBlock() {
        try {
            this.blockStack.pop();
            this.currentBlock.pop();
        }
        catch (EmptyStackException emptyStackException) {}
    }

    public ScopeId getCurrentScope() {
        try {
            if (this.blockStack.isEmpty()) {
                return ScopeIds.GLOBAL;
            }
            return this.blockStack.peek();
        }
        catch (EmptyStackException emptyStackException) {
            return ScopeIds.GLOBAL;
        }
    }

    public void setCurrentType(JstType type) {
        this.m_currentType = type;
    }

    public JstType getCurrentType() {
        return this.m_currentType;
    }

    public void setAST(CompilationUnitDeclaration ast) {
        this.m_ast = ast;
    }

    public CompilationUnitDeclaration getAST() {
        return this.m_ast;
    }

    public Stack<ScopeId> getScopeStack() {
        return this.blockStack;
    }

    private SourceOffset getCurrentSourceOffset() {
        int size = this.currentBlock.size();
        if (size == 0) {
            return null;
        }
        return (SourceOffset)this.currentBlock.get(size - 1);
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isSkiptImplementation() {
        return this.m_config.isSkiptImplementation();
    }

    public void setScriptUnitBlockList(List<JstBlock> blockList) {
        this.m_listBlocks = blockList;
    }

    public List<JstBlock> getScriptUnitBlockList() {
        return this.m_listBlocks;
    }

    public void addSyntaxError(JstCompletion completion) {
        this.getSyntaxErrors().add(completion);
    }

    public List<JstCompletion> getJstErrors() {
        return Collections.unmodifiableList(this.getSyntaxErrors());
    }

    private List<JstCompletion> getSyntaxErrors() {
        if (this.m_syntaxErrors == null) {
            this.m_syntaxErrors = new ArrayList<JstCompletion>();
        }
        return this.m_syntaxErrors;
    }

    public IFindTypeSupport.ILineInfoProvider getSourceUtil() {
        if (this.m_sourceUtil == null && this.getAST() != null) {
            this.m_sourceUtil = this.getLineInfoProvider();
        }
        return this.m_sourceUtil;
    }

    public boolean isSkipJsExtSyntaxArgs() {
        return this.m_config.isSkipJsExtSyntaxArgs();
    }

    public synchronized HashMap<String, IJstType> getTypeSymbolMap() {
        ScopeId scope = this.getCurrentScope();
        JstType type = this.m_currentType;
        if (type == null || scope.equals((Object)ScopeIds.GLOBAL)) {
            return null;
        }
        if (type instanceof IJstOType) {
            type = (JstType)type.getParentNode();
        }
        while (type != null && type.isEmbededType()) {
            type = type.getOuterType();
        }
        if (this.m_typeSymbolMap == null && type != null) {
            this.m_typeSymbolMap = new LinkedHashMap<String, IJstType>();
            this.m_typeSymbolMap.put(type.getSimpleName(), (IJstType)type);
            this.m_typeSymbolMap.put(type.getName(), (IJstType)type);
            this.addToTypeSymbolMap(type.getImportsMap());
            this.addToTypeSymbolMap(type.getInactiveImportsMap());
            this.addToTypeSymbolMap(type.getSatisfies());
            this.addToTypeSymbolMap(type.getExtends());
            LinkedList<IJstType> paramTypes = new LinkedList<IJstType>();
            for (JstParamType paramType : type.getParamTypes()) {
                paramTypes.add((IJstType)paramType);
            }
            this.addToTypeSymbolMap(paramTypes);
        }
        return this.m_typeSymbolMap;
    }

    private void addToTypeSymbolMap(Map<String, ? extends IJstType> map) {
        if (this.m_typeSymbolMap != null) {
            for (Map.Entry<String, ? extends IJstType> entry : map.entrySet()) {
                String key = entry.getKey();
                IJstType value = entry.getValue();
                this.m_typeSymbolMap.put(key, value);
                this.m_typeSymbolMap.put(value.getName(), value);
            }
        }
    }

    private void addToTypeSymbolMap(List<IJstType> list) {
        if (this.m_typeSymbolMap != null) {
            for (IJstType type : list) {
                this.m_typeSymbolMap.put(type.getSimpleName(), type);
            }
        }
    }

    public void addTypeReplacement(JstType typeToReplace, JstFunctionRefType ref) {
        if (this.m_functionRefReplacement == null) {
            this.m_functionRefReplacement = new LinkedHashMap<IJstType, JstFunctionRefType>();
        }
        this.m_functionRefReplacement.put((IJstType)typeToReplace, ref);
    }

    public boolean hasFunctionTypeRefReplacements() {
        return this.m_functionRefReplacement != null && this.m_functionRefReplacement.size() > 0;
    }

    public Map<IJstType, JstFunctionRefType> getFunctionTypeRefReplacements() {
        return this.m_functionRefReplacement;
    }

    public Class<? extends IRobustTranslator> getSectionTranslator(String token) {
        if (this.m_sectionTranslatorProvider == null) {
            this.m_sectionTranslatorProvider = new VjoSectionTranlationProvider();
        }
        return this.m_sectionTranslatorProvider.getTranslator(token);
    }

    public String[] getSections() {
        return this.m_sectionTranslatorProvider.getSections();
    }

    public void setScopeForGlobals(String scopeForGlobals) {
        this.m_scopeForGlobals = scopeForGlobals;
    }

    public String getScopeForGlobals() {
        return this.m_scopeForGlobals;
    }

    @Override
    public IFindTypeSupport.ILineInfoProvider getLineInfoProvider() {
        if (this.m_lineProvider == null) {
            this.m_lineProvider = new JstSourceUtil(this.getLineEndings(), this.m_ast.sourceStart, this.m_ast.sourceEnd);
        }
        return this.m_lineProvider;
    }

    @Override
    public IJstType findTypeByName(String longname) {
        HashMap<String, IJstType> typeNameMap = this.getTypeSymbolMap();
        if (typeNameMap != null) {
            longname = longname.trim();
            for (Map.Entry entry : typeNameMap.entrySet()) {
                int longLen;
                if (entry.getKey() == null) {
                    return null;
                }
                String typeName = ((String)entry.getKey()).trim();
                if (!longname.startsWith(typeName)) continue;
                IJstType type = (IJstType)entry.getValue();
                int shortLen = typeName.length();
                if (shortLen == (longLen = longname.length())) {
                    return type;
                }
                if (longname.charAt(shortLen) != '.' || shortLen + 1 >= longLen || (type = TranslateHelper.findInnerOrOType(type, longname.substring(shortLen + 1))) == null) continue;
                return type;
            }
        } else if (ScopeIds.GLOBAL.equals((Object)this.getCurrentScope()) && this.m_currentType != null) {
            JstParamType paramType = this.m_currentType.getParamType(longname);
            return paramType;
        }
        return null;
    }

    public void addBlockCompletion(JstCompletion cmp) {
        this.getBlockCompletions().add(cmp);
    }

    public List<JstCompletion> getBlockCompletions() {
        if (this.m_getBlockCompletions == null) {
            this.m_getBlockCompletions = new ArrayList<JstCompletion>();
        }
        return this.m_getBlockCompletions;
    }

    @Override
    public int[] getLineEndings() {
        if (this.m_lineEndings == null) {
            this.m_lineEndings = this.m_ast.compilationResult.lineSeparatorPositions;
            int[] copyFrom = this.m_ast.compilationResult.lineSeparatorPositions;
            int[] copyTo = new int[copyFrom.length + 1];
            System.arraycopy(copyFrom, 0, copyTo, 0, copyTo.length - 1);
            copyTo[copyTo.length - 1] = this.m_ast.sourceEnd;
            this.m_lineEndings = copyTo;
        }
        return this.m_lineEndings;
    }

    public void setLineProvider(IFindTypeSupport.ILineInfoProvider lineInfoProvider) {
        this.m_lineProvider = lineInfoProvider;
    }

    public void setLineEndings(int[] lineEndings) {
        this.m_lineEndings = lineEndings;
    }

    public static class SourceOffset {
        int previousNodeSourceEnd = 0;
        int nextNodeSourceStart = 0;
    }
}

