/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.translator.BaseTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.DefaultErrorCollector;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ErrorChunk;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IErrorCollector;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IRobustTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.IntegerHolder;
import org.eclipse.vjet.dsf.jstojava.translator.robust.RobustTranslatorFactory;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstKeywordCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstSyntaxError;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstTypeCompletion;

abstract class BaseRobustTranslator
implements IRobustTranslator {
    private static final char DOT = '.';
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String DOUBLE_SLASH = "//";
    protected static final String EMPTY = "";
    protected Stack<IProgramElement> astElements;
    protected JstType jst;
    protected IProgramElement current;
    protected BaseTranslator weakTranslator;
    protected IntegerHolder completionPos;
    protected final TranslateCtx m_ctx;
    public static final List<String> ALLOWED_KEYWORDS = new ArrayList<String>();

    BaseRobustTranslator(TranslateCtx ctx) {
        this.m_ctx = ctx;
    }

    protected JstSource createSource(IFindTypeSupport.ILineInfoProvider util, int start, int end, String decl) {
        return TranslateHelper.createJstSource(util, decl.length(), start, end);
    }

    protected JstTypeCompletion createOnTypeCompletion() {
        return new JstTypeCompletion((BaseJstNode)this.jst);
    }

    protected final boolean checkOnTypeCompletion() {
        boolean onTypeCompletion = false;
        if (this.current instanceof MessageSend && ((MessageSend)this.current).arguments != null) {
            Expression[] expArgs;
            Expression[] expressionArray = expArgs = ((MessageSend)this.current).arguments;
            int n = expArgs.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                onTypeCompletion = this.checkOnTypeCompletion(onTypeCompletion, expression);
                ++n2;
            }
        }
        this.checkOnNameCompletion();
        return onTypeCompletion;
    }

    private boolean checkOnTypeCompletion(boolean onTypeCompletion, Expression expArg) {
        if (expArg instanceof StringLiteral) {
            StringLiteral arg = (StringLiteral)expArg;
            int startPos = arg.sourceStart() + 1;
            boolean bl = onTypeCompletion = this.completionPos.value() >= startPos && this.completionPos.value() <= arg.sourceEnd();
            if (onTypeCompletion) {
                String composite = new String(arg.source());
                int prefix = this.completionPos.value() - startPos;
                this.setOnTypeCompletion(startPos, arg.sourceEnd(), composite, composite.substring(0, prefix));
            }
        }
        return onTypeCompletion;
    }

    protected void checkOnNameCompletion() {
        String token;
        if (this.current != null && (token = this.getToken(this.current)) != null) {
            boolean onNameCompletion;
            int startPos = this.getStartPos(this.current, token);
            int endPos = startPos + token.length();
            boolean bl = onNameCompletion = this.completionPos.value() >= startPos && this.completionPos.value() <= endPos;
            if (onNameCompletion) {
                String composite = token;
                int prefix = this.completionPos.value() - startPos;
                this.setOnNameCompletion(startPos, endPos, composite, composite.substring(0, prefix));
            }
        }
    }

    private String getToken(IProgramElement element) {
        String token = null;
        if (element instanceof MessageSend) {
            MessageSend send = (MessageSend)element;
            token = String.valueOf(send.selector);
        }
        if (element instanceof SingleNameReference) {
            SingleNameReference reference = (SingleNameReference)element;
            token = String.valueOf(reference.token);
        }
        return token;
    }

    private int getStartPos(IProgramElement send, String token) {
        char[] cs = this.weakTranslator.getCtx().getOriginalSource();
        String s = String.valueOf(cs, send.sourceStart(), send.sourceEnd() - send.sourceStart() + 1);
        return s.indexOf(token) + send.sourceStart();
    }

    private void setOnNameCompletion(int start, int end, String composite, String token) {
        JstTypeCompletion onTypeCompletion = this.createOnNameCompletion();
        onTypeCompletion.setSource(this.createSource(this.m_ctx.getSourceUtil(), start, end, "JstOnTypeCompletion"));
        onTypeCompletion.setToken(token);
        onTypeCompletion.setCompositeToken(composite);
        onTypeCompletion.setParent((IJstType)this.jst);
        this.completionPos.wrap(-1);
    }

    protected JstTypeCompletion createOnNameCompletion() {
        return new JstTypeCompletion((BaseJstNode)this.jst);
    }

    protected void analyzeErrorChunk(ErrorChunk errorChunk) {
        String composite = errorChunk.toString();
        int errorIndex = 0;
        for (IProgramElement error : errorChunk.getErrorChunk()) {
            String errorToken = TranslateHelper.getStringToken(error);
            int start = this.getStartOffset(error, errorToken);
            int end = error.sourceEnd() + 1;
            int prefix = this.completionPos.value() - start;
            if (++errorIndex == 1 && this.completionPos.value() >= start && this.completionPos.value() <= end && prefix <= errorToken.length()) {
                String sub = errorToken.substring(0, prefix);
                ArrayList<String> completions = new ArrayList<String>();
                String[] stringArray = this.getAllowedTokens();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String allowed = stringArray[n2];
                    if (allowed.startsWith(sub)) {
                        completions.add(allowed);
                    }
                    ++n2;
                }
                this.setKeywordCompletion(start, error.sourceEnd() + 1, composite, sub, completions.toArray(new String[0]));
                continue;
            }
            this.setSyntaxError(start, error.sourceEnd(), composite, errorToken);
        }
    }

    private int getStartOffset(IProgramElement error, String errorToken) {
        int offset = error.sourceEnd() - errorToken.length() + 1;
        if (error instanceof MessageSend) {
            int position;
            char[] source = this.weakTranslator.getCtx().getOriginalSource();
            String content = String.valueOf(source);
            int pos = this.completionPos.value();
            if (pos != -1 && pos < content.length() && (position = content.lastIndexOf(errorToken, pos)) != -1) {
                offset = position;
            }
        }
        return offset;
    }

    protected final void setOnTypeCompletion(int start, int end, String composite, String token) {
        JstTypeCompletion onTypeCompletion = this.createOnTypeCompletion();
        onTypeCompletion.setSource(this.createSource(this.m_ctx.getSourceUtil(), start, end, "JstOnTypeCompletion"));
        onTypeCompletion.setToken(token);
        onTypeCompletion.setCompositeToken(composite);
        this.m_ctx.addSyntaxError(onTypeCompletion);
        onTypeCompletion.setParent((IJstType)this.jst);
        this.completionPos.wrap(-1);
    }

    protected final void setSyntaxError(int start, int end, String composite, String token) {
        JstSyntaxError error = new JstSyntaxError((BaseJstNode)this.jst);
        error.setSource(this.createSource(this.m_ctx.getSourceUtil(), start, end, "JstSyntaxError"));
        error.setCompositeToken(composite);
        error.setToken(token);
        error.setParent((IJstType)this.jst);
    }

    protected final void setKeywordCompletion(int start, int end, String composite, String token, String[] completions) {
        JstKeywordCompletion completion = new JstKeywordCompletion((BaseJstNode)this.jst, completions);
        completion.setSource(this.createSource(this.m_ctx.getSourceUtil(), start, end, "JstKeywordCompletion"));
        completion.setCompositeToken(composite);
        completion.setToken(token);
        completion.setParent((IJstType)this.jst);
        completion.setScopeStack(this.m_ctx.getScopeStack());
        this.m_ctx.addSyntaxError(completion);
        this.completionPos.wrap(-1);
    }

    protected final void lookupEmptyCompletion() {
        if (this.current instanceof MessageSend) {
            this.checkForCommentCompletion((ASTNode)this.current);
            if (this.m_ctx.isCreatedCompletion()) {
                return;
            }
        }
        char[] originSrc = this.weakTranslator.getCtx().getOriginalSource();
        if (this.current != null && this.astElements.empty()) {
            if (originSrc.length > this.current.sourceEnd() + 1 && this.hasCompletionDot(originSrc)) {
                int start = this.current.sourceEnd() + 2;
                int end = originSrc.length;
                if (this.completionPos.value() >= start && this.completionPos.value() <= end) {
                    this.setKeywordCompletion(start, end, EMPTY, EMPTY, this.getAllowedTokens());
                }
            }
        } else if (this.current != null) {
            IProgramElement next = this.astElements.peek();
            int start = this.current.sourceEnd() + 2;
            String origin = new String(originSrc);
            String token = TranslateHelper.getStringToken(next);
            int end = origin.indexOf(token, start);
            if (this.completionPos.value() >= start && this.completionPos.value() <= end) {
                this.setKeywordCompletion(start, end, EMPTY, EMPTY, this.getAllowedTokens());
            }
        }
    }

    private boolean hasCompletionDot(char[] originSrc) {
        boolean hasDot = false;
        int end = this.completionPos.value();
        int start = this.current.sourceEnd() + 1;
        if (end == -1 || start > end) {
            return hasDot;
        }
        int i = start;
        while (i < end) {
            char c = originSrc[i];
            if (c == '.') {
                hasDot = true;
                break;
            }
            if (!Character.isWhitespace(c)) break;
            ++i;
        }
        return hasDot;
    }

    protected String[] getAllowedTokens() {
        return this.m_ctx.getSections();
    }

    protected final IRobustTranslator instantiateTranslator(IProgramElement element) {
        String token = TranslateHelper.getStringToken(element);
        IRobustTranslator translator = RobustTranslatorFactory.createTranslator(this.m_ctx, this.m_ctx.getSectionTranslator(token));
        if (translator != null) {
            translator.configure(this.astElements, this.jst, this.weakTranslator, this.completionPos);
        }
        return translator;
    }

    @Override
    public final void configure(Stack<IProgramElement> astElements, JstType jst, BaseTranslator weakTranslator, IntegerHolder completionPos) {
        this.astElements = astElements;
        this.jst = jst;
        this.weakTranslator = weakTranslator;
        this.completionPos = completionPos;
    }

    @Override
    public IErrorCollector getErrorCollector() {
        return new DefaultErrorCollector(this.current, this.astElements){

            @Override
            public boolean isValidToken(String token) {
                String[] stringArray = BaseRobustTranslator.this.getAllowedTokens();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String allowedToken = stringArray[n2];
                    if (allowedToken.equals(token)) {
                        return true;
                    }
                    ++n2;
                }
                for (String allowedToken : ALLOWED_KEYWORDS) {
                    if (!allowedToken.equals(token)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void collect() {
                super.collect();
                BaseRobustTranslator.this.analyzeErrorChunk(this.toErrorChunk());
            }
        };
    }

    @Override
    public boolean transform() {
        boolean skipTransformation = false;
        if (!this.checkOnTypeCompletion()) {
            this.processCompletion();
        }
        this.lookupEmptyCompletion();
        while (!this.astElements.empty() && !skipTransformation) {
            IProgramElement nextElement = this.astElements.peek();
            IRobustTranslator subTranslator = this.getSubTranslator(nextElement);
            if (subTranslator != null) {
                skipTransformation = subTranslator.transform();
                continue;
            }
            this.getErrorCollector().collect();
        }
        return skipTransformation;
    }

    protected void processCompletion() {
    }

    protected void checkForCommentCompletion(ASTNode astNode) {
        if (this.m_ctx.isCreatedCompletion()) {
            return;
        }
        int completionPos = this.m_ctx.getCompletionPos();
        if (completionPos == -1) {
            return;
        }
        if (astNode instanceof Argument || astNode instanceof SingleNameReference || astNode instanceof AllocationExpression || astNode instanceof Literal) {
            return;
        }
        List<IJsCommentMeta> metas = this.getCommentMeta(astNode);
        for (IJsCommentMeta meta : metas) {
            if (!JstCommentUtil.isWithInComment(meta.getBeginOffset(), meta.getEndOffset(), completionPos)) continue;
            JstCommentUtil.createComentCompletion(astNode, meta, this.m_ctx);
        }
        List<String> comments = JstCommentUtil.getNonMetaComments(astNode, this.m_ctx);
        for (String comment : comments) {
            int beginOffset;
            if (!this.isCommentMeta(comment) || (beginOffset = this.m_ctx.getCommentCollector().getCommentNonMetaBeginOffset(comment)) == -1 || !JstCommentUtil.isWithInComment(beginOffset, beginOffset + comment.length(), completionPos)) continue;
            JstCommentUtil.createComentCompletion(astNode, comment, beginOffset, beginOffset + comment.length(), this.m_ctx);
        }
    }

    private boolean isCommentMeta(String comment) {
        return comment.contains(DOUBLE_SLASH) && (comment.contains(GT) || comment.contains(LT));
    }

    private List<IJsCommentMeta> getCommentMeta(ASTNode astNode) {
        return this.m_ctx.getCommentCollector().getCommentMeta(astNode.sourceStart, astNode.sourceEnd, this.m_ctx.getPreviousNodeSourceEnd(), this.getNextNodeSourceStart(astNode), true);
    }

    private int getNextNodeSourceStart(ASTNode astNode) {
        IProgramElement ne;
        int next = astNode.sourceEnd;
        if (this.astElements.size() > 0 && (ne = this.astElements.peek()) instanceof MessageSend) {
            char[] selector = ((MessageSend)ne).selector;
            String src = this.m_ctx.getOriginalSourceAsString();
            if (selector != null && src != null) {
                next = src.indexOf(String.valueOf(selector), next);
            }
        }
        return next;
    }

    @Override
    public IRobustTranslator getSubTranslator(IProgramElement element) {
        IRobustTranslator subTranslator = null;
        if (element instanceof MessageSend) {
            subTranslator = this.instantiateTranslator(element);
        }
        return subTranslator;
    }
}

