/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.core.parser;

import java.util.List;
import org.eclipse.dltk.mod.compiler.problem.DefaultProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblem;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.vjet.dsf.jst.IJstParseController;
import org.eclipse.vjet.dsf.jst.IJstParser;
import org.eclipse.vjet.dsf.jst.IJstRefResolver;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.ts.IJstTypeLoader;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jstojava.controller.JstParseController;
import org.eclipse.vjet.dsf.jstojava.parser.VjoParser;
import org.eclipse.vjet.eclipse.core.VjetPlugin;
import org.eclipse.vjet.eclipse.core.parser.VjoSourceElementResolver;
import org.eclipse.vjet.eclipse.core.ts.VjoJstTypeLoader;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class VjoParserToJstAndIType {
    private static JstParseController m_controller;
    private IProblemReporter reporter;
    private boolean validatable = false;
    private int completionPos;

    public VjoParserToJstAndIType(IProblemReporter reporter) {
        this.reporter = reporter;
        this.validatable = reporter != null;
    }

    public VjoParserToJstAndIType() {
        this(null);
    }

    public IJstType parse(String groupName, String typeName, String source, int completionPos) {
        if (VjetPlugin.TRACE_PARSER) {
            System.out.println("%%%PARSING: typename:" + typeName + ", group:" + groupName);
        }
        this.completionPos = completionPos;
        IJstType unit = this.innerParse(groupName, typeName, source);
        if (unit != null) {
            return unit;
        }
        return VjoParser.UNKNOWNUNIT;
    }

    private static void initJstParserController() {
        VjoParser vjoParser = new VjoParser();
        m_controller = new JstParseController((IJstParser)vjoParser);
        m_controller.setRefResolver((IJstRefResolver)new VjoSourceElementResolver(m_controller));
        new JstTypeSpaceMgr((IJstParseController)m_controller, (IJstTypeLoader)new VjoJstTypeLoader());
    }

    public static JstParseController getJstParseController() {
        if (m_controller == null) {
            VjoParserToJstAndIType.initJstParserController();
        }
        return m_controller;
    }

    public IJstType parse(String groupName, String typeName, String source) {
        return this.parse(groupName, typeName, source, -1);
    }

    private IJstType innerParse(String groupName, String typeName, String source) {
        JstParseController m_controller = VjoParserToJstAndIType.getJstParseController();
        m_controller.setRefResolver((IJstRefResolver)new VjoSourceElementResolver(m_controller));
        m_controller.setJstTSMgr(TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr());
        try {
            IJstType unit = m_controller.parseAndResolve(groupName, typeName, source);
            return unit;
        }
        catch (Exception e) {
            e.printStackTrace();
            VjetPlugin.error("problem parsing: groupname=" + groupName + " typename =" + typeName, e);
            return null;
        }
    }

    public void reportProblems(List<DefaultProblem> problems, IProblemReporter reporter) {
        if (problems == null) {
            return;
        }
        for (IProblem iProblem : problems) {
            reporter.reportProblem(iProblem);
        }
    }

    public void enableValidation() {
        this.validatable = true;
    }

    public void disableValidation() {
        this.validatable = false;
    }
}

