/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.formatter;

import java.util.ArrayList;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AND_AND_Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CombinedBinaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ConditionalExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.DoubleLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.EqualExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ExtendedStringLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.InstanceOfExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.IntLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ListExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.NullLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.OR_OR_Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.PostfixExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.PrefixExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.RegExLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteralConcatenation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SuperReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.UnaryExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.UndefinedLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ClassScope;

class BinaryExpressionFragmentBuilder
extends ASTVisitor {
    ArrayList fragmentsList = new ArrayList();
    ArrayList operatorsList = new ArrayList();
    private int realFragmentsSize = 0;

    BinaryExpressionFragmentBuilder() {
    }

    private final void addRealFragment(ASTNode node) {
        this.fragmentsList.add(node);
        ++this.realFragmentsSize;
    }

    private final void addSmallFragment(ASTNode node) {
        this.fragmentsList.add(node);
    }

    private boolean buildFragments(Expression expression) {
        if ((expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment((ASTNode)expression);
            return false;
        }
        return true;
    }

    public ASTNode[] fragments() {
        ASTNode[] fragments = new ASTNode[this.fragmentsList.size()];
        this.fragmentsList.toArray(fragments);
        return fragments;
    }

    public int[] operators() {
        int length = this.operatorsList.size();
        int[] tab = new int[length];
        int i = 0;
        while (i < length) {
            tab[i] = (Integer)this.operatorsList.get(i);
            ++i;
        }
        return tab;
    }

    public int realFragmentsSize() {
        return this.realFragmentsSize;
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)allocationExpression);
        return false;
    }

    public boolean visit(AND_AND_Expression and_and_Expression, BlockScope scope) {
        if ((and_and_Expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment((ASTNode)and_and_Expression);
        } else {
            and_and_Expression.left.traverse((ASTVisitor)this, scope);
            this.operatorsList.add(new Integer(28));
            and_and_Expression.right.traverse((ASTVisitor)this, scope);
        }
        return false;
    }

    public boolean visit(ArrayAllocationExpression arrayAllocationExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)arrayAllocationExpression);
        return false;
    }

    public boolean visit(ArrayInitializer arrayInitializer, BlockScope scope) {
        this.addRealFragment((ASTNode)arrayInitializer);
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, BlockScope scope) {
        this.addRealFragment((ASTNode)arrayQualifiedTypeReference);
        return false;
    }

    public boolean visit(ArrayQualifiedTypeReference arrayQualifiedTypeReference, ClassScope scope) {
        this.addRealFragment((ASTNode)arrayQualifiedTypeReference);
        return false;
    }

    public boolean visit(ArrayReference arrayReference, BlockScope scope) {
        this.addRealFragment((ASTNode)arrayReference);
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, BlockScope scope) {
        this.addRealFragment((ASTNode)arrayTypeReference);
        return false;
    }

    public boolean visit(ArrayTypeReference arrayTypeReference, ClassScope scope) {
        this.addRealFragment((ASTNode)arrayTypeReference);
        return false;
    }

    public boolean visit(Assignment assignment, BlockScope scope) {
        this.addRealFragment((ASTNode)assignment);
        return false;
    }

    public boolean visit(BinaryExpression binaryExpression, BlockScope scope) {
        int numberOfParens;
        if (binaryExpression instanceof CombinedBinaryExpression) {
            CombinedBinaryExpression expression = (CombinedBinaryExpression)binaryExpression;
            if (expression.referencesTable != null) {
                return this.visit(expression, scope);
            }
        }
        if ((numberOfParens = (binaryExpression.bits & 0x1FE00000) >> 21) > 0) {
            this.addRealFragment((ASTNode)binaryExpression);
        } else {
            switch ((binaryExpression.bits & 0xFC0) >> 6) {
                case 14: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(1));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 13: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(2));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 15: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(10));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 16: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(9));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 8: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(23));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 9: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(11));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 3: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(27));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
                case 2: {
                    if (this.buildFragments((Expression)binaryExpression)) {
                        binaryExpression.left.traverse((ASTVisitor)this, scope);
                        this.operatorsList.add(new Integer(22));
                        binaryExpression.right.traverse((ASTVisitor)this, scope);
                    }
                    return false;
                }
            }
            this.addRealFragment((ASTNode)binaryExpression);
        }
        return false;
    }

    public boolean visit(CombinedBinaryExpression combinedBinaryExpression, BlockScope scope) {
        if (combinedBinaryExpression.referencesTable == null) {
            this.addRealFragment((ASTNode)combinedBinaryExpression.left);
            this.operatorsList.add(new Integer(1));
            this.addRealFragment((ASTNode)combinedBinaryExpression.right);
            return false;
        }
        BinaryExpression cursor = combinedBinaryExpression.referencesTable[0];
        if (cursor.left instanceof CombinedBinaryExpression) {
            this.visit((CombinedBinaryExpression)cursor.left, scope);
        } else {
            this.addRealFragment((ASTNode)cursor.left);
        }
        int i = 0;
        int end = combinedBinaryExpression.arity;
        while (i < end) {
            this.operatorsList.add(new Integer(1));
            this.addRealFragment((ASTNode)combinedBinaryExpression.referencesTable[i].right);
            ++i;
        }
        this.operatorsList.add(new Integer(1));
        this.addRealFragment((ASTNode)combinedBinaryExpression.right);
        return false;
    }

    public boolean visit(ClassLiteralAccess classLiteralAccess, BlockScope scope) {
        this.addRealFragment((ASTNode)classLiteralAccess);
        return false;
    }

    public boolean visit(CompoundAssignment compoundAssignment, BlockScope scope) {
        this.addRealFragment((ASTNode)compoundAssignment);
        return false;
    }

    public boolean visit(ConditionalExpression conditionalExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)conditionalExpression);
        return false;
    }

    public boolean visit(DoubleLiteral doubleLiteral, BlockScope scope) {
        this.addSmallFragment((ASTNode)doubleLiteral);
        return false;
    }

    public boolean visit(EqualExpression equalExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)equalExpression);
        return false;
    }

    public boolean visit(ExtendedStringLiteral extendedStringLiteral, BlockScope scope) {
        this.addRealFragment((ASTNode)extendedStringLiteral);
        return false;
    }

    public boolean visit(FalseLiteral falseLiteral, BlockScope scope) {
        this.addSmallFragment((ASTNode)falseLiteral);
        return false;
    }

    public boolean visit(FieldReference fieldReference, BlockScope scope) {
        this.addRealFragment((ASTNode)fieldReference);
        return false;
    }

    public boolean visit(ObjectLiteral literal, BlockScope scope) {
        this.addRealFragment((ASTNode)literal);
        return false;
    }

    public boolean visit(UndefinedLiteral undefined, BlockScope scope) {
        this.addSmallFragment((ASTNode)undefined);
        return false;
    }

    public boolean visit(FunctionExpression functionExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)functionExpression);
        return false;
    }

    public boolean visit(InstanceOfExpression instanceOfExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)instanceOfExpression);
        return false;
    }

    public boolean visit(IntLiteral intLiteral, BlockScope scope) {
        this.addSmallFragment((ASTNode)intLiteral);
        return false;
    }

    public boolean visit(ListExpression listExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)listExpression);
        return false;
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        this.addRealFragment((ASTNode)messageSend);
        return false;
    }

    public boolean visit(StringLiteralConcatenation stringLiteral, BlockScope scope) {
        if ((stringLiteral.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment((ASTNode)stringLiteral);
            return false;
        }
        int i = 0;
        int max = stringLiteral.counter;
        while (i < max) {
            this.addRealFragment((ASTNode)stringLiteral.literals[i]);
            if (i < max - 1) {
                this.operatorsList.add(new Integer(1));
            }
            ++i;
        }
        return false;
    }

    public boolean visit(NullLiteral nullLiteral, BlockScope scope) {
        this.addRealFragment((ASTNode)nullLiteral);
        return false;
    }

    public boolean visit(OR_OR_Expression or_or_Expression, BlockScope scope) {
        if ((or_or_Expression.bits & 0x1FE00000) >> 21 != 0) {
            this.addRealFragment((ASTNode)or_or_Expression);
        } else {
            or_or_Expression.left.traverse((ASTVisitor)this, scope);
            this.operatorsList.add(new Integer(29));
            or_or_Expression.right.traverse((ASTVisitor)this, scope);
        }
        return false;
    }

    public boolean visit(PostfixExpression postfixExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)postfixExpression);
        return false;
    }

    public boolean visit(PrefixExpression prefixExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)prefixExpression);
        return false;
    }

    public boolean visit(RegExLiteral regexLiteral, BlockScope scope) {
        this.addSmallFragment((ASTNode)regexLiteral);
        return false;
    }

    public boolean visit(QualifiedAllocationExpression qualifiedAllocationExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)qualifiedAllocationExpression);
        return false;
    }

    public boolean visit(QualifiedNameReference qualifiedNameReference, BlockScope scope) {
        this.addRealFragment((ASTNode)qualifiedNameReference);
        return false;
    }

    public boolean visit(QualifiedThisReference qualifiedThisReference, BlockScope scope) {
        this.addRealFragment((ASTNode)qualifiedThisReference);
        return false;
    }

    public boolean visit(SingleNameReference singleNameReference, BlockScope scope) {
        this.addRealFragment((ASTNode)singleNameReference);
        return false;
    }

    public boolean visit(StringLiteral stringLiteral, BlockScope scope) {
        this.addRealFragment((ASTNode)stringLiteral);
        return false;
    }

    public boolean visit(SuperReference superReference, BlockScope scope) {
        this.addRealFragment((ASTNode)superReference);
        return false;
    }

    public boolean visit(ThisReference thisReference, BlockScope scope) {
        this.addRealFragment((ASTNode)thisReference);
        return false;
    }

    public boolean visit(TrueLiteral trueLiteral, BlockScope scope) {
        this.addSmallFragment((ASTNode)trueLiteral);
        return false;
    }

    public boolean visit(UnaryExpression unaryExpression, BlockScope scope) {
        this.addRealFragment((ASTNode)unaryExpression);
        return false;
    }

    public int size() {
        return this.fragmentsList.size();
    }
}

