/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.formatter.comments;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.text.Position;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.vjet.eclipse.internal.formatter.comments.ICommentAttributes;
import org.eclipse.vjet.eclipse.internal.formatter.comments.IHtmlTagDelimiters;

public class CommentRange
extends Position
implements ICommentAttributes,
IHtmlTagDelimiters {
    private int fAttributes = 0;

    public CommentRange(int position, int count) {
        super(position, count);
    }

    protected final boolean hasAttribute(int attribute) {
        return (this.fAttributes & attribute) == attribute;
    }

    protected final boolean isClosingTag(char[] token, char[] tag) {
        boolean result;
        boolean bl = result = CharOperation.indexOf((char[])HTML_CLOSE_PREFIX, (char[])token, (boolean)false) == 0 && token[token.length - 1] == '>';
        if (result) {
            this.setAttribute(8);
            result = CharOperation.equals((char[])tag, (char[])token, (int)HTML_CLOSE_PREFIX.length, (int)(token.length - 1), (boolean)false);
        }
        return result;
    }

    protected final boolean isOpeningTag(char[] token, char[] tag) {
        boolean result;
        boolean bl = result = token.length > 0 && token[0] == '<' && CharOperation.indexOf((char[])HTML_CLOSE_PREFIX, (char[])token, (boolean)false) != 0 && token[token.length - 1] == '>';
        if (result) {
            this.setAttribute(256);
            result = CharOperation.indexOf((char[])tag, (char[])token, (boolean)false) == 1;
        }
        return result;
    }

    protected final void markHtmlTag(char[][] tags, char[] token, int attribute, boolean open, boolean close) {
        if (token[0] == '<' && token[token.length - 1] == '>') {
            char[] tag = null;
            boolean isOpen = false;
            boolean isClose = false;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                isOpen = this.isOpeningTag(token, tag);
                isClose = this.isClosingTag(token, tag);
                if (open && isOpen || close && isClose) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final void markPrefixTag(char[][] tags, char prefix, char[] token, int attribute) {
        if (token[0] == prefix) {
            char[] tag = null;
            int index = 0;
            while (index < tags.length) {
                tag = tags[index];
                if (CharOperation.equals((char[])token, (char[])tag)) {
                    this.setAttribute(attribute);
                    break;
                }
                ++index;
            }
        }
    }

    protected final int markTagRange(char[] token, char[] tag, int level, int key, boolean html) {
        if (this.isOpeningTag(token, tag)) {
            if (level++ > 0) {
                this.setAttribute(key);
            }
        } else if (this.isClosingTag(token, tag)) {
            if (--level > 0) {
                this.setAttribute(key);
            }
        } else if (level > 0 && (html || !this.hasAttribute(32))) {
            this.setAttribute(key);
        }
        return level;
    }

    public final void move(int delta) {
        this.offset += delta;
    }

    protected final void setAttribute(int attribute) {
        this.fAttributes |= attribute;
    }

    public final void trimBegin(int delta) {
        this.offset += delta;
        this.length -= delta;
    }

    public final void trimEnd(int delta) {
        this.length += delta;
    }

    public String toString() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (this.hasAttribute(2)) {
            attributes.add("COMMENT_BLANKLINE");
        }
        if (this.hasAttribute(4)) {
            attributes.add("COMMENT_BREAK");
        }
        if (this.hasAttribute(8)) {
            attributes.add("COMMENT_CLOSE");
        }
        if (this.hasAttribute(16)) {
            attributes.add("COMMENT_CODE");
        }
        if (this.hasAttribute(32)) {
            attributes.add("COMMENT_HTML");
        }
        if (this.hasAttribute(64)) {
            attributes.add("COMMENT_IMMUTABLE");
        }
        if (this.hasAttribute(128)) {
            attributes.add("COMMENT_NEWLINE");
        }
        if (this.hasAttribute(256)) {
            attributes.add("COMMENT_OPEN");
        }
        if (this.hasAttribute(512)) {
            attributes.add("COMMENT_PARAGRAPH");
        }
        if (this.hasAttribute(1024)) {
            attributes.add("COMMENT_PARAMETER");
        }
        if (this.hasAttribute(2048)) {
            attributes.add("COMMENT_ROOT");
        }
        if (this.hasAttribute(4096)) {
            attributes.add("COMMENT_SEPARATOR");
        }
        if (this.hasAttribute(8192)) {
            attributes.add("COMMENT_FIRST_TOKEN");
        }
        if (this.hasAttribute(16384)) {
            attributes.add("COMMENT_STARTS_WITH_RANGE_DELIMITER");
        }
        StringBuffer buf = new StringBuffer("CommentRange [" + this.offset + "+" + this.length + "] {");
        Iterator it = attributes.iterator();
        while (it.hasNext()) {
            String string = (String)it.next();
            buf.append(string);
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        return String.valueOf(buf.toString()) + "}";
    }
}

