/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javalaunch.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.vjet.eclipse.javalaunch.utils.EclipseResourceUtils;
import org.eclipse.vjet.eclipse.javalaunch.utils.SourcePathUtil;

public class LaunchListener
implements ILaunchListener {
    public void launchRemoved(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        this.addSourcePathToVMParameters(launch);
    }

    public void launchChanged(ILaunch launch) {
        this.addSourcePathToVMParameters(launch);
    }

    private void addSourcePathToVMParameters(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        IProject launchProject = null;
        if (launchConfiguration == null) {
            return;
        }
        try {
            String projectName = launchConfiguration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR", "");
            if (projectName != null && projectName.length() > 0) {
                launchProject = EclipseResourceUtils.getWorkspaceProject(projectName);
            }
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (launchProject == null) {
            return;
        }
        try {
            String sourcePath = SourcePathUtil.getSoucePathString(launchProject);
            String vmArgs = "";
            if (launchConfiguration == null) {
                return;
            }
            vmArgs = launchConfiguration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            vmArgs = SourcePathUtil.configureVmArguments(sourcePath, vmArgs);
            ILaunchConfigurationWorkingCopy wc = launchConfiguration.getWorkingCopy();
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, vmArgs);
            wc.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }
}

