/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.javatojs.ui;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Java2JsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.vjet.eclipse.javatojs.ui";
    public static final String CODE_GEN_MARKER_ID = "org.eclipse.vjet.eclipse.javatojs.ui.codeGenProblemMarker";
    public static final String MESSAGE_CONSOLE = "Java2Js";
    private static Java2JsPlugin plugin;
    private URL defaultJava2JsConfig;
    private Properties properties;

    public static void logException(Exception e) {
        plugin.getLog().log((IStatus)new Status(4, PLUGIN_ID, e.getLocalizedMessage(), (Throwable)e));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Java2JsPlugin getDefault() {
        return plugin;
    }

    public URL getDefaultJava2JsConfig() {
        if (this.defaultJava2JsConfig == null) {
            Path path = new Path("java2js.properties");
            URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)path, null);
            try {
                this.defaultJava2JsConfig = FileLocator.toFileURL((URL)url);
            }
            catch (IOException e) {
                Java2JsPlugin.logException(e);
            }
        }
        return this.defaultJava2JsConfig;
    }

    public Properties getDefaultJava2JsConfigProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
            Path path = new Path("java2js.properties");
            try {
                this.properties.load(FileLocator.openStream((Bundle)this.getBundle(), (IPath)path, (boolean)false));
            }
            catch (IOException e) {
                Java2JsPlugin.logException(e);
            }
        }
        return this.properties;
    }

    public MessageConsole getConsole() {
        IConsoleManager mgr = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = mgr.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole console = iConsoleArray[n2];
            if (MESSAGE_CONSOLE.equals(console.getName())) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        MessageConsole msgconsole = new MessageConsole(MESSAGE_CONSOLE, null);
        mgr.addConsoles(new IConsole[]{msgconsole});
        return msgconsole;
    }
}

