/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.dltk.mod.ui.preferences.AbstractConfigurationBlock;
import org.eclipse.dltk.mod.ui.preferences.OverlayPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.vjet.eclipse.internal.ui.preferences.VjetPreferenceMessages;

class VJOBuildPathConfigurationBlock
extends AbstractConfigurationBlock {
    private Button fFoldersAsSourceFolder;
    private Button fProjectAsSourceFolder;
    private Label fSrcFolderNameLabel;
    private Text fSrcFolderNameText;
    private SelectionListener fSelectionListener;
    private ModifyListener fModifyListener;
    private static final String SRCBIN_FOLDERS_IN_NEWPROJ = "com.xore.dltk.ui.wizards.srcBinFoldersInNewProjects";
    private static final String SRCBIN_SRCNAME = "com.xore.dltk.ui.wizards.srcFoldersSrcName";

    public VJOBuildPathConfigurationBlock(OverlayPreferenceStore store) {
        super(store);
        store.addKeys(this.createOverlayStoreKeys());
        this.fSelectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == VJOBuildPathConfigurationBlock.this.fProjectAsSourceFolder) {
                    VJOBuildPathConfigurationBlock.this.fSrcFolderNameLabel.setEnabled(false);
                    VJOBuildPathConfigurationBlock.this.fSrcFolderNameText.setEnabled(false);
                } else {
                    VJOBuildPathConfigurationBlock.this.fSrcFolderNameLabel.setEnabled(true);
                    VJOBuildPathConfigurationBlock.this.fSrcFolderNameText.setEnabled(true);
                }
            }
        };
        this.fModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
            }
        };
    }

    private OverlayPreferenceStore.OverlayKey[] createOverlayStoreKeys() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, SRCBIN_FOLDERS_IN_NEWPROJ));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, SRCBIN_SRCNAME));
        return overlayKeys.toArray(new OverlayPreferenceStore.OverlayKey[overlayKeys.size()]);
    }

    public Control createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Group sourceFolderGroup = new Group(composite, 0);
        sourceFolderGroup.setLayout((Layout)new GridLayout(2, false));
        sourceFolderGroup.setLayoutData((Object)new GridData(768));
        sourceFolderGroup.setText(VjetPreferenceMessages.NewVJOProjectPreferencePage_sourcefolder_label);
        this.fProjectAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, VjetPreferenceMessages.NewVJOProjectPreferencePage_sourcefolder_project, SRCBIN_FOLDERS_IN_NEWPROJ, "false", 0);
        this.fProjectAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fFoldersAsSourceFolder = this.addRadioButton((Composite)sourceFolderGroup, VjetPreferenceMessages.NewVJOProjectPreferencePage_sourcefolder_folder, SRCBIN_FOLDERS_IN_NEWPROJ, "true", 0);
        this.fFoldersAsSourceFolder.addSelectionListener(this.fSelectionListener);
        this.fSrcFolderNameLabel = new Label((Composite)sourceFolderGroup, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalIndent = 10;
        this.fSrcFolderNameLabel.setLayoutData((Object)gridData);
        this.fSrcFolderNameLabel.setText(VjetPreferenceMessages.NewVJOProjectPreferencePage_folders_src);
        this.fSrcFolderNameText = this.addTextControl((Composite)sourceFolderGroup, this.fSrcFolderNameLabel, SRCBIN_SRCNAME, 10);
        this.fSrcFolderNameText.addModifyListener(this.fModifyListener);
        return composite;
    }

    private Button addRadioButton(Composite parent, String label, String key, String value, int indent) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = indent;
        Button button = new Button(parent, 16);
        button.setText(label);
        button.setLayoutData((Object)gd);
        button.setSelection(value.equals(this.getPreferenceStore().getString(key)));
        return button;
    }

    private Text addTextControl(Composite parent, Label labelControl, String key, int indent) {
        GridData gd = new GridData();
        gd.horizontalIndent = indent;
        labelControl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(30);
        Text text = new Text(parent, 2052);
        text.setText(this.getPreferenceStore().getString(key));
        text.setLayoutData((Object)gd);
        return text;
    }

    public void performDefaults() {
        boolean folderAsSrc = this.getPreferenceStore().getDefaultBoolean(SRCBIN_FOLDERS_IN_NEWPROJ);
        if (folderAsSrc) {
            this.fFoldersAsSourceFolder.setSelection(true);
            this.fProjectAsSourceFolder.setSelection(false);
            String srcFolderName = this.getPreferenceStore().getDefaultString(SRCBIN_SRCNAME);
            this.fSrcFolderNameText.setText(srcFolderName);
        } else {
            this.fFoldersAsSourceFolder.setSelection(false);
            this.fProjectAsSourceFolder.setSelection(true);
            this.fSrcFolderNameText.setText("");
        }
    }

    public void performOk() {
        if (this.fFoldersAsSourceFolder.getSelection()) {
            this.getPreferenceStore().setValue(SRCBIN_FOLDERS_IN_NEWPROJ, "true");
            this.getPreferenceStore().setValue(SRCBIN_SRCNAME, this.fSrcFolderNameText.getText().trim());
        } else {
            this.getPreferenceStore().setValue(SRCBIN_FOLDERS_IN_NEWPROJ, "false");
            this.getPreferenceStore().setValue(SRCBIN_SRCNAME, "");
        }
    }
}

