/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.internal.ui.wizards;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.internal.ui.dialogs.StatusInfo;
import org.eclipse.dltk.mod.internal.ui.wizards.IBuildpathContainerPage;
import org.eclipse.dltk.mod.internal.ui.wizards.NewWizardMessages;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.dltk.mod.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.wizards.IBuildpathContainerPageExtension;
import org.eclipse.dltk.mod.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class VJetJsBuildPathWizard
extends NewElementWizardPage
implements IBuildpathContainerPage,
IBuildpathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public VJetJsBuildPathWizard() {
        super("VJetDefaultBuildPathWizard");
        this.setTitle(NewWizardMessages.BuildpathContainerDefaultPage_title);
        this.setDescription(NewWizardMessages.BuildpathContainerDefaultPage_description);
        this.setImageDescriptor(DLTKPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(NewWizardMessages.BuildpathContainerDefaultPage_path_label);
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                VJetJsBuildPathWizard.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo status = new StatusInfo();
        String str = this.fEntryField.getText();
        if (str.length() == 0) {
            status.setError(NewWizardMessages.BuildpathContainerDefaultPage_path_error_enterpath);
        } else if (!Path.ROOT.isValidPath(str)) {
            status.setError(NewWizardMessages.BuildpathContainerDefaultPage_path_error_invalidpath);
        } else {
            Path path = new Path(str);
            if (path.segmentCount() == 0) {
                status.setError(NewWizardMessages.BuildpathContainerDefaultPage_path_error_needssegment);
            } else if (this.fUsedPaths.contains(path)) {
                status.setError(NewWizardMessages.BuildpathContainerDefaultPage_path_error_alreadyexists);
            }
        }
        this.updateStatus((IStatus)status);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        this.fEntryField.doFillIntoGrid(composite, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        if (DLTKCore.DEBUG) {
            System.err.println("BuildpathContainerDefaultPage: add help support");
        }
    }

    public boolean finish() {
        return true;
    }

    public IBuildpathEntry getSelection() {
        return DLTKCore.newContainerEntry((IPath)new Path(this.fEntryField.getText()));
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        int i = 0;
        while (i < currentEntries.length) {
            IBuildpathEntry curr = currentEntries[i];
            if (curr.getEntryKind() == 5) {
                this.fUsedPaths.add(curr.getPath());
            }
            ++i;
        }
    }

    public void setSelection(IBuildpathEntry containerEntry) {
        if (containerEntry != null) {
            this.fUsedPaths.remove(containerEntry.getPath());
            this.fEntryField.setText(containerEntry.getPath().toString());
        } else {
            this.fEntryField.setText("org.eclipse.vjet.eclipse.core.JSNATIVE_CONTAINER/JS Native Types");
        }
    }
}

