/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.ui.text.completion;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.ui.DLTKPluginImages;
import org.eclipse.dltk.mod.ui.text.completion.ProposalInfo;
import org.eclipse.dltk.mod.ui.text.completion.ScriptTypeCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.core.IJSType;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.ui.text.completion.CompletionUtils;

public class MethodDeclarationCompletionProposal
extends ScriptTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private static final String PRIVATE_MODIFIER = "private";
    private static final String PROTECTED_MODIFIER = "protected";
    private static final String PUBLIC_MODIFIER = "public";
    private final IType fType;
    private final String fModifier;
    private final String fReturnTypeSig;
    private final String fMethodName;
    private final boolean fIsStatic;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Set suggestedMethods, Collection result, boolean isStatic) throws CoreException {
        IMethod[] methods = type.getMethods();
        if (type instanceof IJSType && !((IJSType)type).isInterface() && "constructs".startsWith(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, "constructs") && suggestedMethods.add("constructs")) {
            result.add(new MethodDeclarationCompletionProposal(type, "constructs", PUBLIC_MODIFIER, null, offset, length, relevance + 500, isStatic));
        }
        if (prefix.length() > 0 && !"base".equals(prefix) && !MethodDeclarationCompletionProposal.hasMethod(methods, prefix) && suggestedMethods.add(prefix)) {
            result.add(new MethodDeclarationCompletionProposal(type, prefix, PUBLIC_MODIFIER, "void", offset, length, relevance, isStatic));
            if (!"main".equals(prefix) || !isStatic) {
                result.add(new MethodDeclarationCompletionProposal(type, prefix, PROTECTED_MODIFIER, "void", offset, length, relevance, isStatic));
                result.add(new MethodDeclarationCompletionProposal(type, prefix, PRIVATE_MODIFIER, "void", offset, length, relevance, isStatic));
            }
        }
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            IMethod curr = methods[i];
            try {
                if (curr.getElementName().equals(name) && curr.getParameters().length == 0) {
                    return true;
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return false;
    }

    public MethodDeclarationCompletionProposal(IType type, String methodName, String modifiers, String returnTypeSig, int start, int length, int relevance, boolean isStatic) {
        super("", type.getSourceModule(), start, length, null, MethodDeclarationCompletionProposal.getDisplayName(methodName, returnTypeSig, modifiers), relevance);
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)methodName);
        this.fType = type;
        this.fMethodName = methodName;
        this.fReturnTypeSig = returnTypeSig;
        this.fModifier = modifiers;
        this.fIsStatic = isStatic;
        if (this.fModifier.equals(PRIVATE_MODIFIER)) {
            this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpri_obj.gif"));
        } else if (this.fModifier.equals(PROTECTED_MODIFIER)) {
            this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpro_obj.gif"));
        } else if (this.fModifier.equals(PUBLIC_MODIFIER)) {
            this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpub_obj.gif"));
        } else {
            this.setImage(DLTKPluginImages.get((String)"org.eclipse.dltk.mod.ui.methpri_obj.gif"));
        }
        if (returnTypeSig == null) {
            this.setProposalInfo(new ProposalInfo((IMember)type));
        }
    }

    private static String getDisplayName(String methodName, String returnTypeSig, String modifier) {
        StringBuffer buf = new StringBuffer();
        buf.append(methodName);
        buf.append('(');
        buf.append(')');
        if (returnTypeSig != null) {
            buf.append("  ");
            buf.append(returnTypeSig);
            buf.append(" - ");
            buf.append("method stub");
        } else {
            buf.append(" - ");
            buf.append("Default constructor");
        }
        return buf.toString();
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset) throws CoreException, BadLocationException {
        TextUtilities.getDefaultLineDelimiter((IDocument)document);
        this.fType.getTypeQualifiedName(".");
        boolean isInterface = false;
        if (this.fType instanceof IJSType) {
            isInterface = ((IJSType)this.fType).isInterface();
        }
        StringBuffer comment = new StringBuffer("//>");
        if (this.fModifier != null) {
            comment.append(this.fModifier);
        } else if (this.fReturnTypeSig != null && !isInterface) {
            comment.append(PRIVATE_MODIFIER);
        } else {
            comment.append(PUBLIC_MODIFIER);
        }
        comment.append(" ");
        if (this.fReturnTypeSig != null) {
            comment.append(this.fReturnTypeSig);
            comment.append(" ");
        } else if (this.fMethodName.indexOf("constructs") != -1) {
            comment.append("");
        } else {
            comment.append(this.fType.getElementName());
            comment.append(" ");
        }
        comment.append(this.fMethodName);
        if (this.isMainMethod()) {
            comment.append("(String ... arguments)");
        } else {
            comment.append("()");
        }
        comment.append('\r');
        comment.append('\n');
        String ident = CompletionUtils.calculateIndent(document, offset);
        StringBuffer completionText = new StringBuffer(comment);
        completionText.append(ident);
        completionText.append(this.fMethodName);
        completionText.append(" : function(");
        if (this.isMainMethod()) {
            completionText.append("");
        }
        completionText.append(") {");
        completionText.append('\r');
        completionText.append('\n');
        completionText.append(ident);
        completionText.append('\t');
        int cursorPosition = completionText.length();
        completionText.append('\r');
        completionText.append('\n');
        completionText.append(ident);
        completionText.append("}");
        if (!this.isInEndOfBlock(offset)) {
            completionText.append(",");
        }
        this.setReplacementString(completionText.toString());
        this.setCursorPosition(cursorPosition);
        return false;
    }

    private boolean isMainMethod() {
        return "main".equals(this.fMethodName) && this.fIsStatic;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return new String();
    }

    public boolean isAutoInsertable() {
        return false;
    }

    protected boolean isValidPrefix(String prefix) {
        super.isValidPrefix(prefix);
        return true;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private boolean isInEndOfBlock(int offset) {
        IJstType type = ((IVjoSourceModule)this.fSourceModule).getJstType();
        List methods = type.getMethods(this.fIsStatic);
        for (IJstMethod method : methods) {
            if (method.getSource().getEndOffSet() <= offset) continue;
            return false;
        }
        return true;
    }
}

