/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IAllocationExpression;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.ReferenceBinding;

public class AllocationExpression
extends Expression
implements InvocationSite,
IAllocationExpression {
    public TypeReference type;
    public Expression[] arguments;
    public Expression member;
    public boolean isShort;

    public Expression enclosingInstance() {
        return null;
    }

    @Override
    public boolean isSuperAccess() {
        return false;
    }

    @Override
    public boolean isTypeAccess() {
        return true;
    }

    @Override
    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append("new ");
        this.member.print(indent, output);
        if (this.type != null) {
            this.type.printExpression(0, output);
        }
        if (!this.isShort) {
            output.append('(');
            if (this.arguments != null) {
                int i = 0;
                while (i < this.arguments.length) {
                    if (i > 0) {
                        output.append(", ");
                    }
                    this.arguments[i].printExpression(0, output);
                    ++i;
                }
            }
            output.append(')');
        }
        return output;
    }

    @Override
    public void setActualReceiverType(ReferenceBinding receiverType) {
    }

    @Override
    public void setDepth(int i) {
    }

    @Override
    public void setFieldIndex(int i) {
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.member != null) {
                this.member.traverse(visitor, scope);
            } else if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int i = 0;
                int argumentsLength = this.arguments.length;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    @Override
    public int getASTType() {
        return 3;
    }

    @Override
    public IExpression getMember() {
        return this.member;
    }
}

