/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.mod.wst.jsdt.core.ast.IProgramElement;
import org.eclipse.mod.wst.jsdt.core.ast.IScriptFileDeclaration;
import org.eclipse.mod.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.mod.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.mod.wst.jsdt.internal.compiler.DelegateASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ImportReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.mod.wst.jsdt.internal.compiler.parser.NLSTag;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortMethod;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.AbortType;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemReporter;
import org.eclipse.mod.wst.jsdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.mod.wst.jsdt.internal.compiler.util.HashtableOfObject;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext,
IScriptFileDeclaration {
    private static final Comparator STRING_LITERAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            StringLiteral literal1 = (StringLiteral)o1;
            StringLiteral literal2 = (StringLiteral)o2;
            return literal1.sourceStart - literal2.sourceStart;
        }
    };
    private static final int STRING_LITERALS_INCREMENT = 10;
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public ProgramElement[] statements;
    public int[][] comments;
    public int numberInferredTypes = 0;
    public HashtableOfObject inferredTypesHash = new HashtableOfObject();
    public boolean typesHaveBeenInferred = false;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public CompilationUnitBinding compilationUnitBinding;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;
    public NLSTag[] nlsTags;
    private StringLiteral[] stringLiterals;
    private int stringLiteralsPtr;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = sourceLength - 1;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        switch (abortLevel) {
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, problem);
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    @Override
    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int end;
            char[] fileName = this.compilationResult.getFileName();
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null && this.statements == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME);
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        if (this.currentPackage != null) {
            CompilationUnitDeclaration.printIndent(indent, output).append("package ");
            this.currentPackage.print(0, output, false).append(";\n");
        }
        if (this.imports != null) {
            i = 0;
            while (i < this.imports.length) {
                if (!this.imports[i].isInternal()) {
                    CompilationUnitDeclaration.printIndent(indent, output).append("import ");
                    ImportReference currentImport = this.imports[i];
                    currentImport.print(0, output).append(";\n");
                }
                ++i;
            }
        }
        if (this.types != null) {
            i = 0;
            while (i < this.types.length) {
                this.types[i].print(indent, output).append("\n");
                ++i;
            }
        }
        if (this.statements != null) {
            i = 0;
            while (i < this.statements.length) {
                this.statements[i].printStatement(indent, output).append("\n");
                ++i;
            }
        }
        return output;
    }

    public void recordStringLiteral(StringLiteral literal) {
        if (this.stringLiterals == null) {
            this.stringLiterals = new StringLiteral[10];
            this.stringLiteralsPtr = 0;
        } else {
            int stackLength = this.stringLiterals.length;
            if (this.stringLiteralsPtr == stackLength) {
                this.stringLiterals = new StringLiteral[stackLength + 10];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stackLength);
            }
        }
        this.stringLiterals[this.stringLiteralsPtr++] = literal;
    }

    /*
     * Unable to fully structure code
     */
    private void reportNLSProblems() {
        block25: {
            block27: {
                block26: {
                    if (this.nlsTags == null && this.stringLiterals == null) break block25;
                    stringLiteralsLength = this.stringLiteralsPtr;
                    v0 = nlsTagsLength = this.nlsTags == null ? 0 : this.nlsTags.length;
                    if (stringLiteralsLength != 0) break block26;
                    if (nlsTagsLength == 0) break block25;
                    i = 0;
                    while (i < nlsTagsLength) {
                        tag = this.nlsTags[i];
                        if (tag != null) {
                            this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
                        }
                        ++i;
                    }
                    break block25;
                }
                if (nlsTagsLength != 0) break block27;
                if (this.stringLiterals.length != stringLiteralsLength) {
                    this.stringLiterals = new StringLiteral[stringLiteralsLength];
                    System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stringLiteralsLength);
                }
                Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
                i = 0;
                while (i < stringLiteralsLength) {
                    this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                    ++i;
                }
                break block25;
            }
            if (this.stringLiterals.length != stringLiteralsLength) {
                this.stringLiterals = new StringLiteral[stringLiteralsLength];
                System.arraycopy(this.stringLiterals, 0, this.stringLiterals, 0, stringLiteralsLength);
            }
            Arrays.sort(this.stringLiterals, CompilationUnitDeclaration.STRING_LITERAL_COMPARATOR);
            indexInLine = 1;
            lastLineNumber = -1;
            literal = null;
            index = 0;
            i = 0;
            block2: while (i < stringLiteralsLength) {
                literal = this.stringLiterals[i];
                literalLineNumber = literal.lineNumber;
                if (lastLineNumber != literalLineNumber) {
                    indexInLine = 1;
                    lastLineNumber = literalLineNumber;
                } else {
                    ++indexInLine;
                }
                if (index >= nlsTagsLength) break;
                while (index < nlsTagsLength) {
                    block24: {
                        tag = this.nlsTags[index];
                        if (tag == null) ** GOTO lbl74
                        tagLineNumber = tag.lineNumber;
                        if (literalLineNumber < tagLineNumber) {
                            this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                        } else if (literalLineNumber == tagLineNumber) {
                            if (tag.index == indexInLine) {
                                this.nlsTags[index] = null;
                                ++index;
                            } else {
                                index2 = index + 1;
                                while (index2 < nlsTagsLength) {
                                    tag2 = this.nlsTags[index2];
                                    if (tag2 != null) {
                                        tagLineNumber2 = tag2.lineNumber;
                                        if (literalLineNumber == tagLineNumber2) {
                                            if (tag2.index == indexInLine) {
                                                this.nlsTags[index2] = null;
                                                break block24;
                                            }
                                        } else {
                                            this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                                            break block24;
                                        }
                                    }
                                    ++index2;
                                }
                                this.scope.problemReporter().nonExternalizedStringLiteral(literal);
                            }
                        } else {
                            this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
lbl74:
                            // 2 sources

                            ++index;
                            continue;
                        }
                    }
                    ++i;
                    continue block2;
                }
                break block2;
            }
            while (i < stringLiteralsLength) {
                this.scope.problemReporter().nonExternalizedStringLiteral(this.stringLiterals[i]);
                ++i;
            }
            if (index < nlsTagsLength) {
                while (index < nlsTagsLength) {
                    tag = this.nlsTags[index];
                    if (tag != null) {
                        this.scope.problemReporter().unnecessaryNLSTags(tag.start, tag.end);
                    }
                    ++index;
                }
            }
        }
    }

    @Override
    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    @Override
    public void traverse(org.eclipse.mod.wst.jsdt.core.ast.ASTVisitor visitor) {
        this.traverse(new DelegateASTVisitor(visitor), null, false);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        this.traverse(visitor, this.scope, false);
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope, boolean ignoreErrors) {
        if (this.ignoreFurtherInvestigation && !ignoreErrors) {
            return;
        }
        try {
            if (visitor.visit(this, this.scope) && this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            visitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {}
    }

    @Override
    public int getASTType() {
        return 93;
    }

    @Override
    public IProgramElement[] getStatements() {
        return this.statements;
    }

    @Override
    public String getInferenceID() {
        if (this.compilationResult.compilationUnit != null) {
            return this.compilationResult.compilationUnit.getInferenceID();
        }
        return null;
    }

    @Override
    public void addImport(char[] importName, int startPosition, int endPosition, int nameStartPosition) {
        ImportReference importReference = new ImportReference(importName, startPosition, endPosition, nameStartPosition);
        if (this.imports == null) {
            this.imports = new ImportReference[]{importReference};
        } else {
            ImportReference[] newImports = new ImportReference[this.imports.length + 1];
            System.arraycopy(this.imports, 0, newImports, 0, this.imports.length);
            newImports[this.imports.length] = importReference;
            this.imports = newImports;
        }
    }
}

