/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mod.wst.jsdt.internal.compiler.ast;

import org.eclipse.mod.wst.jsdt.core.ast.IForeachStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.mod.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ForeachStatement
extends Statement
implements IForeachStatement {
    public LocalDeclaration elementVariable;
    public int elementVariableImplicitWidening = -1;
    public Expression collection;
    public Statement action;
    private int kind;
    private static final int ARRAY = 0;
    private static final int RAW_ITERABLE = 1;
    private static final int GENERIC_ITERABLE = 2;
    private TypeBinding iteratorReceiverType;
    private TypeBinding collectionElementType;
    public BlockScope scope;
    public LocalVariableBinding indexVariable;
    public LocalVariableBinding collectionVariable;
    public LocalVariableBinding maxVariable;
    private static final char[] SecretIndexVariableName = " index".toCharArray();
    private static final char[] SecretCollectionVariableName = " collection".toCharArray();
    private static final char[] SecretMaxVariableName = " max".toCharArray();
    int postCollectionInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForeachStatement(LocalDeclaration elementVariable, int start) {
        this.elementVariable = elementVariable;
        this.sourceStart = start;
        this.kind = -1;
    }

    @Override
    public StringBuffer printStatement(int indent, StringBuffer output) {
        ForeachStatement.printIndent(indent, output).append("for (");
        this.elementVariable.printAsExpression(0, output);
        output.append(" : ");
        this.collection.print(0, output).append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(indent + 1, output);
        }
        return output;
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.elementVariable.traverse(visitor, this.scope);
            this.collection.traverse(visitor, this.scope);
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }

    @Override
    public int getASTType() {
        return 39;
    }
}

